/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.core.vault.objective;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import iskallia.vault.VaultMod;
import iskallia.vault.client.gui.helper.LightmapHelper;
import iskallia.vault.client.gui.helper.ScreenDrawHelper;
import iskallia.vault.core.Version;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.data.adapter.vault.CompoundAdapter;
import iskallia.vault.core.data.adapter.vault.LegacyBlockPosAdapter;
import iskallia.vault.core.data.compound.IntList;
import iskallia.vault.core.data.key.FieldKey;
import iskallia.vault.core.data.key.SupplierKey;
import iskallia.vault.core.data.key.registry.FieldRegistry;
import iskallia.vault.core.event.CommonEvents;
import iskallia.vault.core.event.common.BlockUseEvent;
import iskallia.vault.core.event.common.TemplateGenerationEvent;
import iskallia.vault.core.random.ChunkRandom;
import iskallia.vault.core.random.RandomSource;
import iskallia.vault.core.util.RegionPos;
import iskallia.vault.core.vault.ClassicPortalLogic;
import iskallia.vault.core.vault.PortalLogic;
import iskallia.vault.core.vault.Vault;
import iskallia.vault.core.vault.WorldManager;
import iskallia.vault.core.vault.modifier.spi.VaultModifier;
import iskallia.vault.core.vault.objective.Objective;
import iskallia.vault.core.vault.player.Completion;
import iskallia.vault.core.vault.player.Listener;
import iskallia.vault.core.vault.player.Runner;
import iskallia.vault.core.vault.stat.StatCollector;
import iskallia.vault.core.world.generator.GridGenerator;
import iskallia.vault.core.world.generator.VaultGenerator;
import iskallia.vault.core.world.generator.layout.ClassicInfiniteLayout;
import iskallia.vault.core.world.generator.layout.GridLayout;
import iskallia.vault.core.world.generator.layout.VaultLayout;
import iskallia.vault.core.world.storage.VirtualWorld;
import iskallia.vault.core.world.template.configured.ConfiguredTemplate;
import iskallia.vault.init.ModBlocks;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.init.ModDynamicModels;
import iskallia.vault.world.data.DiscoveredModelsData;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextColor;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.TickTask;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class CakeObjective
extends Objective {
    public static final ResourceLocation CAKE_HUD = VaultMod.id("textures/gui/cake_event_bar.png");
    protected static final ResourceLocation VIGNETTE = VaultMod.id("textures/gui/cake_vignette.png");
    public static final SupplierKey<Objective> KEY = (SupplierKey)SupplierKey.of("cake", Objective.class).with(Version.v1_0, (Objective)((Object)((Supplier<Objective>)CakeObjective::new)));
    public static final FieldRegistry FIELDS = Objective.FIELDS.merge(new FieldRegistry());
    public static final FieldKey<BlockPos> CAKE_POS = (FieldKey)FieldKey.of("cake_pos", BlockPos.class).with(Version.v1_0, LegacyBlockPosAdapter.create().asNullable(), DISK.all().or(CLIENT.all())).register(FIELDS);
    public static final FieldKey<IntList> REGIONS_X = (FieldKey)FieldKey.of("regions_x", IntList.class).with(Version.v1_0, CompoundAdapter.of(() -> IntList.createSegmented(3)), DISK.all()).register(FIELDS);
    public static final FieldKey<IntList> REGIONS_Z = (FieldKey)FieldKey.of("regions_z", IntList.class).with(Version.v1_0, CompoundAdapter.of(() -> IntList.createSegmented(3)), DISK.all()).register(FIELDS);
    public static final FieldKey<Integer> COUNT = (FieldKey)FieldKey.of("count", Integer.class).with(Version.v1_0, Adapters.INT_SEGMENTED_3, DISK.all().or(CLIENT.all())).register(FIELDS);
    public static final FieldKey<Integer> TARGET = (FieldKey)FieldKey.of("target", Integer.class).with(Version.v1_0, Adapters.INT_SEGMENTED_3, DISK.all().or(CLIENT.all())).register(FIELDS);
    public static final FieldKey<ResourceLocation> MODIFIER_POOL = (FieldKey)FieldKey.of("modifier_pool", ResourceLocation.class).with(Version.v1_0, Adapters.IDENTIFIER, DISK.all().or(CLIENT.all())).register(FIELDS);

    protected CakeObjective() {
    }

    protected CakeObjective(ResourceLocation modifierPool) {
        this.set(COUNT, 0);
        this.set(CAKE_POS, null);
        this.set(REGIONS_X, IntList.createSegmented(3));
        this.set(REGIONS_Z, IntList.createSegmented(3));
        this.set(MODIFIER_POOL, modifierPool);
    }

    public static CakeObjective of(ResourceLocation modifierPool) {
        return new CakeObjective(modifierPool);
    }

    public static CakeObjective of(int target, ResourceLocation modifierPool) {
        return (CakeObjective)new CakeObjective(modifierPool).set(TARGET, target);
    }

    @Override
    public SupplierKey<Objective> getKey() {
        return KEY;
    }

    @Override
    public FieldRegistry getFields() {
        return FIELDS;
    }

    @Override
    public void initServer(VirtualWorld world, Vault vault) {
        CommonEvents.BLOCK_USE.in((Level)world).at(BlockUseEvent.Phase.HEAD).of(ModBlocks.CAKE).register(this, data -> {
            MinecraftServer server = data.getWorld().m_142572_();
            if (server == null) {
                return;
            }
            server.m_6937_((Runnable)new TickTask(server.m_129921_() + 1, () -> {
                if (this.has(TARGET) && this.get(COUNT) >= this.get(TARGET)) {
                    return;
                }
                BlockPos pos = data.getPos();
                if (!pos.equals((Object)this.get(CAKE_POS))) {
                    return;
                }
                if (vault.get(Vault.LISTENERS).getObjectivePriority(data.getPlayer().m_142081_(), this) != 0) {
                    return;
                }
                world.m_7731_(pos, Blocks.f_50016_.m_49966_(), 3);
                this.doEatingEffects(world, pos);
                this.onCakeEaten(world, vault, vault.get(Vault.WORLD).get(WorldManager.GENERATOR), data.getPlayer());
            }));
            data.setResult(InteractionResult.SUCCESS);
        });
        CommonEvents.TEMPLATE_GENERATION.at(TemplateGenerationEvent.Phase.PRE).in((LevelWriter)world).register(this, data -> {
            if (data.getRegion().m_123341_() != 0 || data.getRegion().m_123343_() != 0) {
                data.setTemplate(ConfiguredTemplate.EMPTY);
            }
        });
        CommonEvents.BLOCK_USE.in((Level)world).at(BlockUseEvent.Phase.HEAD).of(Blocks.f_50145_).register(this, data -> {
            Listener listener = vault.get(Vault.LISTENERS).get(data.getPlayer().m_142081_());
            if (listener != null) {
                DiscoveredModelsData.get(world).discoverRandomArmorPieceAndBroadcast(data.getPlayer(), ModDynamicModels.Armor.JARDOON_CHEESE, new Random());
            }
        });
        CommonEvents.LISTENER_LEAVE.register(this, data -> {
            if (data.getVault() != vault) {
                return;
            }
            vault.getOptional(Vault.STATS).map(stats -> stats.get(data.getListener())).ifPresent(stats -> {
                stats.modify(StatCollector.OBJECTIVE_EXP_MULTIPLIER, exp -> Float.valueOf(exp.floatValue() * (float)this.get(COUNT).intValue()));
                if (stats.getCompletion() == Completion.COMPLETED && this.get(COUNT) > 75) {
                    data.getListener().getPlayer().ifPresent(player -> DiscoveredModelsData.get(world).discoverRandomArmorPieceAndBroadcast((Player)player, ModDynamicModels.Armor.CAKE, new Random()));
                }
            });
        });
        super.initServer(world, vault);
    }

    @Override
    public void tickServer(VirtualWorld world, Vault vault) {
        if (this.get(CAKE_POS) == null) {
            PortalLogic logic = vault.get(Vault.WORLD).get(WorldManager.PORTAL_LOGIC);
            if (logic instanceof ClassicPortalLogic) {
                ClassicPortalLogic classic = (ClassicPortalLogic)logic;
                classic.getStart().ifPresent(pos -> {
                    pos = pos.m_5484_(vault.get(Vault.WORLD).get(WorldManager.FACING), 9);
                    pos = pos.m_5484_(Direction.DOWN, 1);
                    world.m_7731_((BlockPos)pos, ModBlocks.CAKE.m_49966_(), 3);
                    this.set(CAKE_POS, pos);
                });
            }
        } else if (world.m_8055_(this.get(CAKE_POS)).m_60734_() != ModBlocks.CAKE) {
            RegionPos region = RegionPos.ofBlockPos(this.get(CAKE_POS), vault.get(Vault.WORLD).get(WorldManager.GENERATOR).get(GridGenerator.CELL_X), vault.get(Vault.WORLD).get(WorldManager.GENERATOR).get(GridGenerator.CELL_Z));
            ChunkRandom random = ChunkRandom.any();
            random.setRegionSeed(vault.get(Vault.SEED), region.m_123341_(), region.m_123343_(), 912345678L);
            this.generateCake(world, region, random);
        } else {
            world.m_7726_().m_8450_(this.get(CAKE_POS));
        }
        if (this.has(TARGET) && this.get(COUNT) >= this.get(TARGET)) {
            super.tickServer(world, vault);
        }
    }

    @Override
    public void tickListener(VirtualWorld world, Vault vault, Listener listener) {
        if (listener.getPriority(this) < 0) {
            listener.addObjective(vault, this);
        }
        if (listener instanceof Runner && this.has(TARGET) && this.get(COUNT) >= this.get(TARGET)) {
            super.tickListener(world, vault, listener);
        }
    }

    private void onCakeEaten(VirtualWorld world, Vault vault, VaultGenerator generator, Player player) {
        if (!(generator instanceof GridGenerator)) {
            throw new UnsupportedOperationException("Cake objective requires a grid generator");
        }
        GridGenerator gen = (GridGenerator)generator;
        GridLayout gridLayout = generator.get(GridGenerator.LAYOUT);
        if (!(gridLayout instanceof ClassicInfiniteLayout)) {
            throw new UnsupportedOperationException("Cake objective requires a vault layout");
        }
        ClassicInfiniteLayout layout = (ClassicInfiniteLayout)gridLayout;
        this.modify(COUNT, count -> count + 1);
        RegionPos region = RegionPos.ofBlockPos(this.get(CAKE_POS), gen.get(GridGenerator.CELL_X), gen.get(GridGenerator.CELL_Z));
        List<RegionPos> neighbors = this.getValidNeighbors(vault, layout, region);
        if (this.has(TARGET) && neighbors.isEmpty()) {
            this.set(TARGET, this.get(COUNT));
            return;
        }
        ChunkRandom random = ChunkRandom.any();
        random.setRegionSeed(vault.get(Vault.SEED), region.m_123341_(), region.m_123343_(), 987654321L);
        RegionPos neighbor = neighbors.get(random.nextInt(neighbors.size()));
        this.generateRoom(vault, world, gen, region, neighbor);
        this.generateCake(world, neighbor, random);
        this.get(REGIONS_X).add(neighbor.m_123341_());
        this.get(REGIONS_Z).add(neighbor.m_123343_());
        this.addModifier(world, vault, player, random);
    }

    public void addModifier(VirtualWorld world, Vault vault, Player player, RandomSource random) {
        ArrayList modifiers = new ArrayList(ModConfigs.VAULT_MODIFIER_POOLS.getRandom(this.get(MODIFIER_POOL), vault.get(Vault.LEVEL).get(), random));
        Object2IntOpenHashMap groups = new Object2IntOpenHashMap();
        modifiers.forEach(arg_0 -> CakeObjective.lambda$addModifier$13((Object2IntMap)groups, arg_0));
        ObjectIterator it = groups.object2IntEntrySet().iterator();
        TextComponent suffix = new TextComponent("");
        while (it.hasNext()) {
            Object2IntMap.Entry entry = (Object2IntMap.Entry)it.next();
            suffix.m_7220_(((VaultModifier)entry.getKey()).getChatDisplayNameComponent(entry.getIntValue()));
            if (!it.hasNext()) continue;
            suffix.m_7220_((Component)new TextComponent(", "));
        }
        TextComponent text = new TextComponent("");
        if (modifiers.isEmpty()) {
            text.m_7220_(player.m_5446_()).m_7220_((Component)new TextComponent(" found a ").m_130940_(ChatFormatting.GRAY)).m_7220_((Component)new TextComponent("cake").m_130940_(ChatFormatting.GREEN)).m_7220_((Component)new TextComponent(".").m_130940_(ChatFormatting.GRAY));
        } else {
            text.m_7220_(player.m_5446_()).m_7220_((Component)new TextComponent(" found a ").m_130940_(ChatFormatting.GRAY)).m_7220_((Component)new TextComponent("cake").m_130940_(ChatFormatting.GREEN)).m_7220_((Component)new TextComponent(" and added ").m_130940_(ChatFormatting.GRAY)).m_7220_((Component)suffix).m_7220_((Component)new TextComponent(".").m_130940_(ChatFormatting.GRAY));
        }
        groups.forEach((modifier, count) -> vault.get(Vault.MODIFIERS).addModifier((VaultModifier<?>)modifier, (int)count, true, random));
        for (Listener listener : vault.get(Vault.LISTENERS).getAll()) {
            listener.getPlayer().ifPresent(other -> {
                world.m_6263_(null, other.m_20185_(), other.m_20186_(), other.m_20189_(), SoundEvents.f_12210_, SoundSource.PLAYERS, 0.9f, 1.2f);
                other.m_5661_((Component)text, false);
            });
        }
    }

    private void generateRoom(Vault vault, VirtualWorld world, GridGenerator generator, RegionPos region, RegionPos neighbor) {
        int minX = Math.min(region.m_123341_(), neighbor.m_123341_());
        int minZ = Math.min(region.m_123343_(), neighbor.m_123343_());
        int maxX = Math.max(region.m_123341_(), neighbor.m_123341_());
        int maxZ = Math.max(region.m_123343_(), neighbor.m_123343_());
        for (int x = minX; x <= maxX; ++x) {
            for (int z = minZ; z <= maxZ; ++z) {
                if (x == region.m_123341_() && z == region.m_123343_()) continue;
                generator.generate(vault, (ServerLevelAccessor)world, region.with(x, z));
            }
        }
    }

    private void generateCake(VirtualWorld world, RegionPos region, RandomSource random) {
        int minX = region.m_123341_() * region.getSizeX();
        int minZ = region.m_123343_() * region.getSizeZ();
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        for (int i = 0; i < 5000; ++i) {
            int x = minX + random.nextInt(region.getSizeX());
            int z = minZ + random.nextInt(region.getSizeZ());
            int y = random.nextInt(64);
            pos.m_122178_(x, y, z);
            if (!world.m_8055_((BlockPos)pos).m_60795_() || !world.m_8055_(pos.m_7494_()).m_60795_() || !world.m_8055_(pos.m_7495_()).m_60783_((BlockGetter)world, (BlockPos)pos, Direction.UP)) continue;
            world.m_7731_((BlockPos)pos, ModBlocks.CAKE.m_49966_(), 3);
            this.set(CAKE_POS, pos.m_7949_());
            break;
        }
    }

    private List<RegionPos> getValidNeighbors(Vault vault, ClassicInfiniteLayout layout, RegionPos region) {
        ArrayList<RegionPos> neighbors = new ArrayList<RegionPos>(Arrays.asList(region.add(layout.get(ClassicInfiniteLayout.TUNNEL_SPAN) + 1, 0), region.add(-layout.get(ClassicInfiniteLayout.TUNNEL_SPAN).intValue() - 1, 0), region.add(0, layout.get(ClassicInfiniteLayout.TUNNEL_SPAN) + 1), region.add(0, -layout.get(ClassicInfiniteLayout.TUNNEL_SPAN).intValue() - 1)));
        neighbors.removeIf(r -> {
            for (int i = 0; i < this.get(REGIONS_X).size(); ++i) {
                if (((Integer)this.get(REGIONS_X).get(i)).intValue() != r.m_123341_() || ((Integer)this.get(REGIONS_Z).get(i)).intValue() != r.m_123343_()) continue;
                return true;
            }
            return false;
        });
        neighbors.removeIf(other -> {
            int minX = Math.min(region.m_123341_(), other.m_123341_());
            int minZ = Math.min(region.m_123343_(), other.m_123343_());
            int maxX = Math.max(region.m_123341_(), other.m_123341_());
            int maxZ = Math.max(region.m_123343_(), other.m_123343_());
            for (int x = minX; x <= maxX; ++x) {
                for (int z = minZ; z <= maxZ; ++z) {
                    VaultLayout.PieceType type;
                    if (x == region.m_123341_() && z == region.m_123343_() || (type = layout.getType(vault, region.with(x, z))).isTunnel() || type == VaultLayout.PieceType.ROOM) continue;
                    return true;
                }
            }
            return false;
        });
        return neighbors;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean render(Vault vault, PoseStack matrixStack, Window window, float partialTicks, Player player) {
        if (this.has(TARGET) && this.get(COUNT) >= this.get(TARGET)) {
            boolean rendered = false;
            for (Objective objective : (Objective.ObjList)this.get(CHILDREN)) {
                rendered |= objective.render(vault, matrixStack, window, partialTicks, player);
            }
            if (rendered) {
                return true;
            }
        }
        int width = window.m_85445_();
        int height = window.m_85446_();
        Minecraft mc = Minecraft.m_91087_();
        MultiBufferSource.BufferSource buffer = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
        Font fr = mc.f_91062_;
        float part = this.has(TARGET) ? (float)this.get(COUNT).intValue() / (float)this.get(TARGET).intValue() : 1.0f;
        int midX = width / 2;
        MutableComponent txt = new TextComponent((String)(this.has(TARGET) ? String.valueOf(this.get(COUNT)) + " / ?" : String.valueOf(this.get(COUNT)))).m_130940_(ChatFormatting.LIGHT_PURPLE);
        fr.m_92733_(txt.m_7532_(), (float)midX - (float)mc.f_91062_.m_92852_((FormattedText)txt) / 2.0f, 31.0f, -1, true, matrixStack.m_85850_().m_85861_(), (MultiBufferSource)buffer, false, 0, LightmapHelper.getPackedFullbrightCoords());
        buffer.m_109911_();
        RenderSystem.m_69478_();
        RenderSystem.m_69453_();
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)CAKE_HUD);
        ScreenDrawHelper.drawTexturedQuads(buf -> {
            ScreenDrawHelper.rect((VertexConsumer)buf, matrixStack).at((float)midX - 14.400001f, 3.6f).dim(28.800001f, 25.6f).texVanilla(0.0f, 2.0f, 36.0f, 32.0f).draw();
            ScreenDrawHelper.rect((VertexConsumer)buf, matrixStack).at((float)midX - 12.8f, 5.6f).dim(32.0f * part * 0.8f, 22.4f).texVanilla(2.0f, 40.0f, 32.0f * part, 28.0f).draw();
        });
        if (this.get(CAKE_POS) != null && mc.f_91074_ != null) {
            double distance = Math.sqrt(this.get(CAKE_POS).m_123331_((Vec3i)mc.f_91074_.m_142538_()));
            float alpha = (float)Mth.m_14008_((double)(distance / 22.0), (double)0.0, (double)1.0);
            alpha = (float)Mth.m_14008_((double)(Math.exp((double)alpha - 0.3) - 1.0), (double)0.0, (double)1.0);
            this.renderVignette(TextColor.m_131266_((int)16742330), 0.65f - alpha * 0.72f, width, height);
        }
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)GuiComponent.f_93098_);
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void renderVignette(TextColor color, float alpha, int width, int height) {
        RenderSystem.m_69465_();
        RenderSystem.m_69458_((boolean)false);
        RenderSystem.m_69453_();
        int colorValue = color.m_131265_();
        float b = (float)(colorValue & 0xFF) / 255.0f;
        float g = (float)(colorValue >> 8 & 0xFF) / 255.0f;
        float r = (float)(colorValue >> 16 & 0xFF) / 255.0f;
        RenderSystem.m_157429_((float)r, (float)g, (float)b, (float)alpha);
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157456_((int)0, (ResourceLocation)VIGNETTE);
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder bufferbuilder = tesselator.m_85915_();
        bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        bufferbuilder.m_5483_(0.0, (double)height, -90.0).m_7421_(0.0f, 1.0f).m_5752_();
        bufferbuilder.m_5483_((double)width, (double)height, -90.0).m_7421_(1.0f, 1.0f).m_5752_();
        bufferbuilder.m_5483_((double)width, 0.0, -90.0).m_7421_(1.0f, 0.0f).m_5752_();
        bufferbuilder.m_5483_(0.0, 0.0, -90.0).m_7421_(0.0f, 0.0f).m_5752_();
        tesselator.m_85914_();
        RenderSystem.m_69458_((boolean)true);
        RenderSystem.m_69482_();
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_69453_();
    }

    @Override
    public boolean isActive(VirtualWorld world, Vault vault, Objective objective) {
        if (!(objective != this || this.has(TARGET) && this.get(COUNT) >= this.get(TARGET))) {
            return true;
        }
        for (Objective child : (Objective.ObjList)this.get(CHILDREN)) {
            if (!child.isActive(world, vault, objective)) continue;
            return true;
        }
        return false;
    }

    protected void doEatingEffects(VirtualWorld world, BlockPos pos) {
        for (int i = 0; i < 20; ++i) {
            double d0 = world.f_46441_.nextGaussian() * 0.02;
            double d1 = world.f_46441_.nextGaussian() * 0.02;
            double d2 = world.f_46441_.nextGaussian() * 0.02;
            BlockParticleOption particle = new BlockParticleOption(ParticleTypes.f_123794_, ModBlocks.CAKE.m_49966_());
            world.m_8767_((ParticleOptions)particle, (double)pos.m_123341_() + world.f_46441_.nextDouble() - d0, (double)pos.m_123342_() + world.f_46441_.nextDouble() - d1, (double)pos.m_123343_() + world.f_46441_.nextDouble() - d2, 10, d0, d1, d2, 1.0);
        }
        world.m_5594_(null, pos, SoundEvents.f_11696_, SoundSource.BLOCKS, 1.0f, 0.5f);
    }

    private static /* synthetic */ void lambda$addModifier$13(Object2IntMap groups, VaultModifier modifier) {
        groups.put((Object)modifier, groups.getOrDefault((Object)modifier, 0) + 1);
    }
}

