/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.core.vault.objective;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.vertex.PoseStack;
import iskallia.vault.block.CrakePedestalBlock;
import iskallia.vault.core.Version;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.data.adapter.vault.CompoundAdapter;
import iskallia.vault.core.data.compound.UUIDList;
import iskallia.vault.core.data.key.FieldKey;
import iskallia.vault.core.data.key.SupplierKey;
import iskallia.vault.core.data.key.registry.FieldRegistry;
import iskallia.vault.core.event.CommonEvents;
import iskallia.vault.core.event.common.BlockUseEvent;
import iskallia.vault.core.vault.Vault;
import iskallia.vault.core.vault.objective.Objective;
import iskallia.vault.core.vault.player.Listener;
import iskallia.vault.core.vault.player.Runner;
import iskallia.vault.core.world.storage.VirtualWorld;
import iskallia.vault.init.ModBlocks;
import java.util.function.Supplier;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class CrakePedestalObjective
extends Objective {
    public static final SupplierKey<Objective> KEY = (SupplierKey)SupplierKey.of("crake_pedestal", Objective.class).with(Version.v1_13, (Objective)((Object)((Supplier<Objective>)CrakePedestalObjective::new)));
    public static final FieldRegistry FIELDS = Objective.FIELDS.merge(new FieldRegistry());
    public static final FieldKey<UUIDList> COMPLETED_PLAYERS = (FieldKey)FieldKey.of("completed_players", UUIDList.class).with(Version.v1_13, CompoundAdapter.of(UUIDList::create), DISK.all().or(CLIENT.all())).register(FIELDS);
    public static final FieldKey<Float> OBJECTIVE_PROBABILITY = (FieldKey)FieldKey.of("objective_probability", Float.class).with(Version.v1_13, Adapters.FLOAT, DISK.all()).register(FIELDS);

    protected CrakePedestalObjective() {
        this.set(COMPLETED_PLAYERS, UUIDList.create());
    }

    public CrakePedestalObjective(float objectiveProbability) {
        this.set(COMPLETED_PLAYERS, UUIDList.create());
        this.set(OBJECTIVE_PROBABILITY, Float.valueOf(objectiveProbability));
    }

    public static CrakePedestalObjective of(float objectiveProbability) {
        return new CrakePedestalObjective(objectiveProbability);
    }

    @Override
    public SupplierKey<Objective> getKey() {
        return KEY;
    }

    @Override
    public FieldRegistry getFields() {
        return FIELDS;
    }

    @Override
    public void initServer(VirtualWorld world, Vault vault) {
        CommonEvents.OBJECTIVE_PIECE_GENERATION.register(this, data -> {
            if (data.getVault() != vault) {
                return;
            }
            this.ifPresent(OBJECTIVE_PROBABILITY, probability -> data.setProbability(probability.floatValue()));
        });
        this.registerObjectiveTemplate(world, vault);
        CommonEvents.BLOCK_USE.in((Level)world).at(BlockUseEvent.Phase.HEAD).of(ModBlocks.CRAKE_PEDESTAL).register(this, data -> {
            Runner runner;
            if (data.getHand() != InteractionHand.MAIN_HAND) {
                data.setResult(InteractionResult.SUCCESS);
                return;
            }
            if (((Boolean)data.getState().m_61143_((Property)CrakePedestalBlock.CONSUMED)).booleanValue()) {
                return;
            }
            if (this.get(COMPLETED_PLAYERS).contains(data.getPlayer().m_142081_())) {
                return;
            }
            Listener listener = vault.get(Vault.LISTENERS).get(data.getPlayer().m_142081_());
            if (!(listener instanceof Runner) || !(runner = (Runner)listener).isActive(world, vault, this)) {
                return;
            }
            data.getWorld().m_7731_(data.getPos(), (BlockState)data.getState().m_61124_((Property)CrakePedestalBlock.CONSUMED, (Comparable)Boolean.valueOf(true)), 3);
            this.get(COMPLETED_PLAYERS).add(data.getPlayer().m_142081_());
            data.setResult(InteractionResult.SUCCESS);
        });
    }

    @Override
    public void tickServer(VirtualWorld world, Vault vault) {
        if (vault.get(Vault.LISTENERS).getAll(Runner.class).stream().allMatch(runner -> this.get(COMPLETED_PLAYERS).contains(runner.getId()))) {
            super.tickServer(world, vault);
        }
    }

    @Override
    public void tickListener(VirtualWorld world, Vault vault, Listener listener) {
        if (listener.getPriority(this) < 0) {
            listener.addObjective(vault, this);
        }
        if (this.get(COMPLETED_PLAYERS).contains(listener.get(Listener.ID))) {
            super.tickListener(world, vault, listener);
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean render(Vault vault, PoseStack matrixStack, Window window, float partialTicks, Player player) {
        boolean rendered = false;
        for (Objective objective : (Objective.ObjList)this.get(CHILDREN)) {
            rendered |= objective.render(vault, matrixStack, window, partialTicks, player);
        }
        return rendered;
    }

    @Override
    public boolean isActive(VirtualWorld world, Vault vault, Objective objective) {
        return objective == this;
    }
}

