/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.core.vault.objective;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import iskallia.vault.VaultMod;
import iskallia.vault.client.gui.helper.LightmapHelper;
import iskallia.vault.client.render.IVaultOptions;
import iskallia.vault.core.Version;
import iskallia.vault.core.data.DataMap;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.data.adapter.vault.CompoundAdapter;
import iskallia.vault.core.data.key.FieldKey;
import iskallia.vault.core.data.key.SupplierKey;
import iskallia.vault.core.data.key.registry.FieldRegistry;
import iskallia.vault.core.random.JavaRandom;
import iskallia.vault.core.vault.Vault;
import iskallia.vault.core.vault.VaultUtils;
import iskallia.vault.core.vault.objective.Objective;
import iskallia.vault.core.vault.objective.PvPObjective;
import iskallia.vault.core.vault.objective.elixir.ElixirGoal;
import iskallia.vault.core.vault.objective.elixir.ElixirTask;
import iskallia.vault.core.vault.player.Listener;
import iskallia.vault.core.vault.player.Runner;
import iskallia.vault.core.world.storage.VirtualWorld;
import iskallia.vault.init.ModConfigs;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ElixirObjective
extends Objective {
    public static final ResourceLocation HUD = VaultMod.id("textures/gui/elixir/hud.png");
    public static final SupplierKey<Objective> KEY = (SupplierKey)SupplierKey.of("elixir", Objective.class).with(Version.v1_12, (Objective)((Object)((Supplier<Objective>)ElixirObjective::new)));
    public static final FieldRegistry FIELDS = Objective.FIELDS.merge(new FieldRegistry());
    public static final FieldKey<GoalMap> GOALS = (FieldKey)FieldKey.of("goals", GoalMap.class).with(Version.v1_12, CompoundAdapter.of(GoalMap::new), DISK.all().or(CLIENT.all())).register(FIELDS);

    protected ElixirObjective() {
        this.set(GOALS, new GoalMap());
    }

    public static ElixirObjective create() {
        return new ElixirObjective();
    }

    @Override
    public SupplierKey<Objective> getKey() {
        return KEY;
    }

    @Override
    public FieldRegistry getFields() {
        return FIELDS;
    }

    @Override
    public void initServer(VirtualWorld world, Vault vault) {
        this.get(GOALS).forEach((uuid, goal) -> goal.initServer(world, vault, this, (UUID)uuid));
        super.initServer(world, vault);
    }

    @Override
    public void tickServer(VirtualWorld world, Vault vault) {
        this.get(GOALS).forEach((uuid, goal) -> goal.tickServer(world, vault, this, (UUID)uuid));
        if (this.get(GOALS).areAllCompleted(vault)) {
            super.tickServer(world, vault);
        }
    }

    @Override
    public void releaseServer() {
        this.get(GOALS).forEach((uuid, goal) -> goal.releaseServer());
        super.releaseServer();
    }

    @Override
    public void tickListener(VirtualWorld world, Vault vault, Listener listener) {
        ElixirGoal goal;
        if (listener instanceof Runner) {
            Runner runner = (Runner)listener;
            if (listener.getPriority(this) < 0) {
                listener.addObjective(vault, this);
                this.generateGoal(world, vault, runner);
            }
        }
        if ((goal = (ElixirGoal)this.get(GOALS).get(listener.get(Listener.ID))) != null && goal.isCompleted()) {
            super.tickListener(world, vault, listener);
        }
    }

    private void generateGoal(VirtualWorld world, Vault vault, Runner listener) {
        ElixirGoal goal = new ElixirGoal();
        this.get(GOALS).put(listener.get(Listener.ID), goal);
        JavaRandom random = VaultUtils.isPvPVault(vault) ? JavaRandom.ofInternal(vault.get(Vault.SEED)) : JavaRandom.ofInternal(vault.get(Vault.SEED) ^ listener.get(Listener.ID).getMostSignificantBits());
        goal.set(ElixirGoal.TARGET, ModConfigs.ELIXIR.generateTarget(vault.get(Vault.LEVEL).get(), random));
        goal.set(ElixirGoal.BASE_TARGET, goal.get(ElixirGoal.TARGET));
        for (ElixirTask task : ModConfigs.ELIXIR.generateGoals(vault.get(Vault.LEVEL).get(), random)) {
            goal.get(ElixirGoal.TASKS).add(task);
        }
        goal.initServer(world, vault, this, listener.getId());
    }

    public void addProgress(UUID listener, int elixir, Vault vault) {
        ElixirGoal goal = (ElixirGoal)this.get(GOALS).get(listener);
        if (goal == null) {
            return;
        }
        int remainder = goal.add(elixir);
        if (VaultUtils.isPvPVault(vault) && goal.isCompleted()) {
            return;
        }
        JavaRandom random = JavaRandom.ofNanoTime();
        ArrayList targets = new ArrayList(this.get(GOALS).keySet());
        targets.remove(listener);
        while (!targets.isEmpty() && remainder > 0) {
            int index = random.nextInt(targets.size());
            remainder = ((ElixirGoal)this.get(GOALS).get(targets.get(index))).add(remainder);
            targets.remove(index);
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean render(Vault vault, PoseStack matrixStack, Window window, float partialTicks, Player player) {
        int total;
        int current;
        MutableComponent txt;
        PvPObjective objective;
        ElixirGoal goal = (ElixirGoal)this.get(GOALS).get(player.m_142081_());
        List<PvPObjective> objs = vault.get(Vault.OBJECTIVES).getAll(PvPObjective.class);
        if (!objs.isEmpty() && !(objective = objs.get(0)).has(PvPObjective.COUNTDOWN_FINISHED)) {
            return false;
        }
        if (goal == null || this.get(GOALS).areAllCompleted(vault)) {
            boolean rendered = false;
            for (Objective objective2 : (Objective.ObjList)this.get(CHILDREN)) {
                rendered |= objective2.render(vault, matrixStack, window, partialTicks, player);
            }
            if (rendered) {
                return true;
            }
        }
        if (goal == null) {
            return true;
        }
        if (goal.isCompleted()) {
            if (VaultUtils.isPvPVault(vault)) {
                txt = new TextComponent("Find a Lodestone!").m_130940_(ChatFormatting.WHITE);
                current = goal.get(ElixirGoal.TARGET);
                total = goal.get(ElixirGoal.TARGET);
            } else {
                Collection<Runner> runners = vault.get(Vault.LISTENERS).getAll(Runner.class);
                if (runners.size() > 1) {
                    txt = new TextComponent("Assist your Allies!").m_130940_(ChatFormatting.WHITE);
                    current = this.get(GOALS).getTotalCurrent(vault);
                    total = this.get(GOALS).getTotalTarget(vault);
                } else {
                    txt = new TextComponent("Find a Lodestone!").m_130940_(ChatFormatting.WHITE);
                    current = goal.get(ElixirGoal.TARGET);
                    total = goal.get(ElixirGoal.TARGET);
                }
            }
        } else {
            txt = new TextComponent("Gather").m_130940_(ChatFormatting.WHITE).m_7220_((Component)new TextComponent(" Elixir ").m_130948_(Style.f_131099_.m_178520_(13390079))).m_7220_((Component)new TextComponent("from loot, ores & mobs!").m_130940_(ChatFormatting.WHITE));
            current = goal.get(ElixirGoal.CURRENT);
            total = goal.get(ElixirGoal.TARGET);
        }
        int midX = window.m_85445_() / 2;
        float userScale = ((IVaultOptions)Minecraft.m_91087_().f_91066_).getObjectiveScale();
        matrixStack.m_85836_();
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int previousTexture = RenderSystem.m_157203_((int)0);
        RenderSystem.m_157456_((int)0, (ResourceLocation)HUD);
        float progress = (float)current / (float)total;
        matrixStack.m_85837_((double)((float)midX - 80.0f * userScale), (double)(8.0f * userScale), 0.0);
        matrixStack.m_85841_(userScale, userScale, userScale);
        GuiComponent.m_93133_((PoseStack)matrixStack, (int)0, (int)0, (float)0.0f, (float)0.0f, (int)200, (int)26, (int)200, (int)50);
        GuiComponent.m_93133_((PoseStack)matrixStack, (int)0, (int)8, (float)0.0f, (float)28.0f, (int)(15 + (int)(130.0f * progress)), (int)10, (int)200, (int)50);
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157453_((int)0, (int)previousTexture);
        matrixStack.m_85849_();
        Font font = Minecraft.m_91087_().f_91062_;
        MultiBufferSource.BufferSource buffer = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
        matrixStack.m_85836_();
        float baseScale = 0.6f;
        float totalScale = baseScale * userScale;
        matrixStack.m_85841_(totalScale, totalScale, totalScale);
        FormattedCharSequence formattedCharSequence = txt.m_7532_();
        float f = (float)midX / totalScale - (float)font.m_92852_((FormattedText)txt) / 2.0f;
        Objects.requireNonNull(font);
        font.m_92733_(formattedCharSequence, f, (float)(9 + 22), -1, true, matrixStack.m_85850_().m_85861_(), (MultiBufferSource)buffer, false, 0, LightmapHelper.getPackedFullbrightCoords());
        buffer.m_109911_();
        matrixStack.m_85849_();
        return true;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void renderPartyInfo(PoseStack matrixStack, UUID playerUUID) {
        super.renderPartyInfo(matrixStack, playerUUID);
        ElixirGoal goal = (ElixirGoal)this.get(GOALS).get(playerUUID);
        if (goal == null) {
            return;
        }
        int current = goal.get(ElixirGoal.CURRENT);
        int total = goal.get(ElixirGoal.TARGET);
        matrixStack.m_85836_();
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int previousTexture = RenderSystem.m_157203_((int)0);
        RenderSystem.m_157456_((int)0, (ResourceLocation)HUD);
        float progress = (float)current / (float)total;
        matrixStack.m_85837_(-120.0, -2.0, 0.0);
        matrixStack.m_85841_(0.5f, 0.5f, 0.5f);
        GuiComponent.m_93133_((PoseStack)matrixStack, (int)0, (int)0, (float)0.0f, (float)0.0f, (int)200, (int)26, (int)200, (int)50);
        GuiComponent.m_93133_((PoseStack)matrixStack, (int)0, (int)8, (float)0.0f, (float)28.0f, (int)(15 + (int)(130.0f * progress)), (int)10, (int)200, (int)50);
        RenderSystem.m_157453_((int)0, (int)previousTexture);
        matrixStack.m_85849_();
    }

    @Override
    public boolean isActive(VirtualWorld world, Vault vault, Objective objective) {
        if (!this.get(GOALS).areAllCompleted(vault)) {
            return objective == this;
        }
        for (Objective child : (Objective.ObjList)this.get(CHILDREN)) {
            if (!child.isActive(world, vault, objective)) continue;
            return true;
        }
        return false;
    }

    public static class GoalMap
    extends DataMap<GoalMap, UUID, ElixirGoal> {
        public GoalMap() {
            super(new HashMap(), Adapters.UUID, CompoundAdapter.of(ElixirGoal::new));
        }

        public boolean areAllCompleted(Vault vault) {
            for (Runner runner : vault.get(Vault.LISTENERS).getAll(Runner.class)) {
                if (!this.containsKey(runner.getId()) || ((ElixirGoal)this.get(runner.getId())).isCompleted()) continue;
                return false;
            }
            return true;
        }

        public int getTotalCurrent(Vault vault) {
            int current = 0;
            for (Runner runner : vault.get(Vault.LISTENERS).getAll(Runner.class)) {
                if (!this.containsKey(runner.getId())) continue;
                current += ((ElixirGoal)this.get(runner.getId())).get(ElixirGoal.CURRENT).intValue();
            }
            return current;
        }

        public int getTotalTarget(Vault vault) {
            int target = 0;
            for (Runner runner : vault.get(Vault.LISTENERS).getAll(Runner.class)) {
                if (!this.containsKey(runner.getId())) continue;
                target += ((ElixirGoal)this.get(runner.getId())).get(ElixirGoal.TARGET).intValue();
            }
            return target;
        }
    }
}

