/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.core.vault.objective;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import iskallia.vault.VaultMod;
import iskallia.vault.core.Version;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.data.key.FieldKey;
import iskallia.vault.core.data.key.SupplierKey;
import iskallia.vault.core.data.key.registry.FieldRegistry;
import iskallia.vault.core.event.CommonEvents;
import iskallia.vault.core.random.JavaRandom;
import iskallia.vault.core.vault.Vault;
import iskallia.vault.core.vault.objective.Objective;
import iskallia.vault.core.vault.player.Listener;
import iskallia.vault.core.vault.player.Runner;
import iskallia.vault.core.world.storage.VirtualWorld;
import iskallia.vault.init.ModItems;
import iskallia.vault.item.ItemVaultCrystalSeal;
import iskallia.vault.task.GreedTask;
import iskallia.vault.task.ProgressConfiguredTask;
import iskallia.vault.task.Task;
import iskallia.vault.task.TaskContext;
import iskallia.vault.task.counter.TargetTaskCounter;
import iskallia.vault.task.counter.TaskCounter;
import iskallia.vault.task.renderer.context.GreedTaskRendererContext;
import iskallia.vault.task.source.EntityTaskSource;
import iskallia.vault.task.source.TaskSource;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class GreedObjective
extends Objective {
    public static final SupplierKey<Objective> KEY = (SupplierKey)SupplierKey.of("greed", Objective.class).with(Version.v1_37, (Objective)((Object)((Supplier<Objective>)GreedObjective::new)));
    public static final FieldRegistry FIELDS = Objective.FIELDS.merge(new FieldRegistry());
    public static final FieldKey<Integer> TIER = (FieldKey)FieldKey.of("tier", Integer.class).with(Version.v1_37, Adapters.INT, DISK.all().or(CLIENT.all())).register(FIELDS);
    public static final FieldKey<Task> TASK = (FieldKey)FieldKey.of("task", Task.class).with(Version.v1_37, Adapters.TASK_NBT, DISK.all().or(CLIENT.all())).register(FIELDS);
    public static final FieldKey<TaskSource> TASK_SOURCE = (FieldKey)FieldKey.of("task_source", TaskSource.class).with(Version.v1_37, Adapters.TASK_SOURCE_NBT, DISK.all().or(CLIENT.all())).register(FIELDS);
    public static final FieldKey<Integer> JOINED = (FieldKey)FieldKey.of("joined", Integer.class).with(Version.v1_37, Adapters.INT_SEGMENTED_3, DISK.all().or(CLIENT.all())).register(FIELDS);

    protected GreedObjective() {
    }

    public static GreedObjective of(GreedTask task, int tier) {
        return (GreedObjective)((Objective)new GreedObjective().set(TASK, task)).set(TIER, tier);
    }

    @Override
    public SupplierKey<Objective> getKey() {
        return KEY;
    }

    @Override
    public FieldRegistry getFields() {
        return FIELDS;
    }

    private TaskContext getContext(VirtualWorld world, Vault vault) {
        this.setIfAbsent(TASK_SOURCE, () -> EntityTaskSource.ofUuids(JavaRandom.ofInternal(vault.get(Vault.SEED)), new UUID[0]));
        return TaskContext.of(this.get(TASK_SOURCE), world.m_142572_()).setVault(vault);
    }

    public boolean isAllTasksCompleted() {
        GreedTask greed;
        Task task = this.get(TASK);
        return task instanceof GreedTask && (greed = (GreedTask)task).areAllCompleted();
    }

    @Override
    public void initServer(VirtualWorld world, Vault vault) {
        CommonEvents.LISTENER_JOIN.register(this, data -> {
            if (data.getVault() != vault) {
                return;
            }
            Listener patt3622$temp = data.getListener();
            if (!(patt3622$temp instanceof Runner)) {
                return;
            }
            Runner runner = (Runner)patt3622$temp;
            TaskSource patt3695$temp = this.get(TASK_SOURCE);
            if (patt3695$temp instanceof EntityTaskSource) {
                EntityTaskSource source = (EntityTaskSource)patt3695$temp;
                source.add(runner.getId());
            }
            this.set(JOINED, this.getOr(JOINED, 0) + 1);
        });
        CommonEvents.LISTENER_LEAVE.register(this, data -> {
            if (data.getVault() != vault) {
                return;
            }
            Listener patt4010$temp = data.getListener();
            if (!(patt4010$temp instanceof Runner)) {
                return;
            }
            Runner runner = (Runner)patt4010$temp;
            TaskSource patt4083$temp = this.get(TASK_SOURCE);
            if (patt4083$temp instanceof EntityTaskSource) {
                EntityTaskSource source = (EntityTaskSource)patt4083$temp;
                source.remove(runner.getId());
            }
        });
        this.get(TASK).onAttach(this.getContext(world, vault));
        CommonEvents.GREED_PILLAR_UPDATE.register(this, data -> {
            if (data.getLevel() != world) {
                return;
            }
            data.getEntity().setCompletedTasks(this.getCompletedTasks());
        });
        super.initServer(world, vault);
    }

    @Override
    public void tickServer(VirtualWorld world, Vault vault) {
        Task task2;
        if (this.isAllTasksCompleted()) {
            super.tickServer(world, vault);
        }
        if (world.getTickCount() % 20 == 0 && (task2 = this.get(TASK)) instanceof GreedTask) {
            GreedTask root = (GreedTask)task2;
            for (int index = 0; index < root.getAmount(); ++index) {
                if (root.isCompleted(index)) continue;
                root.getChild(index).streamSelfAndDescendants(ProgressConfiguredTask.class).forEach(task -> {
                    TargetTaskCounter counter;
                    TaskCounter patt5047$temp = task.getCounter();
                    if (!(patt5047$temp instanceof TargetTaskCounter) || !(counter = (TargetTaskCounter)patt5047$temp).isPopulated()) {
                        return;
                    }
                    counter.get("targetPlayerContribution", Adapters.DOUBLE).ifPresent(contribution -> {
                        int additional = Math.max(this.getOr(JOINED, 0) - 1, 0);
                        Object patt5390$temp = counter.getBaseTarget();
                        if (patt5390$temp instanceof Integer) {
                            Integer base = (Integer)patt5390$temp;
                            counter.setTarget((int)((double)base.intValue() + (double)additional * contribution * (double)base.intValue()));
                        } else {
                            Object patt5572$temp = counter.getBaseTarget();
                            if (patt5572$temp instanceof Float) {
                                Float base = (Float)patt5572$temp;
                                counter.setTarget(Float.valueOf((float)((double)base.floatValue() + (double)additional * contribution * (double)base.floatValue())));
                            } else {
                                throw new UnsupportedOperationException();
                            }
                        }
                    });
                    counter.get("greedTierScaler", Adapters.DOUBLE).ifPresent(scaler -> {
                        VaultMod.LOGGER.info("Scaled task {} with greed scaler {}", (Object)task.getId(), scaler);
                        Object patt6100$temp = counter.getBaseTarget();
                        if (patt6100$temp instanceof Integer) {
                            Integer base = (Integer)patt6100$temp;
                            counter.setTarget((int)((double)base.intValue() * scaler));
                        } else {
                            Object patt6256$temp = counter.getBaseTarget();
                            if (patt6256$temp instanceof Float) {
                                Float base = (Float)patt6256$temp;
                                counter.setTarget(Float.valueOf((float)((double)base.floatValue() * scaler)));
                            } else {
                                throw new UnsupportedOperationException();
                            }
                        }
                    });
                });
            }
        }
    }

    public int getCompletedTasks() {
        int n;
        Task task = this.get(TASK);
        if (task instanceof GreedTask) {
            GreedTask greed = (GreedTask)task;
            n = greed.getCompletedTasks();
        } else {
            n = 0;
        }
        return n;
    }

    @Override
    public void tickListener(VirtualWorld world, Vault vault, Listener listener) {
        if (listener instanceof Runner && listener.getPriority(this) < 0) {
            listener.addObjective(vault, this);
        }
        if (listener instanceof Runner) {
            Runner runner = (Runner)listener;
            if (this.getCompletedTasks() > 0) {
                super.tickListener(world, vault, listener);
            }
        }
    }

    @Override
    public void releaseServer() {
        this.get(TASK).onDetach();
        super.releaseServer();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean render(Vault vault, PoseStack poseStack, Window window, float partialTicks, Player player) {
        GreedTaskRendererContext context = new GreedTaskRendererContext(poseStack, partialTicks, MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_()), Minecraft.m_91087_().f_91062_);
        this.get(TASK).onRender(context);
        return true;
    }

    @Override
    public boolean isActive(VirtualWorld world, Vault vault, Objective objective) {
        if (!this.isAllTasksCompleted()) {
            return objective == this;
        }
        for (Objective child : (Objective.ObjList)this.get(CHILDREN)) {
            if (!child.isActive(world, vault, objective)) continue;
            return true;
        }
        return false;
    }

    public ItemStack createSeal() {
        ItemStack stack = new ItemStack((ItemLike)ModItems.CRYSTAL_SEAL_GREED);
        ItemVaultCrystalSeal.setGreedTier(stack, Math.max(this.get(TIER) - 1, 0));
        return stack;
    }
}

