/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.core.vault.objective;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import iskallia.vault.client.gui.helper.LightmapHelper;
import iskallia.vault.core.Version;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.data.adapter.vault.CompoundAdapter;
import iskallia.vault.core.data.compound.UUIDList;
import iskallia.vault.core.data.key.FieldKey;
import iskallia.vault.core.data.key.SupplierKey;
import iskallia.vault.core.data.key.registry.FieldRegistry;
import iskallia.vault.core.event.CommonEvents;
import iskallia.vault.core.event.common.BlockUseEvent;
import iskallia.vault.core.vault.Vault;
import iskallia.vault.core.vault.objective.Objective;
import iskallia.vault.core.vault.player.Listener;
import iskallia.vault.core.vault.player.Runner;
import iskallia.vault.core.world.storage.VirtualWorld;
import iskallia.vault.init.ModBlocks;
import iskallia.vault.init.ModNetwork;
import iskallia.vault.network.message.ClientboundOpenGreedContinueScreen;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkDirection;

public class GreedPillarObjective
extends Objective {
    public static final SupplierKey<Objective> KEY = (SupplierKey)SupplierKey.of("greed_pillar", Objective.class).with(Version.v1_37, (Objective)((Object)((Supplier<Objective>)GreedPillarObjective::new)));
    public static final FieldRegistry FIELDS = Objective.FIELDS.merge(new FieldRegistry());
    public static final FieldKey<Float> OBJECTIVE_PROBABILITY = (FieldKey)FieldKey.of("objective_probability", Float.class).with(Version.v1_37, Adapters.FLOAT, DISK.all()).register(FIELDS);
    public static final FieldKey<UUIDList> COMPLETED_PLAYERS = (FieldKey)FieldKey.of("completed_players", UUIDList.class).with(Version.v1_37, CompoundAdapter.of(UUIDList::create), DISK.all().or(CLIENT.all())).register(FIELDS);
    public static final FieldKey<Void> NOTIFIED = (FieldKey)FieldKey.of("notified", Void.class).with(Version.v1_37, Adapters.ofVoid(), DISK.all().or(CLIENT.all())).register(FIELDS);

    public GreedPillarObjective() {
        this.set(COMPLETED_PLAYERS, UUIDList.create());
    }

    public static GreedPillarObjective of(float objectiveProbability) {
        return (GreedPillarObjective)new GreedPillarObjective().set(OBJECTIVE_PROBABILITY, Float.valueOf(objectiveProbability));
    }

    @Override
    public SupplierKey<Objective> getKey() {
        return KEY;
    }

    @Override
    public FieldRegistry getFields() {
        return FIELDS;
    }

    @Override
    public void initServer(VirtualWorld world, Vault vault) {
        CommonEvents.OBJECTIVE_PIECE_GENERATION.register(this, data -> {
            if (data.getVault() != vault) {
                return;
            }
            this.ifPresent(OBJECTIVE_PROBABILITY, probability -> data.setProbability(probability.floatValue()));
        });
        this.registerObjectiveTemplate(world, vault);
        CommonEvents.BLOCK_USE.in((Level)world).at(BlockUseEvent.Phase.HEAD).of(ModBlocks.GREED_PILLAR).register(this, data -> {
            Runner runner;
            Player patt3725$temp = data.getPlayer();
            if (patt3725$temp instanceof ServerPlayer) {
                ServerPlayer sPlayer = (ServerPlayer)patt3725$temp;
                ModNetwork.CHANNEL.sendTo((Object)new ClientboundOpenGreedContinueScreen(), sPlayer.f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
                return;
            }
            if (data.getHand() != InteractionHand.MAIN_HAND) {
                data.setResult(InteractionResult.SUCCESS);
                return;
            }
            if (this.get(COMPLETED_PLAYERS).contains(data.getPlayer().m_142081_())) {
                return;
            }
            Listener listener = vault.get(Vault.LISTENERS).get(data.getPlayer().m_142081_());
            if (!(listener instanceof Runner) || !(runner = (Runner)listener).isActive(world, vault, this)) {
                data.setResult(InteractionResult.SUCCESS);
                return;
            }
            this.get(COMPLETED_PLAYERS).add(data.getPlayer().m_142081_());
            data.setResult(InteractionResult.SUCCESS);
        });
    }

    @Override
    public void tickServer(VirtualWorld world, Vault vault) {
        if (!this.has(NOTIFIED)) {
            for (Listener listener : vault.get(Vault.LISTENERS).getAll()) {
                listener.getPlayer().ifPresent(other -> {
                    MutableComponent text = new TextComponent("").m_7220_((Component)new TextComponent("Greed Pillars")).m_7220_((Component)new TextComponent(" are now open!").m_130940_(ChatFormatting.GRAY));
                    world.m_6263_(null, other.m_20185_(), other.m_20186_(), other.m_20189_(), SoundEvents.f_11736_, SoundSource.PLAYERS, 0.9f, 1.2f);
                    other.m_5661_((Component)text, false);
                });
            }
            this.set(NOTIFIED);
        }
        if (vault.get(Vault.LISTENERS).getAll(Runner.class).stream().allMatch(runner -> this.get(COMPLETED_PLAYERS).contains(runner.getId()))) {
            super.tickServer(world, vault);
        }
    }

    @Override
    public void tickListener(VirtualWorld world, Vault vault, Listener listener) {
        if (this.get(COMPLETED_PLAYERS).contains(listener.get(Listener.ID))) {
            super.tickListener(world, vault, listener);
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean render(Vault vault, PoseStack matrixStack, Window window, float partialTicks, Player player) {
        if (this.get(COMPLETED_PLAYERS).contains(player.m_142081_())) {
            boolean rendered = false;
            for (Objective objective : (Objective.ObjList)this.get(CHILDREN)) {
                rendered |= objective.render(vault, matrixStack, window, partialTicks, player);
            }
            return rendered;
        }
        int midX = window.m_85445_() / 2;
        Font font = Minecraft.m_91087_().f_91062_;
        MultiBufferSource.BufferSource buffer = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
        MutableComponent text = new TextComponent("Find Greed Pillar!").m_130940_(ChatFormatting.AQUA);
        FormattedCharSequence formattedCharSequence = text.m_7532_();
        float f = (float)midX - (float)font.m_92852_((FormattedText)text) / 2.0f;
        Objects.requireNonNull(font);
        font.m_92733_(formattedCharSequence, f, 9.0f, -1, true, matrixStack.m_85850_().m_85861_(), (MultiBufferSource)buffer, false, 0, LightmapHelper.getPackedFullbrightCoords());
        buffer.m_109911_();
        return true;
    }

    @Override
    public boolean isActive(VirtualWorld world, Vault vault, Objective objective) {
        return objective == this;
    }
}

