/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.core.vault.objective;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import iskallia.vault.VaultMod;
import iskallia.vault.block.HeraldControllerBlock;
import iskallia.vault.block.PlaceholderBlock;
import iskallia.vault.block.VaultChestBlock;
import iskallia.vault.block.item.HeraldTrophyItem;
import iskallia.vault.core.Version;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.data.adapter.basic.EnumAdapter;
import iskallia.vault.core.data.adapter.vault.LegacyBlockPosAdapter;
import iskallia.vault.core.data.key.FieldKey;
import iskallia.vault.core.data.key.PaletteKey;
import iskallia.vault.core.data.key.SupplierKey;
import iskallia.vault.core.data.key.TemplateKey;
import iskallia.vault.core.data.key.registry.FieldRegistry;
import iskallia.vault.core.event.ClientEvents;
import iskallia.vault.core.event.CommonEvents;
import iskallia.vault.core.event.common.BlockSetEvent;
import iskallia.vault.core.event.common.BlockUseEvent;
import iskallia.vault.core.random.ChunkRandom;
import iskallia.vault.core.vault.ClassicPortalLogic;
import iskallia.vault.core.vault.Vault;
import iskallia.vault.core.vault.VaultRegistry;
import iskallia.vault.core.vault.WorldManager;
import iskallia.vault.core.vault.objective.HeraldMusicHandler;
import iskallia.vault.core.vault.objective.Objective;
import iskallia.vault.core.vault.player.ClassicListenersLogic;
import iskallia.vault.core.vault.player.Listener;
import iskallia.vault.core.vault.player.Listeners;
import iskallia.vault.core.vault.player.ListenersLogic;
import iskallia.vault.core.vault.stat.StatCollector;
import iskallia.vault.core.vault.time.TickClock;
import iskallia.vault.core.world.data.entity.PartialCompoundNbt;
import iskallia.vault.core.world.data.tile.PartialBlockState;
import iskallia.vault.core.world.data.tile.PartialTile;
import iskallia.vault.core.world.processor.ProcessorContext;
import iskallia.vault.core.world.processor.tile.RotateTileProcessor;
import iskallia.vault.core.world.processor.tile.TileProcessor;
import iskallia.vault.core.world.processor.tile.TranslateTileProcessor;
import iskallia.vault.core.world.storage.VirtualWorld;
import iskallia.vault.core.world.template.JigsawTemplate;
import iskallia.vault.core.world.template.PlacementSettings;
import iskallia.vault.core.world.template.Template;
import iskallia.vault.entity.boss.ArtifactBossEntity;
import iskallia.vault.init.ModBlocks;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.init.ModDynamicModels;
import iskallia.vault.init.ModEntities;
import iskallia.vault.init.ModSounds;
import iskallia.vault.item.CatalystInhibitorItem;
import iskallia.vault.mixin.AccessorChunkMap;
import iskallia.vault.mixin.AccessorClientLevel;
import iskallia.vault.world.data.DiscoveredModelsData;
import iskallia.vault.world.data.PlayerGreedData;
import java.util.ArrayList;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundLevelChunkWithLightPacket;
import net.minecraft.network.protocol.game.ClientboundSoundPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.TickTask;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.entity.EntityAccess;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.eventbus.api.EventPriority;
import org.apache.commons.lang3.mutable.MutableObject;

public class HeraldObjective
extends Objective {
    private static final ResourceLocation HUD = VaultMod.id("textures/gui/boss/herald_bar.png");
    public static final SupplierKey<Objective> KEY = (SupplierKey)SupplierKey.of("herald", Objective.class).with(Version.v1_19, (Objective)((Object)((Supplier<Objective>)() -> new HeraldObjective())));
    public static final FieldRegistry FIELDS = Objective.FIELDS.merge(new FieldRegistry());
    public static final FieldKey<UUID> BOSS_ID = (FieldKey)FieldKey.of("boss_id", UUID.class).with(Version.v1_19, Adapters.UUID.asNullable(), DISK.all().or(CLIENT.all())).register(FIELDS);
    public static final FieldKey<BlockPos> BOSS_POS = (FieldKey)FieldKey.of("boss_pos", BlockPos.class).with(Version.v1_19, LegacyBlockPosAdapter.create().asNullable(), DISK.all()).register(FIELDS);
    public static final FieldKey<Direction> BOSS_FACING = (FieldKey)FieldKey.of("boss_direction", Direction.class).with(Version.v1_19, Adapters.ofEnum(Direction.class, EnumAdapter.Mode.NAME).asNullable(), DISK.all()).register(FIELDS);
    public static final FieldKey<Void> BOSS_DEAD = (FieldKey)FieldKey.of("boss_dead", Void.class).with(Version.v1_19, Adapters.ofVoid(), DISK.all().or(CLIENT.all())).register(FIELDS);
    public static final FieldKey<Integer> TIMER = (FieldKey)FieldKey.of("timer", Integer.class).with(Version.v1_19, Adapters.INT_SEGMENTED_7.asNullable(), DISK.all().or(CLIENT.all())).register(FIELDS);
    public static final FieldKey<Float> PROGRESS = (FieldKey)FieldKey.of("progress", Float.class).with(Version.v1_19, Adapters.FLOAT.asNullable(), DISK.all().or(CLIENT.all())).register(FIELDS);

    protected HeraldObjective() {
    }

    public static HeraldObjective of() {
        return new HeraldObjective();
    }

    @Override
    public SupplierKey<Objective> getKey() {
        return KEY;
    }

    @Override
    public FieldRegistry getFields() {
        return FIELDS;
    }

    @Override
    public void initServer(VirtualWorld world, Vault vault) {
        CommonEvents.PLAYER_ACTION.register(this, data -> {
            if (data.getWorld() != world || data.getGameMode() != GameType.ADVENTURE) {
                return;
            }
            if (this.isWhitelisted(data.getWorld().m_8055_(data.getPos()))) {
                data.setRestricted(false);
            }
        });
        CommonEvents.PLAYER_MINE.register((Object)this, EventPriority.HIGHEST, true, event -> {
            if (event.getWorld() != world) {
                return;
            }
            if (this.isWhitelisted(event.getState())) {
                event.setCanceled(false);
            }
        });
        CommonEvents.ENTITY_DEATH.register(this, event -> {
            if (event.getEntity().m_142081_().equals(this.get(BOSS_ID))) {
                if (event.getEntity().f_19853_ != world) {
                    return;
                }
                this.set(BOSS_DEAD);
                this.set(TIMER, 224);
                int time = vault.get(Vault.CLOCK).get(TickClock.DISPLAY_TIME);
                for (Listener listener : vault.get(Vault.LISTENERS).getAll()) {
                    vault.get(Vault.STATS).get(listener.getId()).get(StatCollector.REWARD).add(HeraldTrophyItem.create(listener.getId(), listener.getPlayer().map(serverPlayer -> serverPlayer.m_36316_().getName()).orElse(null), ModConfigs.HERALD_TROPHY.getTrophy(time), time));
                    listener.getPlayer().ifPresent(player -> {
                        DiscoveredModelsData.get(world).discoverAllArmorPieceAndBroadcast((Player)player, ModDynamicModels.Armor.VICTORY);
                        PlayerGreedData.get(world.m_142572_()).onHeraldCompleted((Player)player);
                    });
                }
            }
        });
        CommonEvents.BLOCK_USE.in((Level)world).at(BlockUseEvent.Phase.HEAD).of(ModBlocks.HERALD_CONTROLLER).register(this, data -> {
            if (data.getHand() != InteractionHand.MAIN_HAND) {
                data.setResult(InteractionResult.SUCCESS);
                return;
            }
            BlockPos pos = data.getPos();
            if (((Boolean)data.getState().m_61143_((Property)HeraldControllerBlock.FILLED)).booleanValue()) {
                data.setResult(InteractionResult.SUCCESS);
                return;
            }
            if (data.getState().m_61143_(HeraldControllerBlock.HALF) == DoubleBlockHalf.UPPER && world.m_8055_(pos = pos.m_7495_()).m_60734_() != ModBlocks.HERALD_CONTROLLER) {
                data.setResult(InteractionResult.SUCCESS);
                return;
            }
            this.set(TIMER, 168);
            this.set(BOSS_POS, pos);
            this.set(BOSS_FACING, (Direction)data.getState().m_61143_((Property)HeraldControllerBlock.FACING));
            this.set(PROGRESS, Float.valueOf(1.0f));
            world.m_7731_(pos, (BlockState)world.m_8055_(pos).m_61124_((Property)HeraldControllerBlock.FILLED, (Comparable)Boolean.valueOf(true)), 3);
            world.m_7731_(pos.m_7494_(), (BlockState)world.m_8055_(pos.m_7494_()).m_61124_((Property)HeraldControllerBlock.FILLED, (Comparable)Boolean.valueOf(true)), 3);
            this.playActivationEffects(world, data.getPos());
            BlockPos finalPos = pos;
            world.m_142572_().m_6937_((Runnable)new TickTask(world.m_142572_().m_129921_() + 1, () -> {
                world.m_7726_().f_8325_.m_183262_(new ChunkPos(finalPos), false).forEach(player -> {
                    world.m_6522_(new ChunkPos((BlockPos)finalPos).f_45578_, new ChunkPos((BlockPos)finalPos).f_45579_, ChunkStatus.f_62326_, true);
                    ((AccessorChunkMap)world.m_7726_().f_8325_).callUpdateChunkTracking((ServerPlayer)player, new ChunkPos(finalPos), (MutableObject<ClientboundLevelChunkWithLightPacket>)new MutableObject(), false, true);
                });
                world.m_7726_().m_8450_(finalPos);
            }));
            data.setResult(InteractionResult.SUCCESS);
        });
        CommonEvents.BLOCK_SET.at(BlockSetEvent.Type.RETURN).in((LevelWriter)world).register(this, data -> {
            PartialTile target = PartialTile.of(PartialBlockState.of(ModBlocks.PLACEHOLDER), PartialCompoundNbt.empty());
            target.getState().set(PlaceholderBlock.TYPE, PlaceholderBlock.Type.OBJECTIVE);
            if (target.isSubsetOf(PartialTile.of(data.getState()))) {
                BlockState lower = (BlockState)((BlockState)((BlockState)ModBlocks.HERALD_CONTROLLER.m_49966_().m_61124_(HeraldControllerBlock.HALF, (Comparable)DoubleBlockHalf.LOWER)).m_61124_((Property)HeraldControllerBlock.FACING, (Comparable)((Direction)data.getState().m_61143_((Property)PlaceholderBlock.FACING)))).m_61124_((Property)HeraldControllerBlock.FILLED, (Comparable)Boolean.valueOf(false));
                BlockState upper = (BlockState)((BlockState)((BlockState)ModBlocks.HERALD_CONTROLLER.m_49966_().m_61124_(HeraldControllerBlock.HALF, (Comparable)DoubleBlockHalf.UPPER)).m_61124_((Property)HeraldControllerBlock.FACING, (Comparable)((Direction)data.getState().m_61143_((Property)PlaceholderBlock.FACING)))).m_61124_((Property)HeraldControllerBlock.FILLED, (Comparable)Boolean.valueOf(false));
                data.getWorld().m_7731_(data.getPos(), lower, 3);
                data.getWorld().m_7731_(data.getPos().m_7494_(), upper, 3);
            }
        });
        CommonEvents.CHEST_LOOT_GENERATION.post().register(this, data -> {
            if (data.getPlayer().f_19853_ != world) {
                return;
            }
            data.getLoot().forEach(stack -> {
                Item patt11484$temp = stack.m_41720_();
                if (patt11484$temp instanceof CatalystInhibitorItem) {
                    CatalystInhibitorItem inhibitorItem = (CatalystInhibitorItem)patt11484$temp;
                    inhibitorItem.setVaultId((ItemStack)stack, vault.get(Vault.ID));
                }
            });
        });
        super.initServer(world, vault);
    }

    protected void playActivationEffects(VirtualWorld world, BlockPos pos) {
        for (int i = 0; i < 20; ++i) {
            double d0 = world.f_46441_.nextGaussian() * 0.02;
            double d1 = world.f_46441_.nextGaussian() * 0.02;
            double d2 = world.f_46441_.nextGaussian() * 0.02;
            world.m_8767_((ParticleOptions)ParticleTypes.f_123759_, (double)pos.m_123341_() + world.f_46441_.nextDouble() - d0, (double)pos.m_123342_() + world.f_46441_.nextDouble() - d1, (double)pos.m_123343_() + world.f_46441_.nextDouble() - d2, 10, d0, d1, d2, 1.0);
        }
        world.m_5594_(null, pos, SoundEvents.f_11767_, SoundSource.MASTER, 1.0f, 1.0f);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void initClient(Vault vault) {
        CommonEvents.PLAYER_ACTION.register(vault, data -> {
            ClientLevel world = Minecraft.m_91087_().f_91073_;
            if (world == null || !world.m_46472_().m_135782_().equals((Object)vault.get(Vault.WORLD).get(WorldManager.KEY))) {
                return;
            }
            if (this.isWhitelisted(data.getWorld().m_8055_(data.getPos()))) {
                data.setRestricted(false);
            }
        });
        ClientEvents.CLIENT_TICK.register((Object)vault, EventPriority.HIGH, data -> HeraldMusicHandler.tick(!this.has(BOSS_DEAD) && this.getOr(TIMER, 0) < 0 || this.has(BOSS_DEAD)));
        super.initClient(vault);
    }

    @Override
    public void tickServer(VirtualWorld world, Vault vault) {
        if (this.has(TIMER)) {
            if (this.get(TIMER) < 0) {
                if (!this.has(BOSS_DEAD) && !this.has(BOSS_ID)) {
                    this.summonBoss(world, vault);
                } else if (this.has(BOSS_DEAD)) {
                    this.spawnPortal(world, vault);
                    this.remove(TIMER);
                }
            } else {
                this.tickDoor(world, vault);
            }
            if (this.has(TIMER)) {
                this.modify(TIMER, timer -> timer - 1);
            }
        }
        if (this.has(PROGRESS)) {
            this.getBoss((Level)world).flatMap(ArtifactBossEntity::getCurrentStage).ifPresent(stage -> {
                float progress = stage.getProgress();
                if (this.get(PROGRESS).floatValue() != stage.getProgress()) {
                    this.set(PROGRESS, Float.valueOf(stage.getProgress()));
                }
            });
        }
        if (this.has(BOSS_DEAD)) {
            super.tickServer(world, vault);
        }
    }

    private Optional<ArtifactBossEntity> getBoss(Level world) {
        VirtualWorld virtualWorld;
        Entity entity;
        if (world instanceof VirtualWorld && (entity = (virtualWorld = (VirtualWorld)world).m_8791_(this.get(BOSS_ID))) instanceof ArtifactBossEntity) {
            ArtifactBossEntity boss = (ArtifactBossEntity)entity;
            return Optional.of(boss);
        }
        return Optional.empty();
    }

    private void spawnPortal(VirtualWorld world, Vault vault) {
        BlockPos offset = new BlockPos(0, -3, 0).m_141952_((Vec3i)this.get(BOSS_POS)).m_5484_(this.get(BOSS_FACING), -120);
        MinecraftServer server = world.m_142572_();
        server.m_6937_((Runnable)new TickTask(server.m_129921_() + 1, () -> {
            TemplateKey key = VaultRegistry.TEMPLATE.getKey(VaultMod.id("boss_dimension/boss_exit_portal1"));
            if (key == null) {
                return;
            }
            Version version = vault.get(Vault.VERSION);
            Template template = (Template)key.get(version);
            if (template == null) {
                return;
            }
            ChunkRandom random = ChunkRandom.any();
            random.setDecoratorSeed(vault.get(Vault.SEED), this.get(BOSS_POS).m_123341_(), this.get(BOSS_POS).m_123343_(), 329057345);
            template = JigsawTemplate.of(version, template, new ArrayList<PaletteKey>(), 10, random);
            PlacementSettings settings = new PlacementSettings(new ProcessorContext(vault, random)).setFlags(3);
            settings.addProcessors(new TranslateTileProcessor[]{TileProcessor.translate((Vec3i)new BlockPos(-6, 0, 0))});
            if (this.get(BOSS_FACING) != Direction.SOUTH) {
                if (this.get(BOSS_FACING) == Direction.NORTH) {
                    settings.addProcessors(new RotateTileProcessor[]{TileProcessor.rotate(Rotation.CLOCKWISE_180, 0, 0, true)});
                } else if (this.get(BOSS_FACING) == Direction.EAST) {
                    settings.addProcessors(new RotateTileProcessor[]{TileProcessor.rotate(Rotation.COUNTERCLOCKWISE_90, 0, 0, true)});
                } else if (this.get(BOSS_FACING) == Direction.WEST) {
                    settings.addProcessors(new RotateTileProcessor[]{TileProcessor.rotate(Rotation.CLOCKWISE_90, 0, 0, true)});
                }
            }
            settings.addProcessors(new TranslateTileProcessor[]{TileProcessor.translate((Vec3i)offset)});
            AtomicReference<Object> pointer = new AtomicReference<Object>(null);
            settings.addProcessor(TileProcessor.of((_tile, context) -> {
                pointer.getAndUpdate(value -> {
                    if (value == null) {
                        return BoundingBox.m_162375_((Vec3i)_tile.getPos(), (Vec3i)_tile.getPos());
                    }
                    return value.m_162371_(_tile.getPos());
                });
                return _tile;
            }));
            template.place((ServerLevelAccessor)world, settings);
            ArrayList<ResourceLocation> tags = new ArrayList<ResourceLocation>();
            tags.add(ClassicPortalLogic.EXIT);
            vault.get(Vault.WORLD).get(WorldManager.PORTAL_LOGIC).addPortal(template, settings, tags);
            BoundingBox box = pointer.get();
            ServerChunkCache source = world.m_7726_();
            for (int x = box.m_162395_(); x < box.m_162399_(); x += x + 16 < box.m_162399_() ? 16 : 16 - Math.floorMod(x, 16)) {
                for (int z = box.m_162398_(); z < box.m_162401_(); z += z + 16 < box.m_162401_() ? 16 : 16 - Math.floorMod(z, 16)) {
                    ChunkPos chunkPos = new ChunkPos(x >> 4, z >> 4);
                    world.m_142572_().m_6937_((Runnable)new TickTask(world.m_142572_().m_129921_() + 1, () -> source.f_8325_.m_183262_(chunkPos, false).forEach(player -> {
                        world.m_6522_(chunkPos.f_45578_, chunkPos.f_45579_, ChunkStatus.f_62326_, true);
                        ((AccessorChunkMap)source.f_8325_).callUpdateChunkTracking((ServerPlayer)player, chunkPos, (MutableObject<ClientboundLevelChunkWithLightPacket>)new MutableObject(), false, true);
                    })));
                }
            }
        }));
    }

    private void summonBoss(VirtualWorld world, Vault vault) {
        this.playActivationEffects(world, this.get(BOSS_POS));
        world.m_7731_(this.get(BOSS_POS), Blocks.f_50016_.m_49966_(), 3);
        world.m_7731_(this.get(BOSS_POS).m_7494_(), Blocks.f_50016_.m_49966_(), 3);
        ArtifactBossEntity boss = new ArtifactBossEntity(ModEntities.ARTIFACT_BOSS, (Level)world);
        boss.m_6034_((double)this.get(BOSS_POS).m_123341_() + 0.5, this.get(BOSS_POS).m_123342_(), (double)this.get(BOSS_POS).m_123343_() + 0.5);
        boss.m_146922_(this.get(BOSS_FACING).m_122435_());
        boss.f_19859_ = this.get(BOSS_FACING).m_122435_();
        boss.f_20886_ = this.get(BOSS_FACING).m_122435_();
        boss.f_20885_ = this.get(BOSS_FACING).m_122435_();
        boss.f_20883_ = this.get(BOSS_FACING).m_122435_();
        boss.f_20884_ = this.get(BOSS_FACING).m_122435_();
        boss.setSpawnPosition(boss.m_20182_());
        world.m_7967_((Entity)boss);
        this.set(BOSS_ID, boss.m_142081_());
        ListenersLogic listenersLogic = vault.get(Vault.LISTENERS).get(Listeners.LOGIC);
        if (listenersLogic instanceof ClassicListenersLogic) {
            ClassicListenersLogic classic = (ClassicListenersLogic)listenersLogic;
            classic.set(ClassicListenersLogic.MAX_PLAYERS, 0);
        }
    }

    private void tickDoor(VirtualWorld world, Vault vault) {
        int timer = this.get(TIMER);
        ResourceLocation frame = null;
        BlockPos offset = null;
        if (!this.has(BOSS_DEAD)) {
            float frameTime = (float)timer / 6.0f;
            if (frameTime != (float)((int)frameTime)) {
                return;
            }
            frame = VaultMod.id("boss_dimension/arena_gate_frame" + (int)frameTime);
            offset = new BlockPos(0, -4, 0).m_141952_((Vec3i)this.get(BOSS_POS)).m_5484_(this.get(BOSS_FACING), 66);
            if (timer == 168) {
                world.m_142572_().m_6846_().m_11241_(null, (double)offset.m_123341_(), (double)offset.m_123342_(), (double)offset.m_123343_(), 120.0, world.m_46472_(), (Packet)new ClientboundSoundPacket(ModSounds.GATE_CLOSE, SoundSource.MASTER, (double)offset.m_123341_(), (double)offset.m_123342_(), (double)offset.m_123343_(), 0.5f, 1.0f));
            }
        } else {
            float frameTime = (float)timer / 8.0f;
            if (frameTime != (float)((int)frameTime)) {
                return;
            }
            frame = VaultMod.id("boss_dimension/arena_gate_frame" + (27 - (int)frameTime));
            offset = new BlockPos(0, -4, 0).m_141952_((Vec3i)this.get(BOSS_POS)).m_5484_(this.get(BOSS_FACING), -66);
            if (timer == 224) {
                world.m_142572_().m_6846_().m_11241_(null, (double)offset.m_123341_(), (double)offset.m_123342_(), (double)offset.m_123343_(), 120.0, world.m_46472_(), (Packet)new ClientboundSoundPacket(ModSounds.GATE_OPEN, SoundSource.MASTER, (double)offset.m_123341_(), (double)offset.m_123342_(), (double)offset.m_123343_(), 0.5f, 1.0f));
            }
        }
        this.generateFrame(world, vault, frame, offset);
    }

    private void generateFrame(VirtualWorld world, Vault vault, ResourceLocation frame, BlockPos offset) {
        MinecraftServer server = world.m_142572_();
        server.m_6937_((Runnable)new TickTask(server.m_129921_() + 1, () -> {
            TemplateKey key = VaultRegistry.TEMPLATE.getKey(frame);
            if (key == null) {
                return;
            }
            Version version = vault.get(Vault.VERSION);
            Template template = (Template)key.get(version);
            if (template == null) {
                return;
            }
            ChunkRandom random = ChunkRandom.any();
            random.setDecoratorSeed(vault.get(Vault.SEED), this.get(BOSS_POS).m_123341_(), this.get(BOSS_POS).m_123343_(), 329057345);
            template = JigsawTemplate.of(version, template, new ArrayList<PaletteKey>(), 10, random);
            PlacementSettings settings = new PlacementSettings(new ProcessorContext(vault, random)).setFlags(3);
            settings.addProcessors(new TranslateTileProcessor[]{TileProcessor.translate((Vec3i)new BlockPos(-5, 1, -1))});
            if (this.get(BOSS_FACING) != Direction.SOUTH) {
                if (this.get(BOSS_FACING) == Direction.NORTH) {
                    settings.addProcessors(new RotateTileProcessor[]{TileProcessor.rotate(Rotation.CLOCKWISE_180, 0, 0, true)});
                } else if (this.get(BOSS_FACING) == Direction.EAST) {
                    settings.addProcessors(new RotateTileProcessor[]{TileProcessor.rotate(Rotation.COUNTERCLOCKWISE_90, 0, 0, true)});
                } else if (this.get(BOSS_FACING) == Direction.WEST) {
                    settings.addProcessors(new RotateTileProcessor[]{TileProcessor.rotate(Rotation.CLOCKWISE_90, 0, 0, true)});
                }
            }
            settings.addProcessors(new TranslateTileProcessor[]{TileProcessor.translate((Vec3i)offset)});
            AtomicReference<Object> pointer = new AtomicReference<Object>(null);
            settings.addProcessor(TileProcessor.of((_tile, context) -> {
                pointer.getAndUpdate(value -> {
                    if (value == null) {
                        return BoundingBox.m_162375_((Vec3i)_tile.getPos(), (Vec3i)_tile.getPos());
                    }
                    return value.m_162371_(_tile.getPos());
                });
                return _tile;
            }));
            template.place((ServerLevelAccessor)world, settings);
            BoundingBox box = pointer.get();
            ServerChunkCache source = world.m_7726_();
            for (int x = box.m_162395_(); x < box.m_162399_(); x += x + 16 < box.m_162399_() ? 16 : 16 - Math.floorMod(x, 16)) {
                for (int z = box.m_162398_(); z < box.m_162401_(); z += z + 16 < box.m_162401_() ? 16 : 16 - Math.floorMod(z, 16)) {
                    ChunkPos chunkPos = new ChunkPos(x >> 4, z >> 4);
                    world.m_142572_().m_6937_((Runnable)new TickTask(world.m_142572_().m_129921_() + 1, () -> source.f_8325_.m_183262_(chunkPos, false).forEach(player -> {
                        world.m_6522_(chunkPos.f_45578_, chunkPos.f_45579_, ChunkStatus.f_62326_, true);
                        ((AccessorChunkMap)source.f_8325_).callUpdateChunkTracking((ServerPlayer)player, chunkPos, (MutableObject<ClientboundLevelChunkWithLightPacket>)new MutableObject(), false, true);
                    })));
                }
            }
            world.m_142572_().m_6846_().m_11241_(null, (double)offset.m_123341_(), (double)offset.m_123342_(), (double)offset.m_123343_(), 120.0, world.m_46472_(), (Packet)new ClientboundSoundPacket(SoundEvents.f_12055_, SoundSource.MASTER, (double)offset.m_123341_(), (double)offset.m_123342_(), (double)offset.m_123343_(), 0.5f, 1.5f));
        }));
    }

    @Override
    public void tickListener(VirtualWorld world, Vault vault, Listener listener) {
        if (listener.getPriority(this) < 0) {
            listener.addObjective(vault, this);
        }
        if (this.has(BOSS_DEAD)) {
            super.tickListener(world, vault, listener);
        }
    }

    public boolean isWhitelisted(BlockState state) {
        return state.m_60734_() instanceof VaultChestBlock || state.m_60734_() == ModBlocks.SPARK;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean render(Vault vault, PoseStack matrixStack, Window window, float partialTicks, Player player) {
        if (!this.has(BOSS_DEAD) && this.has(PROGRESS)) {
            this.renderBossBar(matrixStack, window, this.get(PROGRESS).floatValue(), this.get(BOSS_ID));
        }
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    private void renderBossBar(PoseStack matrixStack, Window window, float progress, UUID bossId) {
        EntityAccess entityAccess = ((AccessorClientLevel)Minecraft.m_91087_().f_91073_).getEntityStorage().m_142694_(bossId);
        if (entityAccess instanceof ArtifactBossEntity) {
            ArtifactBossEntity boss = (ArtifactBossEntity)entityAccess;
            boss.getCurrentStage().ifPresent(currentStage -> {
                matrixStack.m_85836_();
                RenderSystem.m_157427_(GameRenderer::m_172817_);
                RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                int previousTexture = RenderSystem.m_157203_((int)0);
                RenderSystem.m_157456_((int)0, (ResourceLocation)HUD);
                int midX = window.m_85445_() / 2;
                matrixStack.m_85837_((double)(midX - 95), 4.0, 0.0);
                GuiComponent.m_93133_((PoseStack)matrixStack, (int)4, (int)22, (float)4.0f, (float)308.0f, (int)180, (int)5, (int)189, (int)368);
                GuiComponent.m_93133_((PoseStack)matrixStack, (int)4, (int)22, (float)4.0f, (float)((Integer)currentStage.getBossBarTextureVs().m_14419_()).intValue(), (int)((int)(180.0f * progress)), (int)5, (int)189, (int)368);
                GuiComponent.m_93133_((PoseStack)matrixStack, (int)0, (int)0, (float)0.0f, (float)((Integer)currentStage.getBossBarTextureVs().m_14418_()).intValue(), (int)189, (int)37, (int)189, (int)368);
                RenderSystem.m_157427_(GameRenderer::m_172817_);
                RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                RenderSystem.m_157453_((int)0, (int)previousTexture);
                matrixStack.m_85849_();
            });
        }
    }

    @Override
    public boolean isActive(VirtualWorld world, Vault vault, Objective objective) {
        if (!this.has(BOSS_DEAD)) {
            return objective == this;
        }
        for (Objective child : (Objective.ObjList)this.get(CHILDREN)) {
            if (!child.isActive(world, vault, objective)) continue;
            return true;
        }
        return false;
    }
}

