/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.core.vault.objective;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import iskallia.vault.block.entity.LodestoneTileEntity;
import iskallia.vault.client.gui.helper.LightmapHelper;
import iskallia.vault.core.Version;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.data.adapter.vault.CompoundAdapter;
import iskallia.vault.core.data.compound.UUIDList;
import iskallia.vault.core.data.key.FieldKey;
import iskallia.vault.core.data.key.SupplierKey;
import iskallia.vault.core.data.key.registry.FieldRegistry;
import iskallia.vault.core.event.CommonEvents;
import iskallia.vault.core.event.common.BlockUseEvent;
import iskallia.vault.core.vault.Vault;
import iskallia.vault.core.vault.VaultUtils;
import iskallia.vault.core.vault.objective.ElixirObjective;
import iskallia.vault.core.vault.objective.Objective;
import iskallia.vault.core.vault.objective.elixir.ElixirGoal;
import iskallia.vault.core.vault.player.Listener;
import iskallia.vault.core.vault.player.Runner;
import iskallia.vault.core.world.storage.VirtualWorld;
import iskallia.vault.init.ModBlocks;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class LodestoneObjective
extends Objective {
    public static final SupplierKey<Objective> KEY = (SupplierKey)SupplierKey.of("lodestone", Objective.class).with(Version.v1_13, (Objective)((Object)((Supplier<Objective>)LodestoneObjective::new)));
    public static final FieldRegistry FIELDS = Objective.FIELDS.merge(new FieldRegistry());
    public static final FieldKey<UUIDList> COMPLETED_PLAYERS = (FieldKey)FieldKey.of("completed_players", UUIDList.class).with(Version.v1_13, CompoundAdapter.of(UUIDList::create), DISK.all().or(CLIENT.all())).register(FIELDS);
    public static final FieldKey<Float> OBJECTIVE_PROBABILITY = (FieldKey)FieldKey.of("objective_probability", Float.class).with(Version.v1_13, Adapters.FLOAT, DISK.all()).register(FIELDS);

    protected LodestoneObjective() {
        this.set(COMPLETED_PLAYERS, UUIDList.create());
    }

    public LodestoneObjective(float objectiveProbability) {
        this.set(COMPLETED_PLAYERS, UUIDList.create());
        this.set(OBJECTIVE_PROBABILITY, Float.valueOf(objectiveProbability));
    }

    public static LodestoneObjective of(float objectiveProbability) {
        return new LodestoneObjective(objectiveProbability);
    }

    @Override
    public SupplierKey<Objective> getKey() {
        return KEY;
    }

    @Override
    public FieldRegistry getFields() {
        return FIELDS;
    }

    @Override
    public void initServer(VirtualWorld world, Vault vault) {
        CommonEvents.OBJECTIVE_PIECE_GENERATION.register(this, data -> {
            if (data.getVault() != vault) {
                return;
            }
            this.ifPresent(OBJECTIVE_PROBABILITY, probability -> data.setProbability(probability.floatValue()));
        });
        this.registerObjectiveTemplate(world, vault);
        CommonEvents.BLOCK_USE.in((Level)world).at(BlockUseEvent.Phase.HEAD).of(ModBlocks.LODESTONE).register(this, data -> {
            LodestoneTileEntity lodestone;
            BlockEntity patt4926$temp;
            Runner runner;
            if (data.getHand() != InteractionHand.MAIN_HAND) {
                data.setResult(InteractionResult.SUCCESS);
                return;
            }
            if (this.get(COMPLETED_PLAYERS).contains(data.getPlayer().m_142081_())) {
                return;
            }
            Listener listener = vault.get(Vault.LISTENERS).get(data.getPlayer().m_142081_());
            boolean pvp = VaultUtils.isPvPVault(vault);
            if (pvp) {
                ElixirObjective elixir = vault.get(Vault.OBJECTIVES).getAll(ElixirObjective.class).stream().findFirst().orElse(null);
                if (!(listener instanceof Runner) || elixir == null) {
                    data.setResult(InteractionResult.SUCCESS);
                    return;
                }
                ElixirGoal goal = (ElixirGoal)elixir.get(ElixirObjective.GOALS).get(listener.getId());
                if (goal == null || !goal.isCompleted()) {
                    data.setResult(InteractionResult.SUCCESS);
                    return;
                }
            } else if (!(listener instanceof Runner) || !(runner = (Runner)listener).isActive(world, vault, this)) {
                data.setResult(InteractionResult.SUCCESS);
                return;
            }
            if ((patt4926$temp = world.m_7702_(data.getPos())) instanceof LodestoneTileEntity && !(lodestone = (LodestoneTileEntity)patt4926$temp).isConsumed()) {
                if (!world.f_46443_) {
                    lodestone.setConsumed(true);
                    world.m_7731_(data.getPos(), Blocks.f_50016_.m_49966_(), 3);
                    world.m_5594_(null, data.getPos(), SoundEvents.f_12019_, SoundSource.BLOCKS, 1.0f, 2.0f);
                }
                this.playActivationEffects(world, data.getPos());
                this.get(COMPLETED_PLAYERS).add(data.getPlayer().m_142081_());
            }
            data.setResult(InteractionResult.SUCCESS);
        });
        ((Objective.ObjList)this.get(CHILDREN)).forEach(child -> child.initServer(world, vault));
    }

    @Override
    public void tickServer(VirtualWorld world, Vault vault) {
        if (vault.get(Vault.LISTENERS).getAll(Runner.class).stream().allMatch(runner -> this.get(COMPLETED_PLAYERS).contains(runner.getId()))) {
            super.tickServer(world, vault);
        }
    }

    @Override
    public void tickListener(VirtualWorld world, Vault vault, Listener listener) {
        if (this.get(COMPLETED_PLAYERS).contains(listener.get(Listener.ID))) {
            super.tickListener(world, vault, listener);
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean render(Vault vault, PoseStack matrixStack, Window window, float partialTicks, Player player) {
        if (this.get(COMPLETED_PLAYERS).contains(player.m_142081_())) {
            boolean rendered = false;
            for (Objective objective : (Objective.ObjList)this.get(CHILDREN)) {
                rendered |= objective.render(vault, matrixStack, window, partialTicks, player);
            }
            return rendered;
        }
        int midX = window.m_85445_() / 2;
        Font font = Minecraft.m_91087_().f_91062_;
        MultiBufferSource.BufferSource buffer = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
        MutableComponent txt = new TextComponent("Consume a Lodestone!").m_130940_(ChatFormatting.WHITE);
        FormattedCharSequence formattedCharSequence = txt.m_7532_();
        float f = (float)midX - (float)font.m_92852_((FormattedText)txt) / 2.0f;
        Objects.requireNonNull(font);
        font.m_92733_(formattedCharSequence, f, 9.0f, -1, true, matrixStack.m_85850_().m_85861_(), (MultiBufferSource)buffer, false, 0, LightmapHelper.getPackedFullbrightCoords());
        buffer.m_109911_();
        return true;
    }

    @Override
    public boolean isActive(VirtualWorld world, Vault vault, Objective objective) {
        return objective == this;
    }

    protected void playActivationEffects(VirtualWorld world, BlockPos pos) {
        for (int i = 0; i < 20; ++i) {
            double d0 = world.f_46441_.nextGaussian() * 0.02;
            double d1 = world.f_46441_.nextGaussian() * 0.02;
            double d2 = world.f_46441_.nextGaussian() * 0.02;
            world.m_8767_((ParticleOptions)ParticleTypes.f_123759_, (double)pos.m_123341_() + world.f_46441_.nextDouble() - d0, (double)pos.m_123342_() + world.f_46441_.nextDouble() - d1, (double)pos.m_123343_() + world.f_46441_.nextDouble() - d2, 10, d0, d1, d2, 1.0);
        }
        world.m_5594_(null, pos, SoundEvents.f_11767_, SoundSource.BLOCKS, 1.0f, 1.0f);
    }
}

