/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.core.vault.objective;

import iskallia.vault.core.Version;
import iskallia.vault.core.data.DataObject;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.data.adapter.vault.CompoundAdapter;
import iskallia.vault.core.data.key.FieldKey;
import iskallia.vault.core.data.key.registry.FieldRegistry;
import iskallia.vault.core.vault.Vault;
import iskallia.vault.core.vault.objective.Objective;
import iskallia.vault.core.vault.player.Listener;
import iskallia.vault.core.world.storage.VirtualWorld;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class Objectives
extends DataObject<Objectives> {
    public static final FieldRegistry FIELDS = new FieldRegistry();
    public static final FieldKey<String> KEY = (FieldKey)FieldKey.of("key", String.class).with(Version.v1_3, Adapters.UTF_8, DISK.all()).register(FIELDS);
    public static final FieldKey<Integer> INDEX = (FieldKey)FieldKey.of("index", Integer.class).with(Version.v1_0, Adapters.INT_SEGMENTED_3, DISK.all().or(CLIENT.all())).register(FIELDS);
    public static final FieldKey<Objective.ObjList> LIST = (FieldKey)FieldKey.of("list", Objective.ObjList.class).with(Version.v1_0, CompoundAdapter.of(Objective.ObjList::new), DISK.all().or(CLIENT.all())).register(FIELDS);

    public Objectives() {
        this.set(INDEX, 0);
        this.set(LIST, new Objective.ObjList());
    }

    @Override
    public FieldRegistry getFields() {
        return FIELDS;
    }

    public void initServer(VirtualWorld world, Vault vault) {
        this.get(LIST).forEach(objective -> objective.initServer(world, vault));
    }

    public void tickServer(VirtualWorld world, Vault vault) {
        this.get(LIST).forEach(objective -> vault.ifPresent(Vault.LISTENERS, listeners -> {
            for (Listener listener : listeners.getAll()) {
                objective.tickListener(world, vault, listener);
            }
        }));
        this.get(LIST).forEach(objective -> objective.tickServer(world, vault));
    }

    public void releaseServer() {
        this.get(LIST).forEach(Objective::releaseServer);
    }

    public Objectives add(Objective objective) {
        this.get(LIST).add((Objective)objective.set(Objective.ID, this.get(INDEX)));
        this.set(INDEX, this.get(INDEX) + 1);
        return this;
    }

    public Optional<Objective> get(int index) {
        for (Objective objective : this.get(LIST)) {
            if (objective.get(Objective.ID) != index) continue;
            return Optional.of(objective);
        }
        return Optional.empty();
    }

    public Objectives addAll(Collection<Objective> objectives) {
        objectives.forEach(this::add);
        return this;
    }

    public <T extends Objective> List<T> getAll(Class<T> type) {
        ArrayList objectives = new ArrayList();
        this.forEach(type, t -> {
            objectives.add(t);
            return false;
        });
        return objectives;
    }

    public <T extends Objective> boolean forEach(Class<T> type, Predicate<T> consumer) {
        for (Objective objective : this.get(LIST)) {
            boolean result = this.forEachInternal(objective, type, consumer);
            if (!result) continue;
            return true;
        }
        return false;
    }

    public <T extends Objective> Optional<T> findFirst(Class<T> type) {
        List<T> objectives = this.getAll(type);
        return objectives.isEmpty() ? Optional.empty() : Optional.of((Objective)objectives.get(0));
    }

    public <T extends Objective> Optional<T> find(Class<T> type, Predicate<T> predicate) {
        List<T> objectives = this.getAll(type);
        return objectives.stream().filter(predicate).findFirst();
    }

    protected <T extends Objective> boolean forEachInternal(Objective parent, Class<T> type, Predicate<T> consumer) {
        if (type.isAssignableFrom(parent.getClass()) && consumer.test(parent)) {
            return true;
        }
        for (Objective child : parent.get(Objective.CHILDREN)) {
            if (!this.forEachInternal(child, type, consumer)) continue;
            return true;
        }
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void initClient(Vault vault) {
        this.get(LIST).forEach(objective -> objective.initClient(vault));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void releaseClient() {
        this.get(LIST).forEach(Objective::releaseClient);
    }
}

