/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.core.vault.objective;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.vertex.PoseStack;
import iskallia.vault.VaultMod;
import iskallia.vault.block.item.PvPTrophyItem;
import iskallia.vault.core.Version;
import iskallia.vault.core.data.DataMap;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.data.adapter.number.LegacySegmentedIntAdapter;
import iskallia.vault.core.data.adapter.vault.CompoundAdapter;
import iskallia.vault.core.data.compound.IntList;
import iskallia.vault.core.data.key.FieldKey;
import iskallia.vault.core.data.key.SupplierKey;
import iskallia.vault.core.data.key.registry.FieldRegistry;
import iskallia.vault.core.event.CommonEvents;
import iskallia.vault.core.util.RegionPos;
import iskallia.vault.core.vault.ClassicPortalLogic;
import iskallia.vault.core.vault.PortalLogic;
import iskallia.vault.core.vault.Vault;
import iskallia.vault.core.vault.VaultUtils;
import iskallia.vault.core.vault.WorldManager;
import iskallia.vault.core.vault.objective.Objective;
import iskallia.vault.core.vault.player.Completion;
import iskallia.vault.core.vault.player.Listener;
import iskallia.vault.core.vault.player.Runner;
import iskallia.vault.core.vault.stat.StatCollector;
import iskallia.vault.core.vault.time.TickClock;
import iskallia.vault.core.world.generator.GridGenerator;
import iskallia.vault.core.world.generator.VaultGenerator;
import iskallia.vault.core.world.generator.layout.ArchitectVaultLayout;
import iskallia.vault.core.world.generator.layout.ClassicCircleLayout;
import iskallia.vault.core.world.generator.layout.ClassicInfiniteLayout;
import iskallia.vault.core.world.generator.layout.ClassicPolygonLayout;
import iskallia.vault.core.world.generator.layout.ClassicSpiralLayout;
import iskallia.vault.core.world.generator.layout.DIYVaultLayout;
import iskallia.vault.core.world.generator.layout.GridLayout;
import iskallia.vault.core.world.generator.layout.VaultGridLayout;
import iskallia.vault.core.world.generator.layout.VaultLayout;
import iskallia.vault.core.world.storage.VirtualWorld;
import iskallia.vault.event.PlayerEvents;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;

public class PvPObjective
extends Objective {
    public static final SupplierKey<Objective> KEY = (SupplierKey)SupplierKey.of("pvp_race", Objective.class).with(Version.v1_38, (Objective)((Object)((Supplier<Objective>)PvPObjective::new)));
    public static final FieldRegistry FIELDS = Objective.FIELDS.merge(new FieldRegistry());
    public static final FieldKey<Long> START_TICK = (FieldKey)FieldKey.of("start_tick", Long.class).with(Version.v1_38, Adapters.LONG, DISK.all().or(CLIENT.all())).register(FIELDS);
    public static final FieldKey<Void> COUNTDOWN_FINISHED = (FieldKey)FieldKey.of("countdown_finished", Void.class).with(Version.v1_38, Adapters.ofVoid(), DISK.all().or(CLIENT.all())).register(FIELDS);
    public static final int COUNTDOWN_TICKS = 2400;
    public static final FieldKey<GraceMap> GRACE_TICKS = (FieldKey)FieldKey.of("grace_ticks", GraceMap.class).with(Version.v1_38, CompoundAdapter.of(GraceMap::new), DISK.all().or(CLIENT.all())).register(FIELDS);
    public static final int GRACE_PERIOD = 600;

    protected PvPObjective() {
        this.set(GRACE_TICKS, new GraceMap());
    }

    public static PvPObjective create() {
        return new PvPObjective();
    }

    @Override
    public SupplierKey<Objective> getKey() {
        return KEY;
    }

    @Override
    public FieldRegistry getFields() {
        return FIELDS;
    }

    @Override
    public void initServer(VirtualWorld world, Vault vault) {
        CommonEvents.LISTENER_JOIN.register(this, data -> {
            PortalLogic patt3821$temp;
            if (data.getVault() != vault) {
                return;
            }
            if (!(data.getListener() instanceof Runner)) {
                return;
            }
            long runnerCount = vault.get(Vault.LISTENERS).getAll(Runner.class).size();
            if (this.has(COUNTDOWN_FINISHED) && (patt3821$temp = vault.get(Vault.WORLD).get(WorldManager.PORTAL_LOGIC)) instanceof ClassicPortalLogic) {
                ClassicPortalLogic logic = (ClassicPortalLogic)patt3821$temp;
                logic.placeStartTrapdoors(world, vault);
            }
            if (runnerCount >= 2L && !this.has(START_TICK)) {
                this.set(START_TICK, world.m_46467_());
            }
        });
        CommonEvents.PLAYER_MINE.register(PlayerEvents.class, event -> {
            if (event.getWorld() != world) {
                return;
            }
            if (event.getPlayer().m_7500_()) {
                return;
            }
            BlockPos pos = event.getPos();
            if (VaultUtils.isInStartRoom(pos)) {
                event.setCanceled(true);
            }
        });
        CommonEvents.LISTENER_LEAVE.register(this, data -> {
            if (data.getVault() != vault) {
                return;
            }
            Listener patt4597$temp = data.getListener();
            if (!(patt4597$temp instanceof Runner)) {
                return;
            }
            Runner leaving = (Runner)patt4597$temp;
            StatCollector stats = vault.get(Vault.STATS).get(leaving.getId());
            boolean completed = stats != null && stats.getCompletion() == Completion.COMPLETED;
            ArrayList<Runner> remaining = new ArrayList<Runner>(vault.get(Vault.LISTENERS).getAll(Runner.class));
            if (completed) {
                for (Runner runner : remaining) {
                    StatCollector otherStats = vault.get(Vault.STATS).get(runner.getId());
                    if (otherStats != null) {
                        otherStats.set(StatCollector.COMPLETION, Completion.FAILED);
                    }
                    vault.get(Vault.LISTENERS).remove(world, vault, runner);
                }
            } else if (remaining.size() == 1) {
                Runner winner = (Runner)remaining.get(0);
                StatCollector winnerStats = vault.get(Vault.STATS).get(winner.getId());
                if (winnerStats != null) {
                    winnerStats.set(StatCollector.COMPLETION, Completion.COMPLETED);
                    winner.getPlayer().ifPresent(player -> winnerStats.get(StatCollector.REWARD).add(PvPTrophyItem.create(player, vault.get(Vault.CLOCK).get(TickClock.LOGICAL_TIME))));
                }
                VaultMod.LOGGER.info("Last player {} remaining in PvP vault, declaring winner", (Object)winner.getId());
                vault.get(Vault.LISTENERS).remove(world, vault, winner);
            }
        });
        super.initServer(world, vault);
    }

    @Override
    public void tickServer(VirtualWorld world, Vault vault) {
        long elapsed;
        if (this.has(START_TICK) && !this.has(COUNTDOWN_FINISHED) && (elapsed = world.m_46467_() - this.get(START_TICK)) >= 2400L) {
            this.teleportRunners(world, vault);
            this.set(COUNTDOWN_FINISHED);
        }
        super.tickServer(world, vault);
    }

    @Override
    public void tickListener(VirtualWorld world, Vault vault, Listener listener) {
        if (listener instanceof Runner && listener.getPriority(this) < 0) {
            listener.addObjective(vault, this);
        }
        if (this.get(GRACE_TICKS).containsKey(listener.getId())) {
            int ticks = (Integer)this.get(GRACE_TICKS).get(listener.getId());
            if (ticks <= 0) {
                this.get(GRACE_TICKS).remove(listener.getId());
                CommonEvents.release(listener.getId());
            } else {
                this.get(GRACE_TICKS).put(listener.getId(), ticks - 1);
            }
        }
        super.tickListener(world, vault, listener);
    }

    private void teleportRunners(VirtualWorld world, Vault vault) {
        VaultGenerator vaultGenerator = vault.get(Vault.WORLD).get(WorldManager.GENERATOR);
        if (!(vaultGenerator instanceof GridGenerator)) {
            return;
        }
        GridGenerator generator = (GridGenerator)vaultGenerator;
        GridLayout gridLayout = generator.get(GridGenerator.LAYOUT);
        if (!(gridLayout instanceof VaultGridLayout)) {
            return;
        }
        VaultGridLayout layout = (VaultGridLayout)gridLayout;
        int cellX = generator.get(GridGenerator.CELL_X);
        int cellZ = generator.get(GridGenerator.CELL_Z);
        BlockPos basePos = BlockPos.f_121853_;
        PortalLogic portalLogic = vault.get(Vault.WORLD).get(WorldManager.PORTAL_LOGIC);
        if (portalLogic instanceof ClassicPortalLogic) {
            ClassicPortalLogic logic = (ClassicPortalLogic)portalLogic;
            basePos = logic.getPlayerStartPos(vault).orElse(basePos);
        }
        Direction facing = vault.get(Vault.WORLD).get(WorldManager.FACING);
        ArrayList<BlockPos> targets = new ArrayList<BlockPos>();
        int maxAttempts = 1000;
        int players = vault.get(Vault.LISTENERS).getAll(Runner.class).size();
        int radius = this.getVaultRadius(layout, vault);
        VaultMod.LOGGER.info((Object)layout);
        VaultMod.LOGGER.info("PvP teleport radius: {} rooms", (Object)radius);
        while (targets.size() < players && maxAttempts-- > 0) {
            BlockPos offset;
            RegionPos region;
            int x = world.m_5822_().nextInt(radius * 2 + 1) - radius;
            int z = world.m_5822_().nextInt(radius * 2 + 1) - radius;
            if (x == 0 && z == 0 || layout.getType(vault, region = RegionPos.of(x, z, cellX, cellZ)) != VaultLayout.PieceType.ROOM || targets.contains(offset = new BlockPos(x, 0, z))) continue;
            targets.add(offset);
        }
        int index = 0;
        for (Runner runner : vault.get(Vault.LISTENERS).getAll(Runner.class)) {
            ServerPlayer player = runner.getPlayer().orElse(null);
            if (player == null) continue;
            if (index >= targets.size()) break;
            BlockPos off = (BlockPos)targets.get(index++);
            int x = off.m_123341_() * cellX + cellX / 2;
            int z = off.m_123343_() * cellZ + cellZ / 2;
            int y = 33;
            BlockPos ground = new BlockPos(x, y - 1, z);
            while (y > world.m_141937_() && !world.m_8055_(ground).m_60767_().m_76333_()) {
                --y;
                ground = ground.m_7495_();
            }
            Vec3 pos = new Vec3((double)x + 0.5, (double)(y + 1), (double)z + 0.5);
            VaultMod.LOGGER.info("Teleporting runner {} to {}", (Object)player.m_7755_().getString(), (Object)pos);
            VaultUtils.moveTo(world, (Entity)player, pos, new Vec2(facing.m_122435_(), 0.0f));
            this.get(GRACE_TICKS).put(player.m_142081_(), 600);
            CommonEvents.ENTITY_DAMAGE.register(player.m_142081_(), event -> {
                if (event.getEntity().equals((Object)player)) {
                    event.setCanceled(true);
                }
            });
        }
    }

    private int getVaultRadius(VaultGridLayout layout, Vault vault) {
        ClassicPolygonLayout polygon;
        ClassicCircleLayout circle;
        ClassicSpiralLayout spiral;
        if (layout instanceof ClassicSpiralLayout && (spiral = (ClassicSpiralLayout)layout).has(ClassicSpiralLayout.HALF_LENGTH)) {
            int unit = spiral.get(ClassicInfiniteLayout.TUNNEL_SPAN) + 1;
            return spiral.get(ClassicSpiralLayout.HALF_LENGTH) * unit;
        }
        if (layout instanceof ClassicCircleLayout && (circle = (ClassicCircleLayout)layout).has(ClassicCircleLayout.RADIUS)) {
            int unit = circle.get(ClassicInfiniteLayout.TUNNEL_SPAN) + 1;
            return circle.get(ClassicCircleLayout.RADIUS) * unit;
        }
        if (layout instanceof ClassicPolygonLayout && (polygon = (ClassicPolygonLayout)layout).has(ClassicPolygonLayout.VERTICES)) {
            IntList verts = polygon.get(ClassicPolygonLayout.VERTICES);
            int max = 0;
            for (int i = 0; i < verts.size(); ++i) {
                max = Math.max(max, Math.abs((Integer)verts.get(i)));
            }
            int unit = polygon.get(ClassicInfiniteLayout.TUNNEL_SPAN) + 1;
            return max * unit;
        }
        if (layout instanceof ArchitectVaultLayout) {
            ArchitectVaultLayout arch = (ArchitectVaultLayout)layout;
            int count = arch.get(ArchitectVaultLayout.ROOM_ENTRIES).getTotalCount();
            int unit = arch.get(ArchitectVaultLayout.TUNNEL_SPAN) + 1;
            return this.spiralRadius(count, unit);
        }
        if (layout instanceof DIYVaultLayout) {
            DIYVaultLayout diy = (DIYVaultLayout)layout;
            int count = diy.get(DIYVaultLayout.ROOM_ENTRIES).getTotalCount();
            int unit = diy.get(DIYVaultLayout.TUNNEL_SPAN) + 1;
            return this.spiralRadius(count, unit);
        }
        if (layout instanceof ClassicInfiniteLayout) {
            ClassicInfiniteLayout infinite = (ClassicInfiniteLayout)layout;
            int unit = infinite.get(ClassicInfiniteLayout.TUNNEL_SPAN) + 1;
            return 6 * unit;
        }
        return 6;
    }

    private int spiralRadius(int rooms, int unit) {
        double r = Math.ceil((Math.sqrt(rooms + 1) - 1.0) / 2.0);
        return (int)r * unit;
    }

    public int getGraceTicks(UUID playerId) {
        return this.get(GRACE_TICKS).getOrDefault(playerId, 0);
    }

    @Override
    public boolean render(Vault vault, PoseStack matrixStack, Window window, float partialTicks, Player player) {
        return false;
    }

    @Override
    public boolean isActive(VirtualWorld world, Vault vault, Objective objective) {
        return objective == this;
    }

    @Override
    public void releaseServer() {
        super.releaseServer();
    }

    private static class GraceMap
    extends DataMap<GraceMap, UUID, Integer> {
        public GraceMap() {
            super(new HashMap(), Adapters.UUID, LegacySegmentedIntAdapter._7);
        }
    }
}

