/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.core.vault.objective;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.vertex.PoseStack;
import iskallia.vault.block.RoyaleCrateBlock;
import iskallia.vault.block.entity.RoyaleLootBlockEntity;
import iskallia.vault.core.Version;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.data.key.FieldKey;
import iskallia.vault.core.data.key.SupplierKey;
import iskallia.vault.core.data.key.registry.FieldRegistry;
import iskallia.vault.core.event.CommonEvents;
import iskallia.vault.core.vault.ClassicPortalLogic;
import iskallia.vault.core.vault.PortalLogic;
import iskallia.vault.core.vault.Vault;
import iskallia.vault.core.vault.WorldManager;
import iskallia.vault.core.vault.objective.BailObjective;
import iskallia.vault.core.vault.objective.Objective;
import iskallia.vault.core.vault.player.Completion;
import iskallia.vault.core.vault.player.Listener;
import iskallia.vault.core.vault.player.Runner;
import iskallia.vault.core.vault.stat.StatCollector;
import iskallia.vault.core.world.storage.VirtualWorld;
import iskallia.vault.init.ModBlocks;
import iskallia.vault.init.ModDecorativeBlocks;
import iskallia.vault.item.gear.VoidStoneItem;
import iskallia.vault.util.MiscUtils;
import iskallia.vault.world.data.PlayerAbilitiesData;
import iskallia.vault.world.data.PlayerTalentsData;
import iskallia.vault.world.data.PlayerVaultStatsData;
import iskallia.vault.world.data.RoyaleInventorySnapshotData;
import iskallia.vault.world.data.RoyaleSkillSnapshotData;
import iskallia.vault.world.data.VaultJoinSnapshotData;
import it.unimi.dsi.fastutil.objects.Object2FloatMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.p3pp3rf1y.sophisticatedcore.util.RandHelper;

public class RoyaleObjective
extends Objective {
    public static final SupplierKey<Objective> KEY = (SupplierKey)SupplierKey.of("royale", Objective.class).with(Version.v1_36, (Objective)((Object)((Supplier<Objective>)RoyaleObjective::new)));
    public static final FieldRegistry FIELDS = Objective.FIELDS.merge(new FieldRegistry());
    public static final FieldKey<ResourceLocation> START_CRATE_LOOT_TABLE = (FieldKey)FieldKey.of("start_crate_loot_table", ResourceLocation.class).with(Version.v1_36, Adapters.IDENTIFIER, DISK.all()).register(FIELDS);
    public static final FieldKey<BlockPos> START_CRATE_BLOCK = (FieldKey)FieldKey.of("start_crate_block", BlockPos.class).with(Version.v1_36, Adapters.BLOCK_POS, DISK.all()).register(FIELDS);
    public static final FieldKey<Integer> LOOT_MULTIPLIER = (FieldKey)FieldKey.of("loot_multiplier", Integer.class).with(Version.v1_36, Adapters.INT_SEGMENTED_7, DISK.all().or(CLIENT.all())).register(FIELDS);
    private static final Set<Item> royaleCrateSet = Set.of(ModBlocks.ROYALE_CRATE_BLOCK.m_5456_());
    private final Map<UUID, Integer> crateSlotCache = new HashMap<UUID, Integer>();

    protected RoyaleObjective() {
    }

    protected RoyaleObjective(ResourceLocation startCrateLootTable, int lootMultiplier) {
        this.set(START_CRATE_LOOT_TABLE, startCrateLootTable);
        this.set(LOOT_MULTIPLIER, lootMultiplier);
    }

    public static RoyaleObjective of(ResourceLocation startCrateLootTable, int lootMultiplier) {
        return new RoyaleObjective(startCrateLootTable, lootMultiplier);
    }

    @Override
    public void tickServer(VirtualWorld world, Vault vault) {
        PortalLogic logic;
        super.tickServer(world, vault);
        BlockPos cratePos = this.get(START_CRATE_BLOCK);
        if (cratePos != null && !world.m_8055_(cratePos).m_60713_((Block)ModBlocks.ROYALE_CRATE)) {
            this.set(START_CRATE_BLOCK, null);
            cratePos = null;
        }
        if (cratePos == null && (logic = vault.get(Vault.WORLD).get(WorldManager.PORTAL_LOGIC)) instanceof ClassicPortalLogic) {
            ClassicPortalLogic classic = (ClassicPortalLogic)logic;
            classic.getStart().ifPresent(pos -> {
                pos = pos.m_5484_(vault.get(Vault.WORLD).get(WorldManager.FACING), 9);
                pos = pos.m_5484_(Direction.DOWN, 1);
                world.m_7731_((BlockPos)pos, ModBlocks.ROYALE_CRATE.m_49966_(), 3);
                BlockEntity patt4607$temp = world.m_7702_((BlockPos)pos);
                if (patt4607$temp instanceof RoyaleLootBlockEntity) {
                    RoyaleLootBlockEntity tileEntity = (RoyaleLootBlockEntity)patt4607$temp;
                    tileEntity.m_59626_(this.get(START_CRATE_LOOT_TABLE), vault.get(Vault.SEED));
                    tileEntity.setVaultCrate(true);
                }
                this.set(START_CRATE_BLOCK, pos);
            });
        }
    }

    @Override
    public SupplierKey<Objective> getKey() {
        return KEY;
    }

    @Override
    public FieldRegistry getFields() {
        return FIELDS;
    }

    @Override
    public void initServer(VirtualWorld world, Vault vault) {
        CommonEvents.LISTENER_JOIN.register(this, data -> {
            if (data.getVault() != vault) {
                return;
            }
            Listener patt5309$temp = data.getListener();
            if (!(patt5309$temp instanceof Runner)) {
                return;
            }
            Runner runner = (Runner)patt5309$temp;
            ServerPlayer player = runner.getPlayer().orElse(null);
            if (player == null) {
                return;
            }
            this.crateSlotCache.remove(player.m_142081_());
            RoyaleInventorySnapshotData.get(player.m_183503_()).createSnapshot((Player)player);
            VaultJoinSnapshotData.get(player.m_183503_()).createSnapshot((Player)player);
            PlayerAbilitiesData abilitiesData = PlayerAbilitiesData.get(player.m_183503_());
            PlayerTalentsData talentsData = PlayerTalentsData.get(player.m_183503_());
            PlayerVaultStatsData vaultStatsData = PlayerVaultStatsData.get(player.m_183503_());
            RoyaleSkillSnapshotData.get(player.m_183503_()).putSnapshot(runner.getId(), vaultStatsData.getVaultStats(runner.getId()), abilitiesData.getAbilities((Player)player), talentsData.getTalents((Player)player));
            PlayerVaultStatsData.get(player.m_183503_()).resetSkills(player, false);
            PlayerVaultStatsData.get(player.m_183503_()).resetSkillAndPrestigePoints(player);
            PlayerVaultStatsData.get(player.m_183503_()).addSkillPoints(player, vaultStatsData.getVaultStats(runner.getId()).getVaultLevel());
            player.m_150109_().m_36040_(35, new ItemStack((ItemLike)ModBlocks.ROYALE_CRATE_BLOCK));
            vault.get(Vault.OBJECTIVES).forEach(BailObjective.class, b -> {
                b.modifyIfPresent(BailObjective.LOCKED_STACK, i -> i + 1);
                return false;
            });
        });
        CommonEvents.LISTENER_LEAVE.register(this, data -> {
            RoyaleSkillSnapshotData.SkillSnapshot skillSnap;
            if (data.getVault() != vault) {
                return;
            }
            ServerPlayer player = data.getListener().getPlayer().orElse(null);
            if (player == null) {
                return;
            }
            this.crateSlotCache.remove(player.m_142081_());
            ItemStack crateWithItems = null;
            for (int slot = 0; slot < player.m_150109_().m_6643_(); ++slot) {
                ItemStack stack = player.m_150109_().m_8020_(slot);
                if (!stack.m_150930_(ModBlocks.ROYALE_CRATE_BLOCK.m_5456_())) continue;
                crateWithItems = stack.m_41777_();
                break;
            }
            if (player.m_6084_()) {
                MiscUtils.clearPlayerInventory((Player)player);
                RoyaleInventorySnapshotData.get(player.m_183503_()).restoreSnapshot((Player)player);
            }
            if ((skillSnap = RoyaleSkillSnapshotData.get(player.m_183503_()).removeSnapshot(data.getListener().getId())) != null) {
                PlayerVaultStatsData.get(player.m_183503_()).resetSkillPoints(player);
                PlayerAbilitiesData.get(player.m_183503_()).setAbilities((Player)player, skillSnap.getAbilities());
                PlayerTalentsData.get(player.m_183503_()).setTalents((Player)player, skillSnap.getTalents());
                PlayerVaultStatsData.get(player.m_183503_()).addSkillPoints(player, skillSnap.getSkillPoints());
                PlayerVaultStatsData.get(player.m_183503_()).addPrestigePoints(player, skillSnap.getPrestigePoints());
            }
            vault.get(Vault.OBJECTIVES).forEach(BailObjective.class, b -> {
                b.modifyIfPresent(BailObjective.LOCKED_STACK, i -> i - 1);
                return false;
            });
            StatCollector stats = vault.get(Vault.STATS).get(data.getListener().get(Listener.ID));
            if (stats.getCompletion() == Completion.COMPLETED) {
                if (crateWithItems != null) {
                    player.m_150109_().m_150079_(crateWithItems);
                    player.m_150109_().m_6596_();
                }
                Block[] rewards = new Block[]{ModDecorativeBlocks.POLISHED_ROYALE_STONE, ModDecorativeBlocks.ROYALE_STONE_BRICKS, ModDecorativeBlocks.POLISHED_ROYALE_CHISELED_VAULT_STONE};
                Block reward = rewards[player.m_21187_().nextInt(rewards.length)];
                stats.modify(StatCollector.REWARD, statRewards -> {
                    statRewards.add(new ItemStack((ItemLike)reward));
                    return statRewards;
                });
            }
        });
        CommonEvents.PLAYER_ENTITY_PICKUP.register(this, data -> {
            ServerPlayer serverPlayer;
            if (data.getPlayer().f_19853_ != world) {
                return;
            }
            ItemEntity itemEntity = data.getItem();
            if (itemEntity.m_32055_().m_41619_()) {
                return;
            }
            Player patt9832$temp = data.getPlayer();
            if (patt9832$temp instanceof ServerPlayer && VoidStoneItem.shouldVoidItem(serverPlayer = (ServerPlayer)patt9832$temp, data.getItem(), serverPlayer.m_183503_(), vault.getOptional(Vault.WORLD).map(worldM -> worldM.getOr(WorldManager.THEME, null)).orElse(null))) {
                data.setCanceled(true);
                data.getItem().m_146870_();
                return;
            }
            if (itemEntity.m_32055_().m_41782_() && itemEntity.m_32055_().m_41783_() != null && itemEntity.m_32055_().m_41783_().m_128441_("VaultRoyaleLootable") && itemEntity.m_32055_().m_41783_().m_128471_("VaultRoyaleLootable")) {
                return;
            }
            AtomicReference<ItemStack> remainingStackSimulated = new AtomicReference<ItemStack>(itemEntity.m_32055_().m_41777_());
            Player player = data.getPlayer();
            ItemStack crateStack = ItemStack.f_41583_;
            Integer cachedSlot = this.crateSlotCache.get(player.m_142081_());
            if (cachedSlot != null && cachedSlot >= 0 && cachedSlot < player.m_150109_().m_6643_()) {
                ItemStack cachedStack = player.m_150109_().m_8020_(cachedSlot.intValue());
                if (cachedStack.m_150930_(ModBlocks.ROYALE_CRATE_BLOCK.m_5456_())) {
                    crateStack = cachedStack;
                } else {
                    this.crateSlotCache.remove(player.m_142081_());
                }
            }
            if (crateStack.m_41619_()) {
                for (int slot = 0; slot < player.m_150109_().m_6643_(); ++slot) {
                    ItemStack stack = player.m_150109_().m_8020_(slot);
                    if (!stack.m_150930_(ModBlocks.ROYALE_CRATE_BLOCK.m_5456_())) continue;
                    this.crateSlotCache.put(player.m_142081_(), slot);
                    crateStack = stack;
                    break;
                }
            }
            if (!crateStack.m_41619_() && RoyaleCrateBlock.addItem(crateStack, remainingStackSimulated.get())) {
                player.m_150109_().m_6596_();
                data.setCanceled(true);
                data.getItem().m_146870_();
                world.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12019_, SoundSource.PLAYERS, 0.2f, RandHelper.getRandomMinusOneToOne((Random)world.f_46441_) * 1.4f + 2.0f);
            }
        });
        CommonEvents.ITEM_SCAVENGE_TASK.register(this, data -> {
            if (data.getVault() != vault) {
                return;
            }
            data.getItems().forEach(item -> item.m_41784_().m_128379_("VaultRoyaleLootable", true));
        });
        super.initServer(world, vault);
    }

    @Override
    public boolean render(Vault vault, PoseStack matrixStack, Window window, float partialTicks, Player player) {
        return false;
    }

    @Override
    public boolean isActive(VirtualWorld world, Vault vault, Objective objective) {
        return objective == this;
    }

    public int getRoyaleScore(Vault vault, Player player) {
        StatCollector stats = vault.get(Vault.STATS).get(player.m_142081_());
        Object2IntMap<ResourceLocation> kills = stats.getEntitiesKilled();
        Object2FloatMap<ResourceLocation> damageTaken = stats.getDamageReceived();
        int killScore = kills.values().stream().mapToInt(Integer::intValue).sum();
        double damageScore = damageTaken.values().stream().mapToDouble(Float::doubleValue).sum();
        double score = (double)killScore * 7.3 + Math.sqrt(killScore * 13 + 1) - Math.log1p(damageScore) * 11.2 + (killScore > 0 ? Math.pow(killScore, 1.2) : 0.0);
        return (int)Math.max(score, 0.0);
    }
}

