/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.core.vault.objective;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import iskallia.vault.VaultMod;
import iskallia.vault.block.entity.BossRunePillarTileEntity;
import iskallia.vault.client.gui.helper.LightmapHelper;
import iskallia.vault.core.Version;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.data.adapter.vault.DirectAdapter;
import iskallia.vault.core.data.key.FieldKey;
import iskallia.vault.core.data.key.PaletteKey;
import iskallia.vault.core.data.key.SupplierKey;
import iskallia.vault.core.data.key.TemplatePoolKey;
import iskallia.vault.core.data.key.registry.FieldRegistry;
import iskallia.vault.core.event.CommonEvents;
import iskallia.vault.core.random.JavaRandom;
import iskallia.vault.core.util.RegionPos;
import iskallia.vault.core.vault.Vault;
import iskallia.vault.core.vault.VaultRegistry;
import iskallia.vault.core.vault.WorldManager;
import iskallia.vault.core.vault.objective.ArchitectObjective;
import iskallia.vault.core.vault.objective.Objective;
import iskallia.vault.core.vault.objective.rune.RuneBossFight;
import iskallia.vault.core.vault.objective.rune.RuneBossFights;
import iskallia.vault.core.vault.objective.scavenger.ScavengeTask;
import iskallia.vault.core.vault.player.Listener;
import iskallia.vault.core.vault.player.Runner;
import iskallia.vault.core.world.generator.layout.ClassicInfiniteLayout;
import iskallia.vault.core.world.generator.layout.VaultLayout;
import iskallia.vault.core.world.processor.Palette;
import iskallia.vault.core.world.storage.VirtualWorld;
import iskallia.vault.core.world.template.data.TemplatePool;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.init.ModItems;
import iskallia.vault.item.BossRuneItem;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class RuneBossObjective
extends Objective {
    public static final SupplierKey<Objective> KEY = (SupplierKey)SupplierKey.of("rune_boss", Objective.class).with(Version.v1_27, (Objective)((Object)((Supplier<Objective>)RuneBossObjective::new)));
    public static final FieldRegistry FIELDS = Objective.FIELDS.merge(new FieldRegistry());
    public static final FieldKey<Float> OBJECTIVE_PROBABILITY = (FieldKey)FieldKey.of("objective_probability", Float.class).with(Version.v1_27, Adapters.FLOAT, DISK.all()).register(FIELDS);
    public static final FieldKey<RuneBossFights> FIGHTS = (FieldKey)FieldKey.of("fights", RuneBossFights.class).with(Version.v1_31, new DirectAdapter<RuneBossFights>((value, buffer, context) -> value.writeBits(buffer, context), (buffer, context) -> {
        RuneBossFights fights = new RuneBossFights();
        fights.readBits(buffer, context);
        return Optional.of(fights);
    }), DISK.all().or(CLIENT.all())).register(FIELDS);

    protected RuneBossObjective() {
        this.set(FIGHTS, new RuneBossFights());
    }

    protected RuneBossObjective(float objectiveProbability) {
        this.set(OBJECTIVE_PROBABILITY, Float.valueOf(objectiveProbability));
        this.set(FIGHTS, new RuneBossFights());
    }

    public static RuneBossObjective of(float objectiveProbability) {
        return new RuneBossObjective(objectiveProbability);
    }

    @Override
    public SupplierKey<Objective> getKey() {
        return KEY;
    }

    @Override
    public FieldRegistry getFields() {
        return FIELDS;
    }

    @Override
    public void initServer(VirtualWorld world, Vault vault) {
        CommonEvents.OBJECTIVE_PIECE_GENERATION.register(this, data -> {
            if (data.getVault() != vault) {
                return;
            }
            data.setProbability(0.0);
        });
        this.registerObjectiveTemplate(world, vault);
        CommonEvents.SCAVENGER_ALTAR_CONSUME.register(this, data -> {
            BlockEntity patt4497$temp = data.getTile();
            if (patt4497$temp instanceof BossRunePillarTileEntity) {
                BossRunePillarTileEntity pillar = (BossRunePillarTileEntity)patt4497$temp;
                if (data.getLevel() != world || pillar.getItemPlacedBy() == null) {
                    return;
                }
                Listener listener = vault.get(Vault.LISTENERS).get(pillar.getItemPlacedBy());
                if (!(listener instanceof Runner)) {
                    return;
                }
                boolean creative = listener.getPlayer().map(ServerPlayer::m_7500_).orElse(false);
                CompoundTag nbt = pillar.getHeldItem().m_41783_();
                if (!(creative || nbt != null && nbt.m_128461_("VaultId").equals(vault.get(Vault.ID).toString()))) {
                    return;
                }
                while (!pillar.getHeldItem().m_41619_()) {
                    if (pillar.getHeldItem().m_41720_() instanceof BossRuneItem) {
                        pillar.getModifiers().add(BossRuneItem.getRuneModifiers(pillar.getHeldItem()));
                        pillar.getLoot().addAll(BossRuneItem.getItems(pillar.getHeldItem()));
                        pillar.getHeldItem().m_41774_(1);
                        pillar.setRuneCount(pillar.getRuneCount() + 1);
                        continue;
                    }
                    return;
                }
            }
        });
        CommonEvents.RUNE_BOSS_START.register(this, data -> {
            if (data.getLevel() != world) {
                return;
            }
            BlockEntity patt5935$temp = data.getTile();
            if (!(patt5935$temp instanceof BossRunePillarTileEntity)) {
                return;
            }
            BossRunePillarTileEntity te = (BossRunePillarTileEntity)patt5935$temp;
            RuneBossFights fights = this.get(FIGHTS);
            BlockPos pillarPos = te.m_58899_();
            if (fights.hasFightAt(pillarPos)) {
                return;
            }
            if (!fights.hasPendingFight(data.getPlayer().m_142081_())) {
                fights.add(te.createFight());
            }
        });
        CommonEvents.ITEM_SCAVENGE_TASK.register(this, data -> {
            if (data.getWorld() != world) {
                return;
            }
            JavaRandom random = JavaRandom.ofNanoTime();
            data.getItems().forEach(stack -> {
                if (stack.m_41720_() == ModItems.BOSS_RUNE) {
                    BossRuneItem.setRuneModifiers(stack, ModConfigs.VAULT_BOSS.rollRuneModifiers(random));
                    BossRuneItem.setItems(stack, ModConfigs.VAULT_BOSS.getRandomLootItems(data.getVault().get(Vault.LEVEL).get(), random));
                    BossRuneItem.setVault(stack, vault);
                }
            });
        });
        for (ScavengeTask task : ModConfigs.RUNE_BOSS.getTasks()) {
            task.initServer(world, vault, this);
        }
        CommonEvents.LAYOUT_TEMPLATE_GENERATION.register(this, data -> {
            boolean hasInscriptions;
            if (data.getVault() != vault || data.getPieceType() != VaultLayout.PieceType.ROOM) {
                return;
            }
            Direction facing = data.getVault().get(Vault.WORLD).get(WorldManager.FACING);
            RegionPos back = data.getRegion().add(facing, -(data.getLayout().get(ClassicInfiniteLayout.TUNNEL_SPAN) + 1));
            boolean bl = hasInscriptions = !vault.get(Vault.OBJECTIVES).getAll(ArchitectObjective.class).isEmpty();
            if (back.m_123341_() == 0 && back.m_123343_() == 0 || data.getRandom().nextFloat() < this.getOr(OBJECTIVE_PROBABILITY, Float.valueOf(0.0f)).floatValue()) {
                TemplatePoolKey key = VaultRegistry.TEMPLATE_POOL.getKey(VaultMod.id("vault/rooms/special/boss"));
                if (key == null) {
                    return;
                }
                if (data.getTemplate() != null) {
                    return;
                }
                if (back.m_123341_() == 0 && back.m_123343_() == 0 || !hasInscriptions) {
                    data.setTemplate(data.getLayout().getRoom((TemplatePool)key.get(vault.get(Vault.VERSION)), vault, vault.get(Vault.VERSION), data.getRegion(), data.getRandom(), data.getSettings()));
                    ResourceLocation theme = vault.get(Vault.WORLD).get(WorldManager.THEME);
                    ResourceLocation id = new ResourceLocation(theme.toString().replace("classic_vault_", "universal_"));
                    PaletteKey palette = VaultRegistry.PALETTE.getKey(id);
                    if (id.toString().contains("chaos")) {
                        palette = VaultRegistry.PALETTE.getKey(VaultMod.id("universal_sweet"));
                    }
                    data.getSettings().addProcessor((Palette)palette.get(Version.latest()));
                }
            }
        });
        this.get(FIGHTS).onAttach(world, vault);
        super.initServer(world, vault);
    }

    @Override
    public void tickServer(VirtualWorld world, Vault vault) {
        this.get(FIGHTS).onTick(world, vault);
    }

    @Override
    public void releaseServer() {
        this.get(FIGHTS).onDetach();
        super.releaseServer();
    }

    @Override
    public void tickListener(VirtualWorld world, Vault vault, Listener listener) {
        if (listener.getPriority(this) < 0) {
            listener.addObjective(vault, this);
        }
        if (this.get(FIGHTS).getFight(listener.getId()).isPresent() && this.get(FIGHTS).getFight(listener.getId()).get().isCompleted()) {
            super.tickListener(world, vault, listener);
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean render(Vault vault, PoseStack matrixStack, Window window, float partialTicks, Player player) {
        Optional<RuneBossFight> fight = this.get(FIGHTS).getFight(player.m_142081_());
        if (fight.isPresent() && fight.get().isCompleted()) {
            boolean rendered = false;
            for (Objective objective : (Objective.ObjList)this.get(CHILDREN)) {
                rendered |= objective.render(vault, matrixStack, window, partialTicks, player);
            }
            if (rendered) {
                return true;
            }
        }
        if (fight.isEmpty()) {
            int midX = window.m_85445_() / 2;
            Font font = Minecraft.m_91087_().f_91062_;
            MultiBufferSource.BufferSource buffer = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
            MutableComponent txt = new TextComponent("Collect Runes!").m_130940_(ChatFormatting.AQUA);
            FormattedCharSequence formattedCharSequence = txt.m_7532_();
            float f = (float)midX - (float)font.m_92852_((FormattedText)txt) / 2.0f;
            Objects.requireNonNull(font);
            font.m_92733_(formattedCharSequence, f, 9.0f, -1, true, matrixStack.m_85850_().m_85861_(), (MultiBufferSource)buffer, false, 0, LightmapHelper.getPackedFullbrightCoords());
            buffer.m_109911_();
        } else {
            fight.get().render(matrixStack, window, partialTicks);
        }
        return true;
    }

    @Override
    public boolean isActive(VirtualWorld world, Vault vault, Objective objective) {
        return true;
    }
}

