/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.core.vault.objective;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.vertex.PoseStack;
import iskallia.vault.core.Version;
import iskallia.vault.core.data.DataMap;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.data.adapter.number.LegacySegmentedIntAdapter;
import iskallia.vault.core.data.adapter.vault.CompoundAdapter;
import iskallia.vault.core.data.key.FieldKey;
import iskallia.vault.core.data.key.SupplierKey;
import iskallia.vault.core.data.key.registry.FieldRegistry;
import iskallia.vault.core.event.CommonEvents;
import iskallia.vault.core.vault.Vault;
import iskallia.vault.core.vault.objective.Objective;
import iskallia.vault.core.vault.player.Listener;
import iskallia.vault.core.vault.player.Runner;
import iskallia.vault.core.vault.time.TickClock;
import iskallia.vault.core.world.storage.VirtualWorld;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetTitleTextPacket;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.FireworkRocketEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class VictoryObjective
extends Objective {
    public static final SupplierKey<Objective> KEY = (SupplierKey)SupplierKey.of("victory", Objective.class).with(Version.v1_0, (Objective)((Object)((Supplier<Objective>)VictoryObjective::new)));
    public static final FieldRegistry FIELDS = Objective.FIELDS.merge(new FieldRegistry());
    public static final FieldKey<Integer> TICKS_LEFT = (FieldKey)FieldKey.of("ticks_left", Integer.class).with(Version.v1_0, Adapters.INT_SEGMENTED_7, DISK.all().or(CLIENT.all())).with(Version.v1_19, Adapters.INT_SEGMENTED_7.asNullable(), DISK.all().or(CLIENT.all())).register(FIELDS);
    public static final FieldKey<Void> TICKED = (FieldKey)FieldKey.of("ticked", Void.class).with(Version.v1_0, Adapters.ofVoid(), DISK.all()).register(FIELDS);
    public static final FieldKey<TicksMap> TICKS = (FieldKey)FieldKey.of("ticks", TicksMap.class).with(Version.v1_1, CompoundAdapter.of(TicksMap::new), DISK.all().or(CLIENT.all())).register(FIELDS);

    protected VictoryObjective() {
        this.set(TICKS, new TicksMap());
    }

    protected VictoryObjective(int ticksLeft) {
        this.set(TICKS_LEFT, ticksLeft);
        this.set(TICKS, new TicksMap());
    }

    public static VictoryObjective of(int ticksLeft) {
        return new VictoryObjective(ticksLeft);
    }

    public static Objective empty() {
        return new VictoryObjective();
    }

    @Override
    public SupplierKey<Objective> getKey() {
        return KEY;
    }

    @Override
    public FieldRegistry getFields() {
        return FIELDS;
    }

    @Override
    public void initServer(VirtualWorld world, Vault vault) {
        CommonEvents.LISTENER_LEAVE.register(this, data -> {
            if (data.getVault() != vault) {
                return;
            }
            List<Listener> activeRunners = vault.get(Vault.LISTENERS).getAll().stream().filter(l -> l instanceof Runner && l.isOnline()).toList();
            long victoryRunnersCount = activeRunners.stream().filter(r -> this.get(TICKS).containsKey(r.getId())).count();
            vault.ifPresent(Vault.CLOCK, clock -> {
                if (!activeRunners.isEmpty() && (long)activeRunners.size() > victoryRunnersCount) {
                    clock.remove(TickClock.PAUSED);
                    if (this.has(TICKS_LEFT)) {
                        clock.set(TickClock.VISIBLE);
                    }
                }
            });
        });
    }

    @Override
    public void tickServer(VirtualWorld world, Vault vault) {
        vault.ifPresent(Vault.CLOCK, clock -> {
            clock.set(TickClock.PAUSED);
            if (this.has(TICKS_LEFT)) {
                clock.remove(TickClock.VISIBLE);
            }
        });
        super.tickServer(world, vault);
    }

    @Override
    public void tickListener(VirtualWorld world, Vault vault, Listener listener) {
        boolean firstTick;
        int ticksLeft;
        if (this.get(TICKS).containsKey(listener.getId())) {
            ticksLeft = (Integer)this.get(TICKS).get(listener.getId());
            firstTick = false;
        } else {
            ticksLeft = this.getOr(TICKS_LEFT, Integer.MAX_VALUE);
            firstTick = true;
            this.get(TICKS).put(listener.getId(), ticksLeft);
        }
        if (ticksLeft == 0) {
            vault.ifPresent(Vault.LISTENERS, listeners -> listeners.remove(world, vault, listener));
            return;
        }
        vault.ifPresent(Vault.CLOCK, clock -> {
            if (firstTick) {
                listener.getPlayer().ifPresent(player -> {
                    FireworkRocketEntity fireworks = new FireworkRocketEntity((Level)world, player.m_20185_(), player.m_20186_(), player.m_20189_(), new ItemStack((ItemLike)Items.f_42688_));
                    world.m_7967_((Entity)fireworks);
                    world.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12496_, SoundSource.MASTER, 0.6f, 1.0f);
                    TextComponent title = new TextComponent("Vault Completed!");
                    title.m_6270_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)14536734)));
                    ClientboundSetTitleTextPacket titlePacket = new ClientboundSetTitleTextPacket((Component)title);
                    player.f_8906_.m_141995_((Packet)titlePacket);
                    CommonEvents.ENTITY_DAMAGE.register(listener, event -> {
                        if (event.getEntity().equals(player)) {
                            event.setCanceled(true);
                        }
                    });
                });
            }
            if (this.has(TICKS_LEFT) && ticksLeft % 20 == 0) {
                listener.getPlayer().ifPresent(player -> {
                    String s = "Teleporting back in %d seconds...".formatted(ticksLeft / 20);
                    player.m_5661_((Component)new TextComponent(s).m_130940_(ChatFormatting.WHITE), true);
                });
            }
        });
        if (this.has(TICKS_LEFT)) {
            this.get(TICKS).put(listener.getId(), ticksLeft - 1);
        }
        super.tickListener(world, vault, listener);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean render(Vault vault, PoseStack matrixStack, Window window, float partialTicks, Player player) {
        return false;
    }

    @Override
    public boolean isActive(VirtualWorld world, Vault vault, Objective objective) {
        return objective == this;
    }

    private static class TicksMap
    extends DataMap<TicksMap, UUID, Integer> {
        public TicksMap() {
            super(new HashMap(), Adapters.UUID, LegacySegmentedIntAdapter._7);
        }
    }
}

