/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.core.vault.objective.bingo;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import iskallia.vault.core.Version;
import iskallia.vault.core.data.DataObject;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.data.adapter.IBitAdapter;
import iskallia.vault.core.data.key.FieldKey;
import iskallia.vault.core.data.key.registry.FieldRegistry;
import iskallia.vault.core.data.sync.context.SyncContext;
import iskallia.vault.core.net.BitBuffer;
import iskallia.vault.core.random.JavaRandom;
import iskallia.vault.core.random.RandomSource;
import iskallia.vault.core.vault.Vault;
import iskallia.vault.core.vault.modifier.spi.VaultModifier;
import iskallia.vault.core.vault.objective.bingo.BingoItem;
import iskallia.vault.core.vault.player.Listener;
import iskallia.vault.core.world.storage.VirtualWorld;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.task.source.EntityTaskSource;
import iskallia.vault.task.source.TaskSource;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;

public class BingoCard
extends DataObject<BingoCard> {
    public static final FieldRegistry FIELDS = new FieldRegistry();
    public static final FieldKey<TaskSource> ENTITY_TASK_SOURCE = (FieldKey)FieldKey.of("entity_task_source", TaskSource.class).with(Version.v1_0, Adapters.TASK_SOURCE, DISK.all()).register(FIELDS);
    private static final IBitAdapter<BingoItems, SyncContext> ITEMS_ADAPTER = new IBitAdapter<BingoItems, SyncContext>(){

        @Override
        public void writeBits(@Nullable BingoItems value, BitBuffer buffer, SyncContext context) {
            if (value == null) {
                buffer.writeBoolean(false);
                return;
            }
            buffer.writeBoolean(true);
            value.writeBits(buffer, context);
        }

        @Override
        public Optional<BingoItems> readBits(BitBuffer buffer, SyncContext context) {
            if (!buffer.readBoolean()) {
                return Optional.empty();
            }
            return Optional.of(BingoItems.readBits(buffer, context));
        }
    };
    public static final FieldKey<BingoItems> ITEMS = (FieldKey)FieldKey.of("items", BingoItems.class).with(Version.v1_0, ITEMS_ADAPTER, DISK.all().or(CLIENT.all())).register(FIELDS);
    public static final FieldKey<Integer> COMPLETED_BINGOS = (FieldKey)FieldKey.of("completed_bingos", Integer.class).with(Version.v1_0, Adapters.INT, DISK.all().or(CLIENT.all())).register(FIELDS);
    public static final FieldKey<ResourceLocation> MODIFIER_POOL = (FieldKey)FieldKey.of("modifier_pool", ResourceLocation.class).with(Version.v1_0, Adapters.IDENTIFIER, DISK.all().or(CLIENT.all())).register(FIELDS);

    @Override
    public FieldRegistry getFields() {
        return FIELDS;
    }

    public BingoCard() {
    }

    public BingoCard(int level, EntityTaskSource entityTaskSource) {
        this.set(ENTITY_TASK_SOURCE, entityTaskSource);
        this.set(COMPLETED_BINGOS, 0);
        this.initFromConfig(level, entityTaskSource);
    }

    private void initFromConfig(int level, EntityTaskSource entityTaskSource) {
        BingoItems items = new BingoItems();
        this.set(ITEMS, items);
    }

    public void onTick(VirtualWorld world, Vault vault) {
        TaskSource taskSource = this.get(ENTITY_TASK_SOURCE);
        BingoItems bingoItems = this.get(ITEMS);
        int completedBingosBeforeCheck = this.getCompletedBingos();
        if (bingoItems.onTick(world, taskSource) && this.checkCompletion()) {
            if (this.isFullyCompleted()) {
                // empty if block
            }
            int newlyCompletedBingos = this.getCompletedBingos() - completedBingosBeforeCheck;
            this.addModifiersToVault(vault, newlyCompletedBingos);
            this.playBingoCompletionNotification(world, taskSource, bingoItems.lastCompletedByPlayerName);
        }
    }

    private void addModifiersToVault(Vault vault, int newlyCompletedBingos) {
        JavaRandom random = JavaRandom.ofNanoTime();
        for (int i = 0; i < newlyCompletedBingos; ++i) {
            this.addModifier(vault, random);
        }
    }

    public void addModifier(Vault vault, RandomSource random) {
        ArrayList modifiers = new ArrayList(ModConfigs.VAULT_MODIFIER_POOLS.getRandom(this.get(MODIFIER_POOL), vault.get(Vault.LEVEL).get(), random));
        Object2IntOpenHashMap groups = new Object2IntOpenHashMap();
        modifiers.forEach(arg_0 -> BingoCard.lambda$addModifier$0((Object2IntMap)groups, arg_0));
        ObjectIterator it = groups.object2IntEntrySet().iterator();
        TextComponent modifierNames = new TextComponent("");
        while (it.hasNext()) {
            Object2IntMap.Entry entry = (Object2IntMap.Entry)it.next();
            modifierNames.m_7220_(((VaultModifier)entry.getKey()).getChatDisplayNameComponent(entry.getIntValue()));
            if (!it.hasNext()) continue;
            modifierNames.m_7220_((Component)new TextComponent(", "));
        }
        TextComponent text = new TextComponent("");
        if (!modifiers.isEmpty()) {
            String lastCompletedByPlayerName = this.get(BingoCard.ITEMS).lastCompletedByPlayerName;
            text.m_130946_(lastCompletedByPlayerName != null ? lastCompletedByPlayerName : "").m_7220_((Component)new TextComponent(" added ").m_130940_(ChatFormatting.GRAY)).m_7220_((Component)modifierNames).m_7220_((Component)new TextComponent(".").m_130940_(ChatFormatting.GRAY));
        }
        groups.forEach((modifier, count) -> vault.get(Vault.MODIFIERS).addModifier((VaultModifier<?>)modifier, (int)count, true, random));
        for (Listener listener : vault.get(Vault.LISTENERS).getAll()) {
            listener.getPlayer().ifPresent(other -> other.m_5661_((Component)text, false));
        }
    }

    private void playBingoCompletionNotification(VirtualWorld world, TaskSource taskSource, String lastCompletedByPlayerName) {
        if (taskSource instanceof EntityTaskSource) {
            EntityTaskSource entityTaskSource = (EntityTaskSource)taskSource;
            entityTaskSource.getEntities(Player.class).forEach(player -> {
                world.m_6269_(null, (Entity)player, SoundEvents.f_12211_, SoundSource.MASTER, 1.0f, 0.75f + world.m_5822_().nextFloat() * 0.25f);
                player.m_6352_((Component)new TextComponent(lastCompletedByPlayerName).m_7220_((Component)new TextComponent(" completed a Bingo!").m_130940_(ChatFormatting.GRAY)), Util.f_137441_);
            });
        }
    }

    public void addPlayer(UUID playerId) {
        TaskSource taskSource = this.get(ENTITY_TASK_SOURCE);
        if (taskSource instanceof EntityTaskSource) {
            EntityTaskSource entityTaskSource = (EntityTaskSource)taskSource;
            entityTaskSource.add(playerId);
            this.get(ITEMS).adjustToOneMorePlayer(entityTaskSource.getEntities(Player.class).size(), entityTaskSource);
        }
    }

    public void onAttach() {
        this.get(ITEMS).onAttach(this.get(ENTITY_TASK_SOURCE));
    }

    public void onDetach() {
        this.get(ITEMS).onDetach();
    }

    public boolean isFullyCompleted() {
        return this.get(COMPLETED_BINGOS) >= 12;
    }

    public int getCompletedBingos() {
        return this.get(COMPLETED_BINGOS);
    }

    public boolean checkCompletion() {
        if (this.isFullyCompleted()) {
            return false;
        }
        long completed = 0L;
        TaskSource taskSource = this.get(ENTITY_TASK_SOURCE);
        completed = this.get(ITEMS).rowValues().stream().filter(row -> BingoCard.checkAndMarkItemsForBingoCompletion(row.values(), taskSource)).count();
        completed += this.get(ITEMS).columnValues().stream().filter(col -> BingoCard.checkAndMarkItemsForBingoCompletion(col.values(), taskSource)).count();
        if (BingoCard.checkAndMarkItemsForBingoCompletion(this.getDiagonalItems(true), taskSource)) {
            ++completed;
        }
        if (BingoCard.checkAndMarkItemsForBingoCompletion(this.getDiagonalItems(false), taskSource)) {
            ++completed;
        }
        if (completed > (long)this.get(COMPLETED_BINGOS).intValue()) {
            this.set(COMPLETED_BINGOS, (int)completed);
            return true;
        }
        return false;
    }

    private List<BingoItem> getDiagonalItems(boolean first) {
        ArrayList<BingoItem> items = new ArrayList<BingoItem>();
        for (int i = 0; i < 5; ++i) {
            items.add(this.get(ITEMS).getItem(i, first ? i : 4 - i));
        }
        return items;
    }

    private static boolean checkAndMarkItemsForBingoCompletion(Collection<BingoItem> items, TaskSource taskSource) {
        boolean allComplete = false;
        if (allComplete) {
            items.forEach(BingoItem::markPartOfCompletedBingo);
            return true;
        }
        return false;
    }

    private static /* synthetic */ void lambda$addModifier$0(Object2IntMap groups, VaultModifier modifier) {
        groups.put((Object)modifier, groups.getOrDefault((Object)modifier, 0) + 1);
    }

    public static class BingoItems {
        private final Table<Integer, Integer, BingoItem> items = HashBasedTable.create();
        @Nullable
        private String lastCompletedByPlayerName = null;

        public boolean onTick(VirtualWorld world, TaskSource taskSource) {
            AtomicBoolean taskCompleted = new AtomicBoolean(false);
            this.items.values().forEach(item -> {});
            return taskCompleted.get();
        }

        public static BingoItems readBits(BitBuffer buffer, SyncContext context) {
            BingoItems ret = new BingoItems();
            int size = buffer.readInt();
            for (int i = 0; i < size; ++i) {
                int row = buffer.readInt();
                int column = buffer.readInt();
                Adapters.BINGO_ITEM.readBits(buffer, context).ifPresent(bingoItem -> ret.items.put((Object)row, (Object)column, bingoItem));
            }
            return ret;
        }

        public void writeBits(BitBuffer buffer, SyncContext context) {
            buffer.writeInt(this.items.size());
            this.items.cellSet().forEach(cell -> {
                buffer.writeInt((Integer)cell.getRowKey());
                buffer.writeInt((Integer)cell.getColumnKey());
                Adapters.BINGO_ITEM.writeBits((BingoItem)cell.getValue(), buffer, context);
            });
        }

        public void adjustToOneMorePlayer(int newNumberOfPlayers, EntityTaskSource taskSource) {
            this.items.values().forEach(item -> item.adjustToOneMorePlayer(newNumberOfPlayers, taskSource));
        }

        public void onAttach(TaskSource taskSource) {
        }

        public void onDetach() {
            this.items.values().forEach(BingoItem::onDetach);
        }

        public Collection<Map<Integer, BingoItem>> rowValues() {
            return this.rowMap().values();
        }

        public Map<Integer, Map<Integer, BingoItem>> rowMap() {
            return this.items.rowMap();
        }

        public Collection<Map<Integer, BingoItem>> columnValues() {
            return this.items.columnMap().values();
        }

        public Map<Integer, Map<Integer, BingoItem>> columnMap() {
            return this.items.columnMap();
        }

        public BingoItem getItem(int row, int column) {
            return (BingoItem)this.items.get((Object)row, (Object)column);
        }
    }
}

