/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.core.vault.objective.elixir;

import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import iskallia.vault.block.VaultChestBlock;
import iskallia.vault.core.Version;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.data.adapter.basic.EnumAdapter;
import iskallia.vault.core.data.key.FieldKey;
import iskallia.vault.core.data.key.SupplierKey;
import iskallia.vault.core.data.key.registry.FieldRegistry;
import iskallia.vault.core.event.CommonEvents;
import iskallia.vault.core.random.RandomSource;
import iskallia.vault.core.util.WeightedList;
import iskallia.vault.core.vault.Vault;
import iskallia.vault.core.vault.objective.ElixirObjective;
import iskallia.vault.core.vault.objective.elixir.ElixirTask;
import iskallia.vault.core.vault.stat.VaultChestType;
import iskallia.vault.core.world.roll.IntRoll;
import iskallia.vault.core.world.storage.VirtualWorld;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.world.level.block.Block;

public class ChestElixirTask
extends ElixirTask {
    public static final SupplierKey<ElixirTask> KEY = (SupplierKey)SupplierKey.of("chest", ElixirTask.class).with(Version.v1_12, (ElixirTask)((Object)((Supplier<ElixirTask>)ChestElixirTask::new)));
    public static final FieldRegistry FIELDS = ElixirTask.FIELDS.merge(new FieldRegistry());
    public static final FieldKey<VaultChestType> TYPE = (FieldKey)FieldKey.of("type", VaultChestType.class).with(Version.v1_12, Adapters.ofEnum(VaultChestType.class, EnumAdapter.Mode.ORDINAL), DISK.all()).register(FIELDS);

    protected ChestElixirTask() {
    }

    public ChestElixirTask(VaultChestType type, int elixir) {
        this.set(TYPE, type);
        this.set(ELIXIR, elixir);
    }

    @Override
    public SupplierKey<ElixirTask> getKey() {
        return KEY;
    }

    @Override
    public FieldRegistry getFields() {
        return FIELDS;
    }

    @Override
    public void initServer(VirtualWorld world, Vault vault, ElixirObjective objective, UUID listener) {
        if ((Integer)this.get(ELIXIR) == 0) {
            return;
        }
        CommonEvents.CHEST_LOOT_GENERATION.post().register(this, data -> {
            if (data.getPlayer().f_19853_ != world) {
                return;
            }
            if (!data.getPlayer().m_142081_().equals(listener)) {
                return;
            }
            Block patt2190$temp = data.getState().m_60734_();
            if (!(patt2190$temp instanceof VaultChestBlock)) {
                return;
            }
            VaultChestBlock chest = (VaultChestBlock)patt2190$temp;
            if (chest.getType() != this.get(TYPE)) {
                return;
            }
            this.summonOrbs(world, data.getPos(), (int)((Integer)this.get(ELIXIR)));
            objective.addProgress(listener, (Integer)this.get(ELIXIR), vault);
        });
    }

    @Override
    public void releaseServer() {
        CommonEvents.CHEST_LOOT_GENERATION.release(this);
    }

    public static class Config
    extends ElixirTask.Config<ChestElixirTask> {
        @Expose
        @SerializedName(value="chest_type")
        protected VaultChestType type;

        public Config(WeightedList<IntRoll> rolls, VaultChestType type) {
            super(rolls);
            this.type = type;
        }

        @Override
        protected ChestElixirTask create() {
            return new ChestElixirTask();
        }

        @Override
        protected ChestElixirTask configure(ChestElixirTask task, RandomSource random) {
            task.set(TYPE, this.type);
            return super.configure(task, random);
        }
    }
}

