/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.core.vault.objective.elixir;

import iskallia.vault.core.Version;
import iskallia.vault.core.data.key.SupplierKey;
import iskallia.vault.core.event.CommonEvents;
import iskallia.vault.core.util.WeightedList;
import iskallia.vault.core.vault.Vault;
import iskallia.vault.core.vault.objective.ElixirObjective;
import iskallia.vault.core.vault.objective.elixir.ElixirTask;
import iskallia.vault.core.world.roll.IntRoll;
import iskallia.vault.core.world.storage.VirtualWorld;
import java.util.UUID;
import java.util.function.Supplier;

public class CoinStacksElixirTask
extends ElixirTask {
    public static final SupplierKey<ElixirTask> KEY = (SupplierKey)SupplierKey.of("coin_stacks", ElixirTask.class).with(Version.v1_12, (ElixirTask)((Object)((Supplier<ElixirTask>)CoinStacksElixirTask::new)));

    protected CoinStacksElixirTask() {
    }

    public CoinStacksElixirTask(int elixir) {
        this.set(ELIXIR, elixir);
    }

    @Override
    public SupplierKey<ElixirTask> getKey() {
        return KEY;
    }

    @Override
    public void initServer(VirtualWorld world, Vault vault, ElixirObjective objective, UUID listener) {
        if ((Integer)this.get(ELIXIR) == 0) {
            return;
        }
        CommonEvents.COIN_STACK_LOOT_GENERATION.post().register(this, data -> {
            if (data.getPlayer().f_19853_ != world) {
                return;
            }
            if (!data.getPlayer().m_142081_().equals(listener)) {
                return;
            }
            this.summonOrbs(world, data.getPos(), (int)((Integer)this.get(ELIXIR)));
            objective.addProgress(listener, (Integer)this.get(ELIXIR), vault);
        });
    }

    @Override
    public void releaseServer() {
        CommonEvents.COIN_STACK_LOOT_GENERATION.release(this);
    }

    public static class Config
    extends ElixirTask.Config<CoinStacksElixirTask> {
        public Config(WeightedList<IntRoll> rolls) {
            super(rolls);
        }

        @Override
        protected CoinStacksElixirTask create() {
            return new CoinStacksElixirTask();
        }
    }
}

