/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.core.vault.objective.rune;

import iskallia.vault.core.Version;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.data.adapter.basic.EnumAdapter;
import iskallia.vault.core.data.key.PaletteKey;
import iskallia.vault.core.data.sync.context.SyncContext;
import iskallia.vault.core.net.BitBuffer;
import iskallia.vault.core.random.ChunkRandom;
import iskallia.vault.core.util.RegionPos;
import iskallia.vault.core.vault.Vault;
import iskallia.vault.core.vault.VaultRegistry;
import iskallia.vault.core.vault.WorldManager;
import iskallia.vault.core.vault.objective.rune.RuneBossFight;
import iskallia.vault.core.world.generator.GridGenerator;
import iskallia.vault.core.world.generator.VaultGenerator;
import iskallia.vault.core.world.processor.Palette;
import iskallia.vault.core.world.processor.ProcessorContext;
import iskallia.vault.core.world.processor.tile.MirrorTileProcessor;
import iskallia.vault.core.world.processor.tile.RotateTileProcessor;
import iskallia.vault.core.world.processor.tile.TileProcessor;
import iskallia.vault.core.world.processor.tile.TranslateTileProcessor;
import iskallia.vault.core.world.storage.IZonedWorld;
import iskallia.vault.core.world.template.JigsawTemplate;
import iskallia.vault.core.world.template.PlacementSettings;
import iskallia.vault.core.world.template.Template;
import iskallia.vault.init.ModSounds;
import iskallia.vault.mixin.AccessorChunkMap;
import iskallia.vault.world.data.ServerVaults;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.protocol.game.ClientboundLevelChunkWithLightPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.TickTask;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import org.apache.commons.lang3.mutable.MutableObject;

public class RuneBossAnimation {
    private State state = State.IDLE;
    private int ticker;

    public State getState() {
        return this.state;
    }

    public void onStart(State state) {
        this.state = state;
        this.ticker = 0;
    }

    public void onStop() {
        this.state = State.IDLE;
        this.ticker = 0;
    }

    public boolean isCompleted() {
        return this.ticker >= this.state.getTime();
    }

    public void onTick(ServerLevel world, BlockPos pos, RuneBossFight.RoomStyle roomStyle, Vault vault) {
        if (this.state == State.CLOSE_ROOM || this.state == State.OPEN_ROOM) {
            HashMap<BlockPos, Rotation> gates = new HashMap<BlockPos, Rotation>();
            int frames = 6;
            if (roomStyle == RuneBossFight.RoomStyle.BOSS_1) {
                gates.put(new BlockPos(23, 4, 0), Rotation.CLOCKWISE_180);
                gates.put(new BlockPos(-23, 4, 0), Rotation.NONE);
                gates.put(new BlockPos(0, 4, 23), Rotation.COUNTERCLOCKWISE_90);
                gates.put(new BlockPos(0, 4, -23), Rotation.CLOCKWISE_90);
            } else if (roomStyle == RuneBossFight.RoomStyle.BOSS_2) {
                gates.put(new BlockPos(23, 8, 0), Rotation.CLOCKWISE_180);
                gates.put(new BlockPos(-23, 8, 0), Rotation.NONE);
                gates.put(new BlockPos(0, 8, 23), Rotation.COUNTERCLOCKWISE_90);
                gates.put(new BlockPos(0, 8, -23), Rotation.CLOCKWISE_90);
            }
            Template template = null;
            int frameTime = this.state.getTime() / frames - 1;
            if (this.ticker % frameTime == 0 && this.ticker / frameTime < frames) {
                template = this.state == State.CLOSE_ROOM ? (Template)VaultRegistry.TEMPLATE.getKey(roomStyle.getGateFrame(this.ticker / frameTime)).get(Version.latest()) : (Template)VaultRegistry.TEMPLATE.getKey(roomStyle.getGateFrame(frames - this.ticker / frameTime - 1)).get(Version.latest());
                gates.forEach((offset, rotation) -> world.m_5594_(null, pos.m_141952_((Vec3i)offset), SoundEvents.f_12447_, SoundSource.BLOCKS, 1.4f, 0.8f));
            }
            if (this.ticker == 0) {
                gates.forEach((offset, rotation) -> world.m_5594_(null, pos.m_141952_((Vec3i)offset), ModSounds.RAID_HATCH_OPEN, SoundSource.BLOCKS, 1.4f, 1.1f));
                world.m_5594_(null, pos, ModSounds.RAID_HATCH_OPEN, SoundSource.BLOCKS, 1.4f, 0.8f);
            }
            if (template != null) {
                for (Map.Entry entry : gates.entrySet()) {
                    BlockPos offset2 = (BlockPos)entry.getKey();
                    Rotation rotation2 = (Rotation)entry.getValue();
                    this.place(world, template, pos, settings -> {
                        settings.addProcessor(TileProcessor.translate(0, switch (roomStyle) {
                            default -> throw new IncompatibleClassChangeError();
                            case RuneBossFight.RoomStyle.BOSS_1 -> -2;
                            case RuneBossFight.RoomStyle.BOSS_2 -> -4;
                        }, -2));
                        settings.addProcessor(TileProcessor.rotate(rotation2, (Vec3i)BlockPos.f_121853_, true));
                        settings.addProcessor(TileProcessor.translate((Vec3i)pos));
                        settings.addProcessor(TileProcessor.translate((Vec3i)offset2));
                        ResourceLocation theme = vault.get(Vault.WORLD).get(WorldManager.THEME);
                        ResourceLocation id = new ResourceLocation(theme.toString().replace("classic_vault_", "universal_"));
                        PaletteKey palette = VaultRegistry.PALETTE.getKey(id);
                        if (palette != null) {
                            settings.addProcessor((Palette)palette.get(Version.latest()));
                        }
                    });
                }
            }
        }
        ++this.ticker;
    }

    public void place(ServerLevel world, Template template, BlockPos pos, Consumer<PlacementSettings> configurator) {
        VaultGenerator vaultGenerator;
        ChunkRandom random = ChunkRandom.any();
        random.setRegionSeed(0L, pos.m_123341_(), pos.m_123343_(), 32573453L);
        Vault vault = ServerVaults.get((Level)world).orElse(null);
        if (vault != null) {
            VaultGenerator generator = vault.get(Vault.WORLD).get(WorldManager.GENERATOR);
            RegionPos region = RegionPos.of(pos.m_123341_(), pos.m_123343_(), generator.get(GridGenerator.CELL_X), generator.get(GridGenerator.CELL_Z));
            random.setRegionSeed(vault.get(Vault.SEED), region.m_123341_(), region.m_123343_(), 32573453L);
        }
        PlacementSettings settings = new PlacementSettings(new ProcessorContext(null, random)).setFlags(3);
        if (vault != null && (vaultGenerator = vault.get(Vault.WORLD).get(WorldManager.GENERATOR)) instanceof GridGenerator) {
            GridGenerator gen = (GridGenerator)vaultGenerator;
            RegionPos region = RegionPos.ofBlockPos(pos, gen.get(GridGenerator.CELL_X), gen.get(GridGenerator.CELL_Z));
            ChunkRandom chunkRandom = ChunkRandom.any();
            chunkRandom.setRegionSeed(vault.get(Vault.SEED), region.m_123341_(), region.m_123343_(), 1234567890L);
            JigsawTemplate room = (JigsawTemplate)gen.get(GridGenerator.LAYOUT).getAt(vault, region, chunkRandom, settings);
            room.getConfigurator().accept(settings);
            settings.getTileProcessors().removeIf(processor -> processor instanceof TranslateTileProcessor);
            settings.getTileProcessors().removeIf(processor -> processor instanceof MirrorTileProcessor);
            settings.getTileProcessors().removeIf(processor -> processor instanceof RotateTileProcessor);
            configurator.accept(settings);
        }
        AtomicReference<Object> pointer = new AtomicReference<Object>(null);
        settings.addProcessor(TileProcessor.of((_tile, context) -> {
            pointer.getAndUpdate(value -> {
                if (value == null) {
                    return BoundingBox.m_162375_((Vec3i)_tile.getPos(), (Vec3i)_tile.getPos());
                }
                return value.m_162371_(_tile.getPos());
            });
            return _tile;
        }));
        IZonedWorld.runWithBypass(world, true, () -> template.place((ServerLevelAccessor)world, settings));
        BoundingBox box = pointer.get();
        ServerChunkCache source = world.m_7726_();
        for (int x = box.m_162395_(); x < box.m_162399_(); x += x + 16 < box.m_162399_() ? 16 : 16 - Math.floorMod(x, 16)) {
            for (int z = box.m_162398_(); z < box.m_162401_(); z += z + 16 < box.m_162401_() ? 16 : 16 - Math.floorMod(z, 16)) {
                ChunkPos chunkPos = new ChunkPos(x >> 4, z >> 4);
                world.m_142572_().m_6937_((Runnable)new TickTask(world.m_142572_().m_129921_() + 1, () -> source.f_8325_.m_183262_(chunkPos, false).forEach(player -> {
                    world.m_6522_(chunkPos.f_45578_, chunkPos.f_45579_, ChunkStatus.f_62326_, true);
                    ((AccessorChunkMap)source.f_8325_).callUpdateChunkTracking((ServerPlayer)player, chunkPos, (MutableObject<ClientboundLevelChunkWithLightPacket>)new MutableObject(), false, true);
                })));
            }
        }
    }

    public void writeBits(BitBuffer buffer, SyncContext context) {
        Adapters.ofEnum(State.class, EnumAdapter.Mode.NAME).writeBits(this.state, buffer);
        Adapters.INT_SEGMENTED_7.writeBits(this.ticker, buffer);
    }

    public void readBits(BitBuffer buffer, SyncContext context) {
        this.state = Adapters.ofEnum(State.class, EnumAdapter.Mode.NAME).readBits(buffer).orElseThrow();
        this.ticker = (Integer)Adapters.INT_SEGMENTED_7.readBits(buffer).orElseThrow();
    }

    public static enum State {
        IDLE(0),
        CLOSE_ROOM(99),
        FIGHT(0),
        OPEN_ROOM(99);

        private final int time;

        private State(int time) {
            this.time = time;
        }

        public int getTime() {
            return this.time;
        }
    }
}

