/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.core.vault.objective.rune;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import iskallia.vault.VaultMod;
import iskallia.vault.block.entity.challenge.raid.RaidChallengeManager;
import iskallia.vault.client.gui.helper.LightmapHelper;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.data.adapter.basic.EnumAdapter;
import iskallia.vault.core.data.sync.context.SyncContext;
import iskallia.vault.core.event.CommonEvents;
import iskallia.vault.core.net.BitBuffer;
import iskallia.vault.core.vault.Vault;
import iskallia.vault.core.vault.objective.rune.RuneBossAnimation;
import iskallia.vault.core.world.data.entity.PartialEntity;
import iskallia.vault.core.world.storage.BlockCuboid;
import iskallia.vault.core.world.storage.IZonedWorld;
import iskallia.vault.core.world.storage.VirtualWorld;
import iskallia.vault.entity.boss.BossRuneModifiers;
import iskallia.vault.entity.boss.VaultBossEntity;
import iskallia.vault.util.AABBHelper;
import iskallia.vault.world.data.WorldZonesData;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.function.IntFunction;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.registries.ForgeRegistries;

public class RuneBossFight {
    private BlockPos origin;
    private BlockCuboid zone;
    private int zoneId;
    private RoomStyle roomStyle;
    private final Set<UUID> players;
    private PartialEntity boss;
    private BossRuneModifiers modifiers;
    private List<ItemStack> loot;
    private UUID bossId;
    private double currentHealth;
    private double totalHealth;
    private final RuneBossAnimation animation;
    private boolean completed;
    private boolean shieldActive;
    private int remainingRevives;
    private boolean waveBlastWarningActive;
    private int waveBlastWarningTicks;
    private int waveBlastWarningWindow;
    private int waveBlastCooldownDuration;
    private static final DecimalFormat DECIMAL_FORMAT = new DecimalFormat("#.##");

    public RuneBossFight() {
        this.players = new HashSet<UUID>();
        this.animation = new RuneBossAnimation();
        this.modifiers = new BossRuneModifiers();
        this.loot = new ArrayList<ItemStack>();
        this.waveBlastWarningActive = false;
        this.waveBlastWarningTicks = 0;
        this.waveBlastWarningWindow = 0;
        this.waveBlastCooldownDuration = 0;
    }

    public RuneBossFight(BlockPos origin, BlockCuboid zone, int zoneId, RoomStyle roomStyle, PartialEntity boss, BossRuneModifiers modifiers, List<ItemStack> loot) {
        this.origin = origin;
        this.zone = zone;
        this.zoneId = zoneId;
        this.roomStyle = roomStyle;
        this.players = new HashSet<UUID>();
        this.boss = boss;
        this.animation = new RuneBossAnimation();
        this.modifiers = modifiers == null ? new BossRuneModifiers() : modifiers;
        this.loot = loot;
        this.waveBlastWarningActive = false;
        this.waveBlastWarningTicks = 0;
        this.waveBlastWarningWindow = 0;
        this.waveBlastCooldownDuration = 0;
    }

    public Set<UUID> getPlayers() {
        return this.players;
    }

    public BlockPos getOrigin() {
        return this.origin;
    }

    public boolean isCompleted() {
        return this.completed;
    }

    public boolean isCompleting() {
        return this.animation.getState().equals((Object)RuneBossAnimation.State.CLOSE_ROOM) && this.bossId == null;
    }

    public void onAttach(VirtualWorld world, Vault vault) {
        CommonEvents.SERVER_TICK.at(TickEvent.Phase.END).register(this, event -> this.onTick(world, vault));
    }

    public void onDetach() {
        CommonEvents.SERVER_TICK.release(this);
    }

    public void onTick(VirtualWorld world, Vault vault) {
        if (this.completed) {
            return;
        }
        this.refreshPlayers(world);
        if (this.animation.getState() == RuneBossAnimation.State.IDLE) {
            this.animation.onStart(RuneBossAnimation.State.CLOSE_ROOM);
        }
        if (this.animation.getState() == RuneBossAnimation.State.CLOSE_ROOM && this.animation.isCompleted()) {
            IZonedWorld.runWithBypass((Object)world, true, () -> world.m_7731_(this.origin, Blocks.f_50016_.m_49966_(), 3));
            this.summonBoss(world);
            this.animation.onStart(RuneBossAnimation.State.FIGHT);
        }
        if (this.animation.getState() == RuneBossAnimation.State.FIGHT && this.bossId == null) {
            this.animation.onStart(RuneBossAnimation.State.OPEN_ROOM);
            this.completed = true;
        }
        if (this.animation.getState() == RuneBossAnimation.State.OPEN_ROOM && this.animation.isCompleted()) {
            WorldZonesData.get(world.m_142572_()).getOrCreate((ResourceKey<Level>)world.m_46472_()).remove(this.zoneId);
        }
        this.updateHealth(world);
        this.animation.onTick(world, this.origin, this.roomStyle, vault);
    }

    public void summonBoss(ServerLevel world) {
        EntityType type = (EntityType)ForgeRegistries.ENTITIES.getValue(this.boss.getId());
        Entity entity = type.m_20600_(world, null, null, null, this.origin, MobSpawnType.SPAWNER, false, false);
        this.boss.getNbt().asWhole().ifPresent(nbt -> {
            nbt.m_128473_("UUID");
            entity.deserializeNBT(nbt);
        });
        entity.m_6034_((double)this.origin.m_123341_() + 0.5, (double)this.origin.m_123342_(), (double)this.origin.m_123343_() + 0.5);
        if (entity instanceof VaultBossEntity) {
            VaultBossEntity boss = (VaultBossEntity)entity;
            boss.setLoot(this.loot);
            boss.addTraits(this.modifiers);
            boss.m_21530_();
        }
        world.m_7967_(entity);
        this.bossId = entity.m_142081_();
    }

    private void cleanupSummonedMinions(VirtualWorld world) {
        if (this.origin != null) {
            ServerLevel serverLevel = world.m_6018_();
            Vec3 bossPos = new Vec3((double)this.origin.m_123341_() + 0.5, (double)this.origin.m_123342_(), (double)this.origin.m_123343_() + 0.5);
            AABB searchBox = AABBHelper.create(bossPos, 30.0f);
            serverLevel.m_6443_(LivingEntity.class, searchBox, entity -> entity.m_19880_().contains("boss_summoned")).forEach(mob -> {
                mob.m_6469_(DamageSource.f_19318_, 10000.0f);
                mob.m_6074_();
            });
        }
    }

    private void updateHealth(VirtualWorld world) {
        if (this.bossId == null) {
            return;
        }
        Entity entity = world.m_8791_(this.bossId);
        if (entity == null) {
            this.bossId = null;
            this.shieldActive = false;
            this.remainingRevives = 0;
            this.cleanupSummonedMinions(world);
            this.waveBlastWarningActive = false;
            this.waveBlastWarningTicks = 0;
            this.waveBlastWarningWindow = 0;
            this.waveBlastCooldownDuration = 0;
        } else {
            double total = 0.0;
            this.currentHealth = 0.0;
            if (entity instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)entity;
                this.currentHealth += (double)living.m_21223_();
                total += (double)living.m_21233_();
            }
            this.shieldActive = false;
            this.remainingRevives = 0;
            this.waveBlastWarningActive = false;
            this.waveBlastWarningTicks = 0;
            this.waveBlastWarningWindow = 0;
            this.waveBlastCooldownDuration = 0;
            if (entity instanceof VaultBossEntity) {
                VaultBossEntity bossEntity = (VaultBossEntity)entity;
                this.shieldActive = bossEntity.isRuneShieldActive();
                this.remainingRevives = bossEntity.getRuneReviveCount();
                bossEntity.getRuneWaveBlastWarning().ifPresentOrElse(warning -> {
                    this.waveBlastWarningActive = true;
                    this.waveBlastWarningTicks = warning.remainingTicks();
                    this.waveBlastWarningWindow = warning.windowTicks();
                }, () -> {
                    this.waveBlastWarningActive = false;
                    this.waveBlastWarningTicks = 0;
                    this.waveBlastWarningWindow = bossEntity.getRuneWaveBlastWarningDuration();
                });
                this.waveBlastCooldownDuration = bossEntity.getRuneWaveBlastCooldownDuration();
            }
            if (total > this.totalHealth) {
                this.totalHealth = total;
            }
        }
    }

    public void refreshPlayers(ServerLevel world) {
        HashSet<ServerPlayer> toRemove = new HashSet<ServerPlayer>();
        for (UUID uuid : this.players) {
            ServerPlayer player = world.m_142572_().m_6846_().m_11259_(uuid);
            if (player == null || player.f_19853_ == world && this.zone.offset((Vec3i)this.origin).grow(-1, -1, -1).contains((Vec3i)player.m_142538_())) continue;
            toRemove.add(player);
        }
        for (ServerPlayer player : toRemove) {
            this.players.remove(player.m_142081_());
        }
        for (ServerPlayer player : world.m_6907_()) {
            if (!this.zone.offset((Vec3i)this.origin).grow(-1, -1, -1).contains((Vec3i)player.m_142538_())) continue;
            this.players.add(player.m_142081_());
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void render(PoseStack matrixStack, Window window, float partialTicks) {
        double safeTotal = Math.max(1.0, this.totalHealth);
        double progress = safeTotal <= 0.0 ? 0.0 : Mth.m_14008_((double)(this.currentHealth / safeTotal), (double)0.0, (double)1.0);
        boolean countdownActive = this.waveBlastWarningActive && this.waveBlastWarningWindow > 0;
        float barProgress = (float)progress;
        if (countdownActive) {
            int countdownWindow = this.waveBlastWarningWindow;
            if (this.waveBlastCooldownDuration > 0) {
                countdownWindow = Math.min(countdownWindow, this.waveBlastCooldownDuration);
            }
            barProgress = Mth.m_14036_((float)((float)this.waveBlastWarningTicks / (float)countdownWindow), (float)0.0f, (float)1.0f);
        }
        TextComponent txt = new TextComponent("");
        if (countdownActive) {
            double secondsLeft = Math.max(0.0, (double)this.waveBlastWarningTicks / 20.0);
            String secondsText = String.format(Locale.ROOT, "%.1f", secondsLeft);
            txt.m_7220_((Component)new TextComponent("Wave Blast ").m_130940_(ChatFormatting.GOLD)).m_7220_((Component)new TextComponent(secondsText + "s").m_130940_(ChatFormatting.YELLOW));
            txt.m_7220_((Component)new TextComponent(" \u2022 ").m_130940_(ChatFormatting.DARK_GRAY));
        }
        txt.m_7220_((Component)new TextComponent(DECIMAL_FORMAT.format(this.currentHealth) + " / " + DECIMAL_FORMAT.format(safeTotal)).m_130940_(ChatFormatting.WHITE));
        if (this.shieldActive) {
            txt.m_7220_((Component)new TextComponent(" \u2022 ").m_130940_(ChatFormatting.DARK_GRAY));
            txt.m_7220_((Component)new TextComponent("Shielded").m_130940_(ChatFormatting.AQUA));
        }
        if (this.remainingRevives > 0) {
            txt.m_7220_((Component)new TextComponent(" \u2022 ").m_130940_(ChatFormatting.DARK_GRAY));
            txt.m_7220_((Component)new TextComponent("Revives: " + this.remainingRevives).m_130940_(ChatFormatting.WHITE));
        }
        int midX = window.m_85445_() / 2;
        matrixStack.m_85836_();
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int previousTexture = RenderSystem.m_157203_((int)0);
        RenderSystem.m_157456_((int)0, (ResourceLocation)RaidChallengeManager.HUD);
        int fillWidth = 15 + (int)(130.0f * barProgress);
        matrixStack.m_85837_((double)(midX - 80), 8.0, 0.0);
        GuiComponent.m_93133_((PoseStack)matrixStack, (int)0, (int)0, (float)0.0f, (float)0.0f, (int)200, (int)26, (int)200, (int)50);
        if (fillWidth > 0) {
            GuiComponent.m_93133_((PoseStack)matrixStack, (int)0, (int)8, (float)0.0f, (float)28.0f, (int)fillWidth, (int)10, (int)200, (int)50);
            if (countdownActive) {
                GuiComponent.m_93172_((PoseStack)matrixStack, (int)15, (int)8, (int)fillWidth, (int)18, (int)-1056984249);
            } else if (this.shieldActive) {
                GuiComponent.m_93172_((PoseStack)matrixStack, (int)15, (int)8, (int)fillWidth, (int)18, (int)-1063659265);
            }
        }
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157453_((int)0, (int)previousTexture);
        matrixStack.m_85849_();
        Font font = Minecraft.m_91087_().f_91062_;
        MultiBufferSource.BufferSource buffer = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
        matrixStack.m_85836_();
        matrixStack.m_85841_(0.6f, 0.6f, 0.6f);
        float textWidth = font.m_92852_((FormattedText)txt);
        FormattedCharSequence formattedCharSequence = txt.m_7532_();
        float f = (float)midX / 0.6f - textWidth / 2.0f;
        Objects.requireNonNull(font);
        font.m_92733_(formattedCharSequence, f, (float)(9 + 22), -1, true, matrixStack.m_85850_().m_85861_(), (MultiBufferSource)buffer, false, 0, LightmapHelper.getPackedFullbrightCoords());
        buffer.m_109911_();
        matrixStack.m_85849_();
    }

    public void writeBits(BitBuffer buffer, SyncContext context) {
        Adapters.BLOCK_POS.writeBits(this.origin, buffer);
        Adapters.BLOCK_CUBOID.writeBits(this.zone, buffer);
        Adapters.INT_SEGMENTED_7.writeBits(this.zoneId, buffer);
        Adapters.ofEnum(RoomStyle.class, EnumAdapter.Mode.NAME).writeBits(this.roomStyle, buffer);
        Adapters.INT_SEGMENTED_3.writeBits(this.players.size(), buffer);
        for (UUID player : this.players) {
            Adapters.UUID.writeBits(player, buffer);
        }
        Adapters.PARTIAL_ENTITY.writeBits(this.boss, buffer);
        Adapters.DOUBLE.writeBits(this.currentHealth, buffer);
        Adapters.DOUBLE.writeBits(this.totalHealth, buffer);
        this.animation.writeBits(buffer, context);
        Adapters.BOOLEAN.writeBits(this.completed, buffer);
        Adapters.BOOLEAN.writeBits(this.shieldActive, buffer);
        Adapters.INT_SEGMENTED_3.writeBits(this.remainingRevives, buffer);
        Adapters.DOUBLE.writeBits(this.modifiers.getHealthPercent(), buffer);
        Adapters.DOUBLE.writeBits(this.modifiers.getDamagePercent(), buffer);
        Adapters.INT_SEGMENTED_3.writeBits(this.modifiers.getAbilityHaste(), buffer);
        Adapters.INT_SEGMENTED_3.writeBits(this.loot.size(), buffer);
        for (ItemStack stack : this.loot) {
            Adapters.ITEM_STACK.writeBits(stack, buffer);
        }
        Adapters.BOOLEAN.writeBits(this.waveBlastWarningActive, buffer);
        Adapters.INT_SEGMENTED_3.writeBits(this.waveBlastWarningTicks, buffer);
        Adapters.INT_SEGMENTED_3.writeBits(this.waveBlastWarningWindow, buffer);
        Adapters.INT_SEGMENTED_3.writeBits(this.waveBlastCooldownDuration, buffer);
    }

    public void readBits(BitBuffer buffer, SyncContext context) {
        this.origin = Adapters.BLOCK_POS.readBits(buffer).orElseThrow();
        this.zone = Adapters.BLOCK_CUBOID.readBits(buffer).orElse(null);
        this.zoneId = (Integer)Adapters.INT_SEGMENTED_7.readBits(buffer).orElseThrow();
        this.roomStyle = Adapters.ofEnum(RoomStyle.class, EnumAdapter.Mode.NAME).readBits(buffer).orElseThrow();
        int size = (Integer)Adapters.INT_SEGMENTED_3.readBits(buffer).orElseThrow();
        this.players.clear();
        for (int i = 0; i < size; ++i) {
            Adapters.UUID.readBits(buffer).ifPresent(this.players::add);
        }
        this.boss = Adapters.PARTIAL_ENTITY.readBits(buffer).orElse(null);
        this.currentHealth = (Double)Adapters.DOUBLE.readBits(buffer).orElseThrow();
        this.totalHealth = (Double)Adapters.DOUBLE.readBits(buffer).orElseThrow();
        this.animation.readBits(buffer, context);
        this.completed = Adapters.BOOLEAN.readBits(buffer).orElseThrow();
        this.shieldActive = Adapters.BOOLEAN.readBits(buffer).orElse(false);
        this.remainingRevives = Adapters.INT_SEGMENTED_3.readBits(buffer).orElse(0);
        double healthPercent = Adapters.DOUBLE.readBits(buffer).orElse(0.0);
        double damagePercent = Adapters.DOUBLE.readBits(buffer).orElse(0.0);
        int abilityHaste = Adapters.INT_SEGMENTED_3.readBits(buffer).orElse(0);
        this.modifiers = new BossRuneModifiers(healthPercent, damagePercent, abilityHaste);
        size = (Integer)Adapters.INT_SEGMENTED_3.readBits(buffer).orElseThrow();
        this.loot.clear();
        for (int i = 0; i < size; ++i) {
            Adapters.ITEM_STACK.readBits(buffer).ifPresent(this.loot::add);
        }
        this.waveBlastWarningActive = Adapters.BOOLEAN.readBits(buffer).orElse(false);
        this.waveBlastWarningTicks = Adapters.INT_SEGMENTED_3.readBits(buffer).orElse(0);
        this.waveBlastWarningWindow = Adapters.INT_SEGMENTED_3.readBits(buffer).orElse(0);
        this.waveBlastCooldownDuration = Adapters.INT_SEGMENTED_3.readBits(buffer).orElse(0);
    }

    public static enum RoomStyle {
        BOSS_1(frame -> VaultMod.id("vault/animations/boss1/gate" + frame)),
        BOSS_2(frame -> VaultMod.id("vault/animations/boss1/gate" + frame));

        private final IntFunction<ResourceLocation> gate;

        private RoomStyle(IntFunction<ResourceLocation> gate) {
            this.gate = gate;
        }

        public ResourceLocation getGateFrame(int frame) {
            return VaultMod.id("vault/animations/boss1/gate" + frame);
        }
    }
}

