/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.core.vault.objective.rune;

import iskallia.vault.VaultMod;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.data.sync.context.SyncContext;
import iskallia.vault.core.net.BitBuffer;
import iskallia.vault.core.vault.Vault;
import iskallia.vault.core.vault.objective.rune.RuneBossFight;
import iskallia.vault.core.vault.time.TickClock;
import iskallia.vault.core.world.storage.VirtualWorld;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;

public class RuneBossFights {
    private static final int MIN_RESUME_TIME = 300;
    private final List<RuneBossFight> fights = new ArrayList<RuneBossFight>();
    private final List<RuneBossFight> scheduledFights = new ArrayList<RuneBossFight>();

    public boolean hasPendingFight() {
        return !this.scheduledFights.isEmpty() || this.fights.stream().anyMatch(f -> !f.isCompleted());
    }

    public boolean hasPendingFight(UUID player) {
        return this.scheduledFights.stream().anyMatch(fight -> fight.getPlayers().contains(player)) || this.fights.stream().anyMatch(fight -> !fight.isCompleted() && fight.getPlayers().contains(player));
    }

    public void add(RuneBossFight fight) {
        this.scheduledFights.add(fight);
    }

    public boolean hasFightAt(BlockPos origin) {
        if (origin == null) {
            return false;
        }
        return this.scheduledFights.stream().anyMatch(fight -> origin.equals((Object)fight.getOrigin())) || this.fights.stream().anyMatch(fight -> origin.equals((Object)fight.getOrigin()) && !fight.isCompleted());
    }

    public Optional<RuneBossFight> getFight(UUID player) {
        for (RuneBossFight fight : this.fights) {
            if (!fight.getPlayers().contains(player)) continue;
            return Optional.of(fight);
        }
        return Optional.empty();
    }

    public void onAttach(VirtualWorld world, Vault vault) {
        for (RuneBossFight fight : this.fights) {
            if (fight.isCompleted()) continue;
            fight.onAttach(world, vault);
        }
    }

    public void onTick(VirtualWorld world, Vault vault) {
        boolean hasHadFight;
        for (RuneBossFight fight2 : this.scheduledFights) {
            fight2.onAttach(world, vault);
            this.fights.add(fight2);
        }
        this.scheduledFights.clear();
        boolean hasActiveFights = this.fights.stream().anyMatch(fight -> !fight.isCompleted());
        boolean bl = hasHadFight = !this.fights.isEmpty();
        if (hasActiveFights) {
            if (!vault.get(Vault.CLOCK).has(TickClock.PAUSED)) {
                vault.get(Vault.CLOCK).set(TickClock.PAUSED);
            }
            if (vault.get(Vault.CLOCK).has(TickClock.VISIBLE)) {
                vault.get(Vault.CLOCK).remove(TickClock.VISIBLE);
            }
        } else if (hasHadFight) {
            TickClock clock = vault.get(Vault.CLOCK);
            if (clock.get(TickClock.DISPLAY_TIME) < 300) {
                clock.set(TickClock.DISPLAY_TIME, 400);
                VaultMod.LOGGER.debug("Extending vault timer to {} ticks because time was low", (Object)400);
            }
            if (clock.has(TickClock.PAUSED)) {
                clock.remove(TickClock.PAUSED);
            }
            if (!clock.has(TickClock.VISIBLE)) {
                clock.set(TickClock.VISIBLE);
            }
        }
        for (RuneBossFight fight3 : this.fights) {
            if (!fight3.isCompleted()) continue;
            fight3.onDetach();
        }
    }

    public void onDetach() {
        for (RuneBossFight fight : this.fights) {
            fight.onDetach();
        }
    }

    public void writeBits(BitBuffer buffer, SyncContext context) {
        Adapters.INT_SEGMENTED_3.writeBits(this.fights.size(), buffer);
        for (RuneBossFight fight : this.fights) {
            fight.writeBits(buffer, context);
        }
        Adapters.INT_SEGMENTED_3.writeBits(this.scheduledFights.size(), buffer);
        for (RuneBossFight fight : this.scheduledFights) {
            fight.writeBits(buffer, context);
        }
    }

    public void readBits(BitBuffer buffer, SyncContext context) {
        RuneBossFight fight;
        int i;
        int size = (Integer)Adapters.INT_SEGMENTED_3.readBits(buffer).orElseThrow();
        this.fights.clear();
        for (i = 0; i < size; ++i) {
            fight = new RuneBossFight();
            fight.readBits(buffer, context);
            this.fights.add(fight);
        }
        size = (Integer)Adapters.INT_SEGMENTED_3.readBits(buffer).orElseThrow();
        this.scheduledFights.clear();
        for (i = 0; i < size; ++i) {
            fight = new RuneBossFight();
            fight.readBits(buffer, context);
            this.scheduledFights.add(fight);
        }
    }

    public int getCompletedFightsSize() {
        return this.fights.stream().filter(RuneBossFight::isCompleted).collect(Collectors.toSet()).size();
    }

    public List<RuneBossFight> getFights() {
        return this.fights;
    }
}

