/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.core.vault.objective.scavenger;

import iskallia.vault.core.event.CommonEvents;
import iskallia.vault.core.random.RandomSource;
import iskallia.vault.core.vault.Vault;
import iskallia.vault.core.vault.objective.Objective;
import iskallia.vault.core.vault.objective.scavenger.ScavengeTask;
import iskallia.vault.core.vault.objective.scavenger.ScavengerGoal;
import iskallia.vault.core.world.data.entity.EntityPredicate;
import iskallia.vault.core.world.storage.VirtualWorld;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class MobScavengerTask
extends ScavengeTask {
    public final double probability;
    public final ResourceLocation icon;
    public final int color;
    public final List<Entry> entries;

    public MobScavengerTask(double probability, ResourceLocation icon, int color, Entry ... entries) {
        this.probability = probability;
        this.icon = icon;
        this.color = color;
        this.entries = Arrays.asList(entries);
    }

    @Override
    public Optional<ScavengerGoal> generateGoal(int count, RandomSource random) {
        Entry entry = this.entries.get(random.nextInt(this.entries.size()));
        ResourceLocation icon = entry.icon != null ? entry.icon : this.icon;
        return Optional.of(new ScavengerGoal((int)Math.ceil((double)count * entry.multiplier)).put(entry.item, icon, this.color));
    }

    @Override
    public void initServer(VirtualWorld world, Vault vault, Objective objective) {
        CommonEvents.ENTITY_DROPS.register(objective, event -> {
            LivingEntity entity = event.getEntityLiving();
            if (entity.f_19853_ != world) {
                return;
            }
            if (world.m_5822_().nextDouble() >= this.probability) {
                return;
            }
            List<Entry> matchingEntries = this.entries.stream().filter(entry -> entry.group.stream().anyMatch(entityPredicate -> entityPredicate.test((Entity)entity))).toList();
            if (matchingEntries.isEmpty()) {
                return;
            }
            Entry entry2 = matchingEntries.get(world.m_5822_().nextInt(matchingEntries.size()));
            ItemStack stack = this.createStack(vault, entry2.item);
            ArrayList<ItemStack> items = new ArrayList<ItemStack>();
            items.add(stack);
            CommonEvents.ITEM_SCAVENGE_TASK.invoke(vault, (Level)world, entity.m_142538_(), items);
            for (ItemStack item : items) {
                ItemEntity itemEntity = new ItemEntity((Level)world, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), item);
                event.getDrops().add(itemEntity);
            }
        });
    }

    public static class Entry {
        public final ItemStack item;
        public final double multiplier;
        public final List<EntityPredicate> group;
        @Nullable
        public final ResourceLocation icon;

        public Entry(ItemStack item, double multiplier, EntityPredicate ... entityPredicate) {
            this(item, multiplier, List.of(entityPredicate), null);
        }

        public Entry(ItemStack item, double multiplier, List<EntityPredicate> entityPredicate) {
            this(item, multiplier, entityPredicate, null);
        }

        public Entry(ItemStack item, double multiplier, List<EntityPredicate> entityPredicate, @Nullable ResourceLocation icon) {
            this.item = item;
            this.multiplier = multiplier;
            this.group = entityPredicate;
            this.icon = icon;
        }

        public Entry(ItemStack item, double multiplier, @Nullable ResourceLocation icon, EntityPredicate ... entityPredicate) {
            this(item, multiplier, List.of(entityPredicate), icon);
        }
    }
}

