/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.core.vault.objective.scavenger;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import iskallia.vault.VaultMod;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.random.RandomSource;
import iskallia.vault.core.util.WeightedList;
import iskallia.vault.core.vault.Vault;
import iskallia.vault.core.vault.objective.Objective;
import iskallia.vault.core.vault.objective.scavenger.ChestScavengerTask;
import iskallia.vault.core.vault.objective.scavenger.CoinStacksScavengerTask;
import iskallia.vault.core.vault.objective.scavenger.CompoundScavengerTask;
import iskallia.vault.core.vault.objective.scavenger.MobScavengerTask;
import iskallia.vault.core.vault.objective.scavenger.OreScavengerTask;
import iskallia.vault.core.vault.objective.scavenger.ScavengerGoal;
import iskallia.vault.core.world.data.entity.EntityPredicate;
import iskallia.vault.core.world.data.item.PartialStack;
import iskallia.vault.core.world.data.tile.TilePredicate;
import iskallia.vault.core.world.storage.VirtualWorld;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

public abstract class ScavengeTask {
    public abstract Optional<ScavengerGoal> generateGoal(int var1, RandomSource var2);

    public abstract void initServer(VirtualWorld var1, Vault var2, Objective var3);

    public ItemStack createStack(Vault vault, ItemStack stack) {
        stack = stack.m_41777_();
        stack.m_41784_().m_128359_("VaultId", vault.get(Vault.ID).toString());
        return stack;
    }

    public static class Adapter
    implements JsonSerializer<ScavengeTask>,
    JsonDeserializer<ScavengeTask> {
        public static final Adapter INSTANCE = new Adapter();

        public ScavengeTask deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject object = json.getAsJsonObject();
            switch (object.get("type").getAsString()) {
                case "chest": {
                    WeightedList<ChestScavengerTask.Entry> entries = new WeightedList<ChestScavengerTask.Entry>();
                    JsonObject obj = object.get("entries").getAsJsonObject();
                    for (String key : obj.keySet()) {
                        PartialStack.parse(key, true).flatMap(partialStack -> partialStack.generate(1)).ifPresentOrElse(itemStack -> {
                            JsonObject value = obj.get(key).getAsJsonObject();
                            entries.put(new ChestScavengerTask.Entry((ItemStack)itemStack, value.get("multiplier").getAsDouble(), value.get("color").getAsInt()), value.get("weight").getAsInt());
                        }, () -> VaultMod.LOGGER.error("Invalid item: " + key));
                    }
                    return new ChestScavengerTask(Adapters.TILE_PREDICATE.readJson(object.get("target")).orElse(TilePredicate.FALSE), object.get("probability").getAsDouble(), new ResourceLocation(object.get("icon").getAsString()), entries);
                }
                case "coin_stacks": {
                    WeightedList<CoinStacksScavengerTask.Entry> entries = new WeightedList<CoinStacksScavengerTask.Entry>();
                    JsonObject obj = object.get("entries").getAsJsonObject();
                    for (String key : obj.keySet()) {
                        JsonObject value = obj.get(key).getAsJsonObject();
                        PartialStack.parse(key, true).flatMap(partialStack -> partialStack.generate(1)).ifPresentOrElse(itemStack -> entries.put(new CoinStacksScavengerTask.Entry((ItemStack)itemStack, value.get("multiplier").getAsDouble(), value.get("color").getAsInt()), value.get("weight").getAsInt()), () -> VaultMod.LOGGER.error("Invalid item: " + key));
                    }
                    return new CoinStacksScavengerTask(object.get("probability").getAsDouble(), new ResourceLocation(object.get("icon").getAsString()), entries);
                }
                case "ore": {
                    WeightedList<OreScavengerTask.Entry> entries = new WeightedList<OreScavengerTask.Entry>();
                    JsonObject obj = object.get("entries").getAsJsonObject();
                    for (String key : obj.keySet()) {
                        JsonObject value = obj.get(key).getAsJsonObject();
                        PartialStack.parse(key, true).flatMap(partialStack -> partialStack.generate(1)).ifPresentOrElse(itemStack -> entries.put(new OreScavengerTask.Entry((ItemStack)itemStack, value.get("multiplier").getAsDouble(), value.get("color").getAsInt()), value.get("weight").getAsInt()), () -> VaultMod.LOGGER.error("Invalid item: " + key));
                    }
                    return new OreScavengerTask(object.get("probability").getAsDouble(), new ResourceLocation(object.get("icon").getAsString()), entries);
                }
                case "mob": {
                    ArrayList entries = new ArrayList();
                    JsonObject obj = object.get("entries").getAsJsonObject();
                    for (String key : obj.keySet()) {
                        JsonObject entry = obj.get(key).getAsJsonObject();
                        JsonArray list = entry.get("mobs").getAsJsonArray();
                        ArrayList group = new ArrayList();
                        for (JsonElement element : list) {
                            EntityPredicate.of(element.getAsString(), true).ifPresentOrElse(group::add, () -> VaultMod.LOGGER.error("Invalid mob: " + element.getAsString()));
                        }
                        PartialStack.parse(key, true).flatMap(partialStack -> partialStack.generate(1)).ifPresentOrElse(itemStack -> {
                            ResourceLocation override = entry.has("icon") ? new ResourceLocation(entry.get("icon").getAsString()) : null;
                            entries.add(new MobScavengerTask.Entry((ItemStack)itemStack, entry.get("multiplier").getAsDouble(), group, override));
                        }, () -> VaultMod.LOGGER.error("Invalid item: " + key));
                    }
                    return new MobScavengerTask(object.get("probability").getAsDouble(), new ResourceLocation(object.get("icon").getAsString()), object.get("color").getAsInt(), (MobScavengerTask.Entry[])entries.toArray(MobScavengerTask.Entry[]::new));
                }
                case "compound": {
                    ArrayList<ScavengeTask> children = new ArrayList<ScavengeTask>();
                    for (JsonElement element : object.get("children").getAsJsonArray()) {
                        children.add((ScavengeTask)context.deserialize(element, ScavengeTask.class));
                    }
                    return new CompoundScavengerTask(children);
                }
            }
            return null;
        }

        public JsonElement serialize(ScavengeTask value, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject object = new JsonObject();
            if (value instanceof ChestScavengerTask) {
                ChestScavengerTask chest = (ChestScavengerTask)value;
                object.addProperty("type", "chest");
                Adapters.TILE_PREDICATE.writeJson(chest.target).ifPresent(element -> object.add("target", element));
                object.addProperty("probability", (Number)chest.probability);
                object.addProperty("icon", chest.icon.toString());
                JsonObject entries = new JsonObject();
                chest.entries.forEach((entry, weight) -> {
                    JsonObject obj = new JsonObject();
                    obj.addProperty("weight", (Number)weight);
                    obj.addProperty("multiplier", (Number)entry.multiplier);
                    obj.addProperty("color", (Number)entry.color);
                    entries.add(PartialStack.of(entry.item).toString(), (JsonElement)obj);
                });
                object.add("entries", (JsonElement)entries);
            } else if (value instanceof CoinStacksScavengerTask) {
                CoinStacksScavengerTask coin = (CoinStacksScavengerTask)value;
                object.addProperty("type", "coin_stacks");
                object.addProperty("probability", (Number)coin.probability);
                object.addProperty("icon", coin.icon.toString());
                JsonObject entries = new JsonObject();
                coin.entries.forEach((entry, weight) -> {
                    JsonObject obj = new JsonObject();
                    obj.addProperty("weight", (Number)weight);
                    obj.addProperty("multiplier", (Number)entry.multiplier);
                    obj.addProperty("color", (Number)entry.color);
                    entries.add(PartialStack.of(entry.item).toString(), (JsonElement)obj);
                });
                object.add("entries", (JsonElement)entries);
            } else if (value instanceof OreScavengerTask) {
                OreScavengerTask ore = (OreScavengerTask)value;
                object.addProperty("type", "ore");
                object.addProperty("probability", (Number)ore.probability);
                object.addProperty("icon", ore.icon.toString());
                JsonObject entries = new JsonObject();
                ore.entries.forEach((entry, weight) -> {
                    JsonObject obj = new JsonObject();
                    obj.addProperty("weight", (Number)weight);
                    obj.addProperty("multiplier", (Number)entry.multiplier);
                    obj.addProperty("color", (Number)entry.color);
                    entries.add(PartialStack.of(entry.item).toString(), (JsonElement)obj);
                });
                object.add("entries", (JsonElement)entries);
            } else if (value instanceof MobScavengerTask) {
                MobScavengerTask mob = (MobScavengerTask)value;
                object.addProperty("type", "mob");
                object.addProperty("probability", (Number)mob.probability);
                object.addProperty("icon", mob.icon.toString());
                object.addProperty("color", (Number)mob.color);
                JsonObject entries = new JsonObject();
                for (MobScavengerTask.Entry entry2 : mob.entries) {
                    JsonObject obj = new JsonObject();
                    obj.addProperty("multiplier", (Number)entry2.multiplier);
                    JsonArray group = new JsonArray();
                    entry2.group.forEach(id -> group.add(id.toString()));
                    obj.add("mobs", (JsonElement)group);
                    if (entry2.icon != null) {
                        obj.addProperty("icon", entry2.icon.toString());
                    }
                    entries.add(PartialStack.of(entry2.item).toString(), (JsonElement)obj);
                }
                object.add("entries", (JsonElement)entries);
            } else if (value instanceof CompoundScavengerTask) {
                CompoundScavengerTask compound = (CompoundScavengerTask)value;
                object.addProperty("type", "compound");
                JsonArray children = new JsonArray();
                for (ScavengeTask child : compound.children) {
                    children.add(context.serialize((Object)child));
                }
                object.add("children", (JsonElement)children);
            }
            return object;
        }
    }
}

