/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.core.vault.objective.scavenger;

import com.google.common.collect.Iterators;
import iskallia.vault.core.Version;
import iskallia.vault.core.data.DataList;
import iskallia.vault.core.data.DataObject;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.data.adapter.vault.CompoundAdapter;
import iskallia.vault.core.data.key.FieldKey;
import iskallia.vault.core.data.key.registry.FieldRegistry;
import iskallia.vault.core.data.serializable.IBitSerializable;
import iskallia.vault.core.event.CommonEvents;
import iskallia.vault.core.net.BitBuffer;
import iskallia.vault.core.vault.Vault;
import iskallia.vault.core.vault.objective.Objective;
import iskallia.vault.core.world.data.item.PartialStack;
import iskallia.vault.core.world.storage.VirtualWorld;
import java.util.ArrayList;
import java.util.Iterator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class ScavengerGoal
extends DataObject<ScavengerGoal> {
    public static final FieldRegistry FIELDS = Objective.FIELDS.merge(new FieldRegistry());
    private static final FieldKey<Item> ITEM = (FieldKey)FieldKey.of("item", Item.class).with(Version.v1_0, Adapters.ITEM, DISK.all().or(CLIENT.all())).register(FIELDS);
    public static final FieldKey<Integer> TOTAL = (FieldKey)FieldKey.of("total", Integer.class).with(Version.v1_0, Adapters.INT_SEGMENTED_3, DISK.all().or(CLIENT.all())).register(FIELDS);
    public static final FieldKey<Integer> BASE_TOTAL = (FieldKey)FieldKey.of("base_total", Integer.class).with(Version.v1_25, Adapters.INT_SEGMENTED_3, DISK.all().or(CLIENT.all())).register(FIELDS);
    public static final FieldKey<Integer> CURRENT = (FieldKey)FieldKey.of("current", Integer.class).with(Version.v1_0, Adapters.INT_SEGMENTED_3, DISK.all().or(CLIENT.all())).register(FIELDS);
    private static final FieldKey<ResourceLocation> ICON = (FieldKey)FieldKey.of("secondary_icon", ResourceLocation.class).with(Version.v1_0, Adapters.IDENTIFIER, DISK.all().or(CLIENT.all())).with(Version.v1_19, Adapters.IDENTIFIER.asNullable(), DISK.all().or(CLIENT.all())).register(FIELDS);
    private static final FieldKey<Integer> COLOR = (FieldKey)FieldKey.of("color", Integer.class).with(Version.v1_0, Adapters.INT, DISK.all().or(CLIENT.all())).register(FIELDS);
    public static final FieldKey<Entry.ObjList> ENTRIES = (FieldKey)FieldKey.of("entries", Entry.ObjList.class).with(Version.v1_19, CompoundAdapter.of(() -> new Entry.ObjList(Version.v1_19)), DISK.all().or(CLIENT.all())).with(Version.v1_20, CompoundAdapter.of(() -> new Entry.ObjList(Version.v1_20)), DISK.all().or(CLIENT.all())).register(FIELDS);

    protected ScavengerGoal() {
        this.set(ENTRIES, new Entry.ObjList(Version.v1_20));
    }

    public ScavengerGoal(int count) {
        this.set(TOTAL, count);
        this.set(BASE_TOTAL, count);
        this.set(CURRENT, 0);
        this.set(ENTRIES, new Entry.ObjList(Version.v1_20));
    }

    public Iterator<Entry> getEntries() {
        Iterator iterator = null;
        if (this.has(ITEM)) {
            iterator = Iterators.singletonIterator((Object)new Entry(this.get(ScavengerGoal.ENTRIES).version, new ItemStack((ItemLike)this.get(ITEM)), this.get(ICON), this.get(COLOR)));
        }
        if (this.has(ENTRIES) && !this.get(ENTRIES).isEmpty()) {
            iterator = iterator == null ? this.get(ENTRIES).iterator() : Iterators.concat(iterator, this.get(ENTRIES).iterator());
        }
        return iterator;
    }

    public ScavengerGoal put(ItemStack item, ResourceLocation icon, int color) {
        return this.put(new Entry(this.get(ScavengerGoal.ENTRIES).version, item, icon, color));
    }

    public ScavengerGoal put(Entry entry) {
        this.get(ENTRIES).add(entry);
        return this;
    }

    @Override
    public FieldRegistry getFields() {
        return FIELDS;
    }

    public boolean isCompleted() {
        return this.get(CURRENT) >= this.get(TOTAL);
    }

    public void tick(VirtualWorld world, Vault vault) {
        this.ifPresent(BASE_TOTAL, baseTotal -> {
            double increase = CommonEvents.OBJECTIVE_TARGET.invoke(world, vault, 0.0).getIncrease();
            this.set(TOTAL, (int)Math.round((double)baseTotal.intValue() * (1.0 + increase)));
        });
    }

    public boolean consume(ItemStack stack) {
        if (stack.m_41619_()) {
            return false;
        }
        if (this.get(CURRENT) >= this.get(TOTAL)) {
            return false;
        }
        this.getEntries().forEachRemaining(entry -> {
            if (PartialStack.of(entry.getStack()).isSubsetOf(stack)) {
                int amount = Math.min(this.get(TOTAL) - this.get(CURRENT), stack.m_41613_());
                stack.m_41774_(amount);
                this.modify(CURRENT, value -> value + amount);
            }
        });
        return true;
    }

    public ScavengerGoal merge(ScavengerGoal other) {
        ScavengerGoal copy = this.copy();
        copy.set(CURRENT, this.getOr(CURRENT, 0) + other.getOr(CURRENT, 0));
        copy.set(TOTAL, this.getOr(TOTAL, 0) + other.getOr(TOTAL, 0));
        copy.set(BASE_TOTAL, this.getOr(BASE_TOTAL, 0) + other.getOr(BASE_TOTAL, 0));
        other.getEntries().forEachRemaining(copy::put);
        return copy;
    }

    public ScavengerGoal copy() {
        ScavengerGoal copy = new ScavengerGoal();
        copy.set(CURRENT, this.get(CURRENT));
        copy.set(TOTAL, this.get(TOTAL));
        copy.set(BASE_TOTAL, this.get(BASE_TOTAL));
        this.getEntries().forEachRemaining(copy::put);
        return copy;
    }

    public static class Entry
    implements IBitSerializable {
        private Version version;
        private ItemStack item;
        private ResourceLocation icon;
        private int color;

        private Entry(Version version) {
            this.version = version;
        }

        public Entry(Version version, ItemStack item, ResourceLocation icon, int color) {
            this.version = version;
            this.item = item;
            this.icon = icon;
            this.color = color;
        }

        public ItemStack getStack() {
            return this.item;
        }

        public ItemStack getStack(int count) {
            ItemStack stack = this.item.m_41777_();
            stack.m_41764_(count);
            return stack;
        }

        public ResourceLocation getIcon() {
            return this.icon;
        }

        public int getColor() {
            return this.color;
        }

        @Override
        public void writeBits(BitBuffer buffer) {
            if (this.version.isOlderThan(Version.v1_20)) {
                Adapters.ITEM.writeBits(this.item.m_41720_(), buffer);
            } else {
                Adapters.ITEM_STACK.writeBits(this.item, buffer);
            }
            Adapters.IDENTIFIER.writeBits(this.icon, buffer);
            Adapters.INT.writeBits(this.color, buffer);
        }

        @Override
        public void readBits(BitBuffer buffer) {
            this.item = this.version.isOlderThan(Version.v1_20) ? new ItemStack((ItemLike)Adapters.ITEM.readBits(buffer).orElseThrow()) : Adapters.ITEM_STACK.readBits(buffer).orElseThrow();
            this.icon = Adapters.IDENTIFIER.readBits(buffer).orElseThrow();
            this.color = (Integer)Adapters.INT.readBits(buffer).orElseThrow();
        }

        public static class ObjList
        extends DataList<ObjList, Entry> {
            private final Version version;

            public ObjList(Version version) {
                super(new ArrayList(), Adapters.of(() -> new Entry(version), false));
                this.version = version;
            }
        }
    }

    public static class ObjList
    extends DataList<ObjList, ScavengerGoal> {
        public ObjList() {
            super(new ArrayList(), CompoundAdapter.of(ScavengerGoal::new));
        }

        public boolean areAllCompleted() {
            return this.stream().allMatch(ScavengerGoal::isCompleted);
        }
    }
}

