/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.core.vault.overlay;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.vertex.PoseStack;
import iskallia.vault.VaultMod;
import iskallia.vault.client.render.HudPosition;
import iskallia.vault.client.render.IVaultOptions;
import iskallia.vault.core.Version;
import iskallia.vault.core.data.DataObject;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.data.key.FieldKey;
import iskallia.vault.core.data.key.registry.FieldRegistry;
import iskallia.vault.core.event.ClientEvents;
import iskallia.vault.core.vault.Modifiers;
import iskallia.vault.core.vault.Vault;
import iskallia.vault.core.vault.VaultUtils;
import iskallia.vault.core.vault.WorldManager;
import iskallia.vault.core.vault.influence.Favours;
import iskallia.vault.core.vault.influence.Influences;
import iskallia.vault.core.vault.overlay.ModifiersRenderer;
import iskallia.vault.core.vault.player.Listener;
import iskallia.vault.core.vault.player.Runner;
import iskallia.vault.world.data.ChallengeData;
import it.unimi.dsi.fastutil.objects.Object2IntLinkedOpenHashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderGameOverlayEvent;

public class VaultOverlay
extends DataObject<VaultOverlay> {
    public static final ResourceLocation VAULT_HUD = VaultMod.id("textures/gui/vault_hud.png");
    public static final ResourceLocation ARCHITECT_HUD = VaultMod.id("textures/gui/architect_event_bar.png");
    public static final ResourceLocation VIGNETTE = VaultMod.id("textures/gui/vignette.png");
    public static final FieldRegistry FIELDS = new FieldRegistry();
    public static final FieldKey<Void> HIDDEN = (FieldKey)FieldKey.of("hidden", Void.class).with(Version.v1_0, Adapters.ofVoid(), DISK.all().or(CLIENT.all())).register(FIELDS);

    @Override
    public FieldRegistry getFields() {
        return FIELDS;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void initClient(Vault vault) {
        ClientEvents.RENDER_OVERLAY.forType(RenderGameOverlayEvent.ElementType.ALL).register(vault, data -> {
            if (this.has(HIDDEN)) {
                return;
            }
            ClientLevel world = Minecraft.m_91087_().f_91073_;
            if (!VaultUtils.isVaultLevel((Level)world)) {
                return;
            }
            if (!world.m_46472_().m_135782_().equals((Object)vault.get(Vault.WORLD).get(WorldManager.KEY))) {
                return;
            }
            this.render(vault, data.getMatrixStack(), data.getWindow(), data.getPartialTicks());
        });
    }

    public void releaseClient(Vault vault) {
        ClientEvents.RENDER_OVERLAY.forType(RenderGameOverlayEvent.ElementType.ALL).release(vault);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void render(Vault vault, PoseStack matrixStack, Window window, float partialTicks) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        Listener listener = vault.getOptional(Vault.LISTENERS).map(listeners -> listeners.get(player.m_142081_())).orElse(null);
        if (listener != null && ChallengeData.shouldRenderObjectives()) {
            matrixStack.m_85836_();
            Minecraft mc = Minecraft.m_91087_();
            if (mc.f_91065_.m_93088_().f_94524_) {
                matrixStack.m_85837_(0.0, (double)(mc.f_91074_.f_108617_.m_105142_().size() * 9 + 10), 0.0);
            }
            listener.renderObjectives(vault, matrixStack, window, partialTicks, (Player)player);
            matrixStack.m_85849_();
        }
        vault.ifPresent(Vault.CLOCK, clock -> {
            IVaultOptions opts = (IVaultOptions)Minecraft.m_91087_().f_91066_;
            HudPosition pos = opts.getHudPositions().getOrDefault("timer", VaultOverlay.defTimerPos(window));
            matrixStack.m_85836_();
            matrixStack.m_85837_((double)pos.getScaledX(window.m_85445_()), (double)pos.getScaledY(window.m_85446_()), 0.0);
            clock.render(matrixStack);
            matrixStack.m_85849_();
        });
        Object2IntLinkedOpenHashMap renderModifiers = new Object2IntLinkedOpenHashMap();
        if (listener != null) {
            listener.getOptional(Runner.INFLUENCES).map(influences -> influences.get(Influences.FAVOURS)).ifPresent(arg_0 -> VaultOverlay.lambda$render$4((Map)renderModifiers, arg_0));
        }
        vault.ifPresent(Vault.MODIFIERS, arg_0 -> VaultOverlay.lambda$render$5((Map)renderModifiers, arg_0));
        ModifiersRenderer.renderVaultModifiers(renderModifiers, matrixStack, false, true);
    }

    private static HudPosition defTimerPos(Window window) {
        return HudPosition.fromPixels(92, window.m_85446_() - 25, window.m_85445_(), window.m_85446_());
    }

    private static /* synthetic */ void lambda$render$5(Map renderModifiers, Modifiers modifiers) {
        renderModifiers.putAll(modifiers.getDisplayGroup());
    }

    private static /* synthetic */ void lambda$render$4(Map renderModifiers, Favours favours) {
        renderModifiers.putAll(favours.getDisplayGroup());
    }
}

