/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.core.vault.pandora;

import com.google.gson.JsonObject;
import iskallia.vault.core.vault.pandora.PandoraEffect;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class AnvilRainEffect
extends PandoraEffect<Config> {
    public AnvilRainEffect(Config config) {
        super(config);
    }

    @Override
    public void execute(Level level, BlockPos pos, Player player) {
        if (level.f_46443_) {
            return;
        }
        Random random = level.m_5822_();
        for (int i = 0; i < ((Config)this.config).anvilCount; ++i) {
            double offsetX = (random.nextDouble() - 0.5) * (double)((Config)this.config).radius * 2.0;
            double offsetZ = (random.nextDouble() - 0.5) * (double)((Config)this.config).radius * 2.0;
            BlockPos anvilPos = player.m_142538_().m_142082_((int)offsetX, ((Config)this.config).height, (int)offsetZ);
            FallingBlockEntity anvil = FallingBlockEntity.m_201971_((Level)level, (BlockPos)anvilPos, (BlockState)Blocks.f_50322_.m_49966_());
            level.m_7967_((Entity)anvil);
        }
    }

    public static class Config
    extends PandoraEffect.Config<AnvilRainEffect> {
        private int anvilCount;
        private int radius;
        private int height;

        @Override
        public AnvilRainEffect build() {
            return new AnvilRainEffect(this);
        }

        @Override
        protected void write(JsonObject object) {
            object.addProperty("type", "anvil_rain");
            object.addProperty("anvilCount", (Number)this.anvilCount);
            object.addProperty("radius", (Number)this.radius);
            object.addProperty("height", (Number)this.height);
        }

        @Override
        protected void read(JsonObject object) {
            this.anvilCount = object.get("anvilCount").getAsInt();
            this.radius = object.get("radius").getAsInt();
            this.height = object.get("height").getAsInt();
        }

        @Override
        protected void write(CompoundTag object) {
            object.m_128359_("type", "anvil_rain");
            object.m_128405_("anvilCount", this.anvilCount);
            object.m_128405_("radius", this.radius);
            object.m_128405_("height", this.height);
        }

        @Override
        protected void read(CompoundTag object) {
            this.anvilCount = object.m_128451_("anvilCount");
            this.radius = object.m_128451_("radius");
            this.height = object.m_128451_("height");
        }
    }
}

