/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.core.vault.pandora;

import com.google.gson.JsonObject;
import iskallia.vault.core.vault.pandora.PandoraEffect;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.PrimedTnt;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class ExplosionEffect
extends PandoraEffect<Config> {
    public ExplosionEffect(Config config) {
        super(config);
    }

    @Override
    public void execute(Level level, BlockPos pos, Player breaker) {
        BlockPos spawnPos = pos.m_7494_();
        Random rnd = level.f_46441_;
        for (int i = 0; i < ((Config)this.config).amount; ++i) {
            PrimedTnt tnt = new PrimedTnt(level, (double)spawnPos.m_123341_() + 0.5, (double)spawnPos.m_123342_() + 0.5, (double)spawnPos.m_123343_() + 0.5, (LivingEntity)breaker);
            tnt.m_20049_("spew_tnt");
            tnt.m_32085_(((Config)this.config).fuseTicks);
            double vx = (rnd.nextDouble() - 0.5) * 2.0 * (double)((Config)this.config).spread;
            double vy = rnd.nextDouble() * (double)((Config)this.config).spread;
            double vz = (rnd.nextDouble() - 0.5) * 2.0 * (double)((Config)this.config).spread;
            tnt.m_20334_(vx, vy, vz);
            level.m_7967_((Entity)tnt);
        }
    }

    public static class Config
    extends PandoraEffect.Config<ExplosionEffect> {
        public int amount = 8;
        public int fuseTicks = 40;
        public float spread = 1.0f;

        @Override
        public ExplosionEffect build() {
            return new ExplosionEffect(this);
        }

        @Override
        protected void write(JsonObject json) {
            json.addProperty("type", "spew_tnt");
            json.addProperty("amount", (Number)this.amount);
            json.addProperty("fuseTicks", (Number)this.fuseTicks);
            json.addProperty("spread", (Number)Float.valueOf(this.spread));
        }

        @Override
        protected void read(JsonObject json) {
            this.amount = json.get("amount").getAsInt();
            this.fuseTicks = json.get("fuseTicks").getAsInt();
            this.spread = json.get("spread").getAsFloat();
        }

        @Override
        protected void write(CompoundTag nbt) {
            nbt.m_128359_("type", "spew_tnt");
            nbt.m_128405_("amount", this.amount);
            nbt.m_128405_("fuseTicks", this.fuseTicks);
            nbt.m_128350_("spread", this.spread);
        }

        @Override
        protected void read(CompoundTag nbt) {
            this.amount = nbt.m_128451_("amount");
            this.fuseTicks = nbt.m_128451_("fuseTicks");
            this.spread = nbt.m_128457_("spread");
        }
    }
}

