/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.core.vault.pandora;

import com.google.gson.JsonObject;
import iskallia.vault.core.vault.pandora.PandoraEffect;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistries;

public class MobSpawnEffect
extends PandoraEffect<Config> {
    public MobSpawnEffect(Config config) {
        super(config);
    }

    @Override
    public void execute(Level level, BlockPos pos, Player player) {
        if (level.f_46443_) {
            return;
        }
        Random random = level.m_5822_();
        EntityType<?> entityType = ((Config)this.config).entityType;
        for (int i = 0; i < ((Config)this.config).count; ++i) {
            double offsetX = (random.nextDouble() - 0.5) * ((Config)this.config).spawnRadius * 2.0;
            double offsetZ = (random.nextDouble() - 0.5) * ((Config)this.config).spawnRadius * 2.0;
            BlockPos spawnPos = pos.m_142082_((int)offsetX, 0, (int)offsetZ);
            while (!level.m_8055_(spawnPos).m_60795_() && spawnPos.m_123342_() < level.m_151558_()) {
                spawnPos = spawnPos.m_7494_();
            }
            Entity entity = entityType.m_20592_((ServerLevel)level, null, null, spawnPos, MobSpawnType.TRIGGERED, true, false);
            if (!(entity instanceof Mob)) continue;
            Mob mob = (Mob)entity;
            if (!((Config)this.config).targetPlayer) continue;
            mob.m_6710_((LivingEntity)player);
        }
    }

    public static class Config
    extends PandoraEffect.Config<MobSpawnEffect> {
        private EntityType<?> entityType;
        private int count;
        private double spawnRadius;
        private boolean targetPlayer;

        @Override
        public MobSpawnEffect build() {
            return new MobSpawnEffect(this);
        }

        @Override
        protected void write(JsonObject object) {
            object.addProperty("type", "spawn_mobs");
            object.addProperty("entityType", this.entityType.getRegistryName().toString());
            object.addProperty("count", (Number)this.count);
            object.addProperty("spawnRadius", (Number)this.spawnRadius);
            object.addProperty("targetPlayer", Boolean.valueOf(this.targetPlayer));
        }

        @Override
        protected void read(JsonObject object) {
            this.entityType = (EntityType)ForgeRegistries.ENTITIES.getValue(new ResourceLocation(object.get("entityType").getAsString()));
            this.count = object.get("count").getAsInt();
            this.spawnRadius = object.get("spawnRadius").getAsDouble();
            this.targetPlayer = object.get("targetPlayer").getAsBoolean();
        }

        @Override
        protected void write(CompoundTag object) {
            object.m_128359_("type", "spawn_mobs");
            object.m_128359_("entityType", this.entityType.getRegistryName().toString());
            object.m_128405_("count", this.count);
            object.m_128347_("spawnRadius", this.spawnRadius);
            object.m_128379_("targetPlayer", this.targetPlayer);
        }

        @Override
        protected void read(CompoundTag object) {
            this.entityType = (EntityType)ForgeRegistries.ENTITIES.getValue(new ResourceLocation(object.m_128461_("entityType")));
            this.count = object.m_128451_("count");
            this.spawnRadius = object.m_128459_("spawnRadius");
            this.targetPlayer = object.m_128471_("targetPlayer");
        }
    }
}

