/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.core.vault.pandora;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import iskallia.vault.core.vault.pandora.AnvilRainEffect;
import iskallia.vault.core.vault.pandora.ExplosionEffect;
import iskallia.vault.core.vault.pandora.MobSpawnEffect;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.util.INBTSerializable;

public abstract class PandoraEffect<C extends Config<?>>
implements INBTSerializable<CompoundTag> {
    protected UUID uuid = UUID.randomUUID();
    protected C config;

    public PandoraEffect(C config) {
        this.config = config;
    }

    public C getConfig() {
        return this.config;
    }

    public abstract void execute(Level var1, BlockPos var2, Player var3);

    public void write(CompoundTag object) {
        object.m_128359_("uuid", this.uuid.toString());
        object.m_128365_("config", (Tag)((Config)this.config).serializeNBT());
    }

    public void read(CompoundTag object) {
        this.uuid = UUID.fromString(object.m_128461_("uuid"));
    }

    public final CompoundTag serializeNBT() {
        CompoundTag nbt = new CompoundTag();
        this.write(nbt);
        return nbt;
    }

    public final void deserializeNBT(CompoundTag nbt) {
        this.read(nbt);
    }

    public static PandoraEffect<?> fromNBT(CompoundTag nbt) {
        return Config.fromNBT(nbt.m_128469_("config")).build(nbt);
    }

    public static abstract class Config<B extends PandoraEffect<?>>
    implements INBTSerializable<CompoundTag> {
        protected String description;

        public String getDescription() {
            return this.description;
        }

        public abstract B build();

        public B build(CompoundTag nbt) {
            B effect = this.build();
            ((PandoraEffect)effect).deserializeNBT(nbt);
            return effect;
        }

        protected abstract void write(JsonObject var1);

        protected abstract void read(JsonObject var1);

        protected abstract void write(CompoundTag var1);

        protected abstract void read(CompoundTag var1);

        public final JsonObject serializeJson() {
            JsonObject json = new JsonObject();
            json.addProperty("description", this.description);
            this.write(json);
            return json;
        }

        public final void deserializeJson(JsonObject json) {
            this.description = json.get("description").getAsString();
            this.read(json);
        }

        public final CompoundTag serializeNBT() {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128359_("description", this.description);
            this.write(nbt);
            return nbt;
        }

        public final void deserializeNBT(CompoundTag nbt) {
            this.description = nbt.m_128461_("description");
            this.read(nbt);
        }

        public static Config<?> fromNBT(CompoundTag nbt) {
            Config<?> config = Serializer.REGISTRY.get(nbt.m_128461_("type")).get();
            config.deserializeNBT(nbt);
            return config;
        }
    }

    public static class Serializer
    implements JsonSerializer<Config<?>>,
    JsonDeserializer<Config<?>> {
        public static final Map<String, Supplier<Config<?>>> REGISTRY = new HashMap();

        public JsonElement serialize(Config<?> value, Type type, JsonSerializationContext context) {
            return value.serializeJson();
        }

        public Config<?> deserialize(JsonElement json, Type type, JsonDeserializationContext context) throws JsonParseException {
            String key = json.getAsJsonObject().get("type").getAsString();
            Config<?> config = REGISTRY.get(key).get();
            config.deserializeJson(json.getAsJsonObject());
            return config;
        }

        static {
            REGISTRY.put("spawn_mobs", MobSpawnEffect.Config::new);
            REGISTRY.put("anvil_rain", AnvilRainEffect.Config::new);
            REGISTRY.put("explosion", ExplosionEffect.Config::new);
        }
    }
}

