/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.core.vault.player;

import iskallia.vault.VaultMod;
import iskallia.vault.config.ThemeAugmentLoreConfig;
import iskallia.vault.config.entry.DescriptionData;
import iskallia.vault.core.Version;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.data.adapter.vault.CompoundAdapter;
import iskallia.vault.core.data.compound.UUIDList;
import iskallia.vault.core.data.compound.UUIDXpMap;
import iskallia.vault.core.data.key.FieldKey;
import iskallia.vault.core.data.key.NamedKey;
import iskallia.vault.core.data.key.SupplierKey;
import iskallia.vault.core.data.key.ThemeKey;
import iskallia.vault.core.data.key.registry.FieldRegistry;
import iskallia.vault.core.event.CommonEvents;
import iskallia.vault.core.vault.EntityState;
import iskallia.vault.core.vault.Vault;
import iskallia.vault.core.vault.VaultRegistry;
import iskallia.vault.core.vault.VaultUtils;
import iskallia.vault.core.vault.WorldManager;
import iskallia.vault.core.vault.modifier.spi.VaultModifier;
import iskallia.vault.core.vault.objective.Objectives;
import iskallia.vault.core.vault.objective.PvPObjective;
import iskallia.vault.core.vault.player.Completion;
import iskallia.vault.core.vault.player.Listener;
import iskallia.vault.core.vault.player.ListenersLogic;
import iskallia.vault.core.vault.player.Runner;
import iskallia.vault.core.vault.stat.StatCollector;
import iskallia.vault.core.vault.time.TickClock;
import iskallia.vault.core.vault.time.modifier.TrinketExtension;
import iskallia.vault.core.world.storage.VirtualWorld;
import iskallia.vault.entity.entity.SpiritEntity;
import iskallia.vault.event.event.VaultJoinEvent;
import iskallia.vault.event.event.VaultLeaveEvent;
import iskallia.vault.gear.trinket.TrinketHelper;
import iskallia.vault.gear.trinket.effects.VaultTimeExtensionTrinket;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.init.ModGameRules;
import iskallia.vault.item.VaultCompassMode;
import iskallia.vault.item.gear.TrinketItem;
import iskallia.vault.item.gear.VaultCharmItem;
import iskallia.vault.item.gear.VaultNecklaceItem;
import iskallia.vault.network.message.ServerboundCompassModeSelectMessage;
import iskallia.vault.skill.ability.effect.spi.core.Ability;
import iskallia.vault.skill.base.Skill;
import iskallia.vault.skill.base.SkillContext;
import iskallia.vault.skill.expertise.type.TrinketerExpertise;
import iskallia.vault.skill.prestige.NoVaultUsesPrestigePower;
import iskallia.vault.skill.prestige.ShieldedPrestigePower;
import iskallia.vault.skill.prestige.helper.PrestigeHelper;
import iskallia.vault.skill.tree.AbilityTree;
import iskallia.vault.world.VaultPartyExpSharing;
import iskallia.vault.world.data.PlayerAbilitiesData;
import iskallia.vault.world.data.PlayerExpertisesData;
import iskallia.vault.world.data.PlayerPrestigePowersData;
import iskallia.vault.world.data.PlayerVaultStatsData;
import iskallia.vault.world.data.VaultPartyData;
import iskallia.vault.world.data.VaultPartyExpData;
import iskallia.vault.world.data.VaultPlayerCompassData;
import iskallia.vault.world.data.VaultPlayerStats;
import iskallia.vault.world.data.VaultSpectatorData;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.ChatType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetSubtitleTextPacket;
import net.minecraft.network.protocol.game.ClientboundSetTitleTextPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public class ClassicListenersLogic
extends ListenersLogic {
    public static final SupplierKey<ListenersLogic> KEY = (SupplierKey)SupplierKey.of("classic", ListenersLogic.class).with(Version.v1_0, (ListenersLogic)((Object)((Supplier<ListenersLogic>)ClassicListenersLogic::new)));
    public static final FieldRegistry FIELDS = ListenersLogic.FIELDS.merge(new FieldRegistry());
    public static final FieldKey<Integer> MAX_PLAYERS = (FieldKey)FieldKey.of("max_players", Integer.class).with(Version.v1_0, Adapters.INT_SEGMENTED_3, DISK.all()).register(FIELDS);
    public static final FieldKey<Integer> MIN_LEVEL = (FieldKey)FieldKey.of("min_level", Integer.class).with(Version.v1_19, Adapters.INT_SEGMENTED_3, DISK.all()).register(FIELDS);
    public static final FieldKey<Void> NATURAL_REGEN = (FieldKey)FieldKey.of("natural_regen", Void.class).with(Version.v1_0, Adapters.ofVoid(), DISK.all()).register(FIELDS);
    public static final FieldKey<Void> ADDED_BONUS_TIME = (FieldKey)FieldKey.of("added_bonus_time", Void.class).with(Version.v1_0, Adapters.ofVoid(), DISK.all()).register(FIELDS);
    public static final FieldKey<UUIDList> LEAVERS = (FieldKey)FieldKey.of("leavers", UUIDList.class).with(Version.v1_0, CompoundAdapter.of(UUIDList::create), DISK.all()).register(FIELDS);
    public static final FieldKey<GameType> GAME_MODE = (FieldKey)FieldKey.of("game_mode", GameType.class).with(Version.v1_19, Adapters.ofOrdinal(Enum::ordinal, GameType.values()).asNullable(), DISK.all()).register(FIELDS);

    public ClassicListenersLogic() {
        this.set(LEAVERS, UUIDList.create());
    }

    @Override
    public SupplierKey<ListenersLogic> getKey() {
        return KEY;
    }

    @Override
    public FieldRegistry getFields() {
        return FIELDS;
    }

    @Override
    public void initServer(VirtualWorld world, Vault vault) {
        CommonEvents.PLAYER_REGEN.register(this, data -> {
            Listener listener = vault.get(Vault.LISTENERS).get(data.getPlayer().m_142081_());
            if (!(listener instanceof Runner) || this.has(NATURAL_REGEN)) {
                return;
            }
            data.setAmount(0.0f);
        });
        CommonEvents.LISTENER_LEAVE.register(this, data -> {
            ServerPlayer player = data.getListener().getPlayer().orElse(null);
            if (data.getVault() != vault || !(data.getListener() instanceof Runner) || player == null) {
                return;
            }
            StatCollector stats = vault.get(Vault.STATS).get(data.getListener().get(Listener.ID));
            if (stats == null) {
                return;
            }
            Completion completion = stats.getCompletion();
            VaultSpectatorData spectatorData = VaultSpectatorData.get(world.m_142572_());
            List<UUID> copy = List.copyOf(spectatorData.getSpectatorsWatchingPlayer(player.m_142081_()));
            copy.forEach(VaultSpectatorData::changeSpectatorTarget);
            Object objective = this.getVaultObjective(vault.get(Vault.OBJECTIVES).get(Objectives.KEY));
            if (!((String)objective).isEmpty()) {
                objective = (String)objective + " ";
            }
            TextComponent prefix = new TextComponent(switch (completion) {
                default -> throw new IncompatibleClassChangeError();
                case Completion.COMPLETED -> " completed a " + (String)objective + "Vault!";
                case Completion.BAILED -> " survived a " + (String)objective + "Vault.";
                case Completion.FAILED -> " was defeated in a " + (String)objective + "Vault.";
            });
            if (completion == Completion.COMPLETED) {
                VaultPlayerCompassData.addProgress(player, VaultCompassMode.OBJECTIVE_PILLAR, 1);
            }
            prefix.m_6270_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0xFFFFFF)));
            MutableComponent playerName = player.m_5446_().m_6881_();
            playerName.m_6270_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)9974168)));
            world.m_142572_().m_6846_().m_11264_((Component)playerName.m_7220_((Component)prefix), ChatType.CHAT, player.m_142081_());
        });
    }

    @Override
    public void tickServer(VirtualWorld world, Vault vault, Map<UUID, Listener> listeners) {
        List<Listener> runners = listeners.values().stream().filter(listener -> listener instanceof Runner).toList();
        this.keepInVault(world, vault, runners);
        if (runners.stream().noneMatch(Listener::isOnline)) {
            vault.ifPresent(Vault.CLOCK, clock -> clock.set(TickClock.PAUSED));
        }
        if (runners.isEmpty()) {
            List<Listener> allListeners = List.copyOf(vault.get(Vault.LISTENERS).getAll());
            for (Listener listener2 : allListeners) {
                vault.get(Vault.LISTENERS).remove(world, vault, listener2);
            }
        }
        if (vault.get(Vault.LISTENERS).getAll().isEmpty()) {
            VaultPartyExpSharing expSharing = ((VaultPartyExpSharing.GameRuleValue)world.m_46469_().m_46170_(ModGameRules.PARTY_EXP_SHARING)).get();
            if (expSharing != VaultPartyExpSharing.DISABLED && VaultPartyExpData.get(world.m_142572_()).getVaultXpMap(vault.get(Vault.ID)).size() > 1) {
                this.distributePartyExperience(world, vault, expSharing);
            }
            SpiritEntity.onVaultEnd((Level)world, vault.get(Vault.ID));
            world.markForDeletion();
            vault.set(Vault.FINISHED);
            vault.releaseServer();
        }
    }

    private void distributePartyExperience(VirtualWorld world, Vault vault, VaultPartyExpSharing expSharing) {
        VaultPartyExpData data = VaultPartyExpData.get(world.m_142572_());
        UUIDXpMap xpMap = data.getVaultXpMap(vault.get(Vault.ID));
        int sharedExp = data.getDistributionXP(vault.get(Vault.ID), expSharing);
        data.distributeXp(world, vault.get(Vault.ID), sharedExp);
    }

    @Override
    public void releaseServer() {
        CommonEvents.release(this);
    }

    @Override
    public boolean onJoin(VirtualWorld world, Vault vault, Listener listener) {
        VaultPartyData.Party party;
        ServerPlayer player2;
        long active;
        boolean started;
        if (vault.get(Vault.LISTENERS).contains(listener.get(Listener.ID))) {
            return false;
        }
        if (VaultUtils.isPvPVault(vault) && (started = vault.get(Vault.OBJECTIVES).getAll(PvPObjective.class).stream().findFirst().map(obj -> obj.has(PvPObjective.COUNTDOWN_FINISHED)).orElse(false).booleanValue())) {
            listener.getPlayer().ifPresent(player -> player.m_5661_((Component)new TextComponent("This vault has already started.").m_130940_(ChatFormatting.RED), true));
            return false;
        }
        if (this.has(MAX_PLAYERS) && (active = vault.get(Vault.LISTENERS).getAll().stream().filter(l -> l instanceof Runner).count()) >= (long)this.get(MAX_PLAYERS).intValue() && listener instanceof Runner) {
            listener.getPlayer().ifPresent(player -> player.m_5661_((Component)new TextComponent("This vault has reached maximum capacity.").m_130940_(ChatFormatting.RED), true));
            return false;
        }
        if (this.has(MIN_LEVEL) && (player2 = (ServerPlayer)listener.getPlayer().orElse(null)) != null && PlayerVaultStatsData.get(player2.m_20194_()).getVaultStats((Player)player2).getVaultLevel() < this.get(MIN_LEVEL)) {
            player2.m_5661_((Component)new TextComponent("The minimum level for this vault is " + String.valueOf(this.get(MIN_LEVEL)) + ".").m_130940_(ChatFormatting.RED), true);
            return false;
        }
        if (this.has(LEAVERS) && this.get(LEAVERS).contains(listener.get(Listener.ID))) {
            listener.getPlayer().ifPresent(player -> player.m_5661_((Component)new TextComponent("You cannot re-enter this vault.").m_130940_(ChatFormatting.RED), true));
            return false;
        }
        if (vault.has(Vault.OWNER) && !vault.get(Vault.OWNER).equals(listener.get(Listener.ID)) && world.m_46469_().m_46207_(ModGameRules.JOIN_REQUIRE_PARTY) && ((party = (VaultPartyData.Party)VaultPartyData.get(world).getParty(vault.get(Vault.OWNER)).orElse(null)) == null || !party.hasMember(listener.get(Listener.ID)))) {
            listener.getPlayer().ifPresent(player -> player.m_5661_((Component)new TextComponent("This vault is reserved for allowed party members.").m_130940_(ChatFormatting.RED), true));
            return false;
        }
        if (!vault.has(Vault.OWNER)) {
            vault.set(Vault.OWNER, listener.get(Listener.ID));
        }
        if (!this.has(ADDED_BONUS_TIME) && listener instanceof Runner) {
            this.set(ADDED_BONUS_TIME);
        }
        listener.getPlayer().ifPresent(player -> {
            TrinketHelper.getTrinkets((LivingEntity)player).forEach(trinket -> {
                if (!trinket.isUsable((Player)player)) {
                    return;
                }
                if (trinket.stack() != null && this.shouldAddFree((ServerPlayer)player, vault, trinket.stack())) {
                    TrinketItem.addFreeUsedVault(trinket.stack(), vault.get(Vault.ID));
                    return;
                }
                double damageAvoidanceChance = PlayerExpertisesData.get(player.m_183503_()).getExpertises((Player)player).getAll(TrinketerExpertise.class, Skill::isUnlocked).stream().mapToDouble(TrinketerExpertise::getDamageAvoidanceChance).sum();
                if (player.f_19853_.f_46441_.nextDouble() < damageAvoidanceChance) {
                    TrinketItem.addFreeUsedVault(trinket.stack(), vault.get(Vault.ID));
                    return;
                }
                TrinketItem.addUsedVault(trinket.stack(), vault.get(Vault.ID));
            });
            VaultNecklaceItem.getNecklace((LivingEntity)player).ifPresent(necklaceStack -> {
                if (!VaultNecklaceItem.isUsable(necklaceStack, (Player)player)) {
                    return;
                }
                if (this.shouldAddFree((ServerPlayer)player, vault, (ItemStack)necklaceStack)) {
                    VaultNecklaceItem.addFreeUsedVault(necklaceStack, vault.get(Vault.ID));
                    return;
                }
                VaultNecklaceItem.addUsedVault(necklaceStack, vault.get(Vault.ID));
            });
            VaultCharmItem.getCharm((LivingEntity)player).ifPresent(charmStack -> {
                if (!VaultCharmItem.isUsable(charmStack, (Player)player)) {
                    return;
                }
                if (this.shouldAddFree((ServerPlayer)player, vault, (ItemStack)charmStack)) {
                    VaultCharmItem.addFreeUsedVault(charmStack, vault.get(Vault.ID));
                    return;
                }
                VaultCharmItem.addUsedVault(charmStack, vault.get(Vault.ID));
            });
            TrinketHelper.getTrinkets((LivingEntity)player, VaultTimeExtensionTrinket.class).forEach(timeTrinket -> {
                if (!timeTrinket.isUsable((Player)player)) {
                    return;
                }
                vault.get(Vault.CLOCK).addModifier(new TrinketExtension((Player)player, ((VaultTimeExtensionTrinket.Config)((VaultTimeExtensionTrinket)((Object)((Object)((Object)timeTrinket.trinket())))).getConfig()).getTimeAdded()));
            });
        });
        return true;
    }

    @Override
    protected void onTeleport(VirtualWorld world, Vault vault, ServerPlayer player) {
        MinecraftForge.EVENT_BUS.post((Event)new VaultJoinEvent(vault, player));
        String objective = this.getVaultObjective(vault.get(Vault.OBJECTIVES).get(Objectives.KEY));
        ResourceLocation theme = vault.get(Vault.WORLD).get(WorldManager.THEME);
        Optional<ThemeKey> themeKey = Optional.ofNullable(VaultRegistry.THEME.getKey(theme));
        Optional<ThemeAugmentLoreConfig.AugmentLore> themeGroup = ModConfigs.THEME_AUGMENT_LORE.getAugmentLore(theme);
        MutableComponent title = new TextComponent(objective).m_6270_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)14536734)));
        String themeName = themeKey.map(NamedKey::getName).orElse("Unknown");
        String themeGroupName = themeGroup.map(lore -> lore.displayName).orElse("Unknown");
        MutableComponent subtitle = new TextComponent(themeGroupName + ": " + themeName).m_6270_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)themeKey.map(ThemeKey::getColor).orElse(0xFFFFFF))));
        ClientboundSetTitleTextPacket titlePacket = new ClientboundSetTitleTextPacket((Component)title);
        ClientboundSetSubtitleTextPacket subtitlePacket = new ClientboundSetSubtitleTextPacket((Component)subtitle);
        player.f_8906_.m_141995_((Packet)titlePacket);
        player.f_8906_.m_141995_((Packet)subtitlePacket);
        VaultPartyExpData.get(world.m_142572_()).addPlayerXp(vault.get(Vault.ID), player.m_142081_(), 0);
        this.ifPresent(GAME_MODE, arg_0 -> ((ServerPlayer)player).m_143403_(arg_0));
        PlayerAbilitiesData abilitiesData = PlayerAbilitiesData.get(player.m_183503_());
        AbilityTree abilities = abilitiesData.getAbilities((Player)player);
        abilities.getAll(Ability.class, Ability::isActive).forEach(ability -> {
            ability.putOnCooldown(0, SkillContext.of(player));
            ability.reduceCooldownBy(ability.getCooldownTicks());
            ability.setActive(false);
        });
        if (player.f_8941_.m_9294_()) {
            player.m_21219_();
            if (VaultUtils.isRoyaleVault(vault)) {
                player.m_7911_(0.0f);
            } else {
                float absorptionPercentage = 0.0f;
                for (ShieldedPrestigePower power : PrestigeHelper.getPrestige((Player)player).getAll(ShieldedPrestigePower.class, Skill::isUnlocked)) {
                    absorptionPercentage += power.getPercentageOfHearts();
                }
                if (absorptionPercentage > 0.0f) {
                    player.m_7911_(player.m_21233_() * absorptionPercentage);
                } else {
                    player.m_7911_(0.0f);
                }
            }
        }
        this.printJoinMessage(world, vault, player);
    }

    private void printJoinMessage(VirtualWorld world, Vault vault, ServerPlayer player) {
        int maxPlayers;
        Object objective;
        TextComponent text = new TextComponent("");
        AtomicBoolean startsWithVowel = new AtomicBoolean(false);
        ArrayList<Object2IntMap.Entry> nonRoyaleEntries = new ArrayList<Object2IntMap.Entry>();
        for (Object2IntMap.Entry entry : vault.get(Vault.MODIFIERS).getDisplayGroup().object2IntEntrySet()) {
            if (((VaultModifier)entry.getKey()).getId().equals((Object)VaultMod.id("royale"))) continue;
            nonRoyaleEntries.add(entry);
        }
        for (int i = 0; i < nonRoyaleEntries.size(); ++i) {
            Object2IntMap.Entry entry = (Object2IntMap.Entry)nonRoyaleEntries.get(i);
            text.m_7220_(((VaultModifier)entry.getKey()).getChatDisplayNameComponent(entry.getIntValue()));
            if (i < nonRoyaleEntries.size() - 1) {
                text.m_7220_((Component)new TextComponent(", "));
                continue;
            }
            text.m_7220_((Component)new TextComponent(" "));
        }
        TextComponent prefix = new TextComponent(startsWithVowel.get() ? " entered an " : " entered a ");
        if (VaultUtils.isPvPVault(vault)) {
            prefix.m_7220_((Component)new TextComponent("PvP ").m_130940_(ChatFormatting.RED));
        }
        if (!((String)(objective = this.getVaultObjective(vault.get(Vault.OBJECTIVES).get(Objectives.KEY)))).isEmpty()) {
            objective = (String)objective + " ";
        }
        text.m_130946_((String)objective + "Vault").m_130946_("!");
        int joined = (int)vault.get(Vault.LISTENERS).getAll().stream().filter(l -> l instanceof Runner).count();
        int n = maxPlayers = this.has(MAX_PLAYERS) ? this.get(MAX_PLAYERS) : 0;
        if (VaultUtils.isPvPVault(vault)) {
            text.m_7220_((Component)new TextComponent(" (" + joined + "/" + maxPlayers + ")")).m_130940_(ChatFormatting.GRAY);
        }
        prefix.m_6270_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0xFFFFFF)));
        text.m_6270_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0xFFFFFF)));
        MutableComponent playerName = player.m_5446_().m_6881_();
        playerName.m_6270_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)9974168)));
        MutableComponent fullMsg = playerName.m_7220_((Component)prefix).m_7220_((Component)text);
        ResourceLocation themeReg = vault.get(Vault.WORLD).get(WorldManager.THEME);
        Optional<ThemeKey> themeKey = Optional.ofNullable(VaultRegistry.THEME.getKey(themeReg));
        Optional<ThemeAugmentLoreConfig.AugmentLore> themeGroup = ModConfigs.THEME_AUGMENT_LORE.getAugmentLore(themeReg);
        if (themeKey.isPresent() && themeGroup.isPresent()) {
            MutableComponent hovertext = new TextComponent("Theme: " + themeKey.get().getName()).m_130946_("\n");
            for (DescriptionData descriptionData : ModConfigs.THEME_AUGMENT_LORE.getAugmentLore(themeReg).map(lore -> lore.description).orElse(new DescriptionData[0])) {
                hovertext.m_7220_((Component)descriptionData.getComponent()).m_130946_("\n");
            }
            fullMsg.m_130948_(Style.f_131099_.m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)hovertext)));
        }
        world.m_142572_().m_6846_().m_11264_((Component)fullMsg, ChatType.CHAT, player.m_142081_());
    }

    @Override
    public boolean onLeave(VirtualWorld world, Vault vault, Listener listener) {
        return listener.getPlayer().map(player -> {
            if (!player.m_21224_()) {
                this.recallToJoinState(Stream.of(listener));
            } else {
                player.m_143403_(listener.get(Listener.JOIN_STATE).get(EntityState.GAME_MODE));
            }
            UUID playerId = player.m_142081_();
            VaultPartyExpSharing expSharing = ((VaultPartyExpSharing.GameRuleValue)world.m_46469_().m_46170_(ModGameRules.PARTY_EXP_SHARING)).get();
            if (expSharing != VaultPartyExpSharing.DISABLED) {
                StatCollector stats = vault.get(Vault.STATS).get(playerId);
                int experience = stats.getExperience(vault);
                VaultPartyExpData.get(world.m_142572_()).addPlayerXp(vault.get(Vault.ID), playerId, experience);
            }
            VaultPlayerStats.addStats(playerId, vault.get(Vault.ID));
            ServerboundCompassModeSelectMessage.removeCompassModePenalty(player);
            MinecraftForge.EVENT_BUS.post((Event)new VaultLeaveEvent((ServerPlayer)player, vault));
            this.get(LEAVERS).add(playerId);
            return true;
        }).orElse(false);
    }

    public String getVaultObjective(String key) {
        return switch (key == null ? "" : key.toLowerCase()) {
            case "boss" -> "Hunt the Runes";
            case "monolith" -> "Brazier";
            case "rune_boss" -> "Rune Boss";
            case "royale_pvp" -> "Royale";
            case "pvp" -> "PvP";
            case "empty", "" -> "";
            default -> key.substring(0, 1).toUpperCase() + key.substring(1);
        };
    }

    protected boolean shouldAddFree(ServerPlayer player, Vault vault, ItemStack stack) {
        if (stack.m_41619_()) {
            return false;
        }
        return VaultUtils.isRawVault(vault) || VaultUtils.isTrialVault(vault) || VaultUtils.isRoyaleVault(vault) || PlayerPrestigePowersData.get(player.m_183503_()).getPowers((Player)player).getAll(NoVaultUsesPrestigePower.class, Skill::isUnlocked).stream().anyMatch(power -> power.getItemId().equals((Object)stack.m_41720_().getRegistryName()));
    }
}

