/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.core.vault.player;

import iskallia.vault.core.Version;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.data.adapter.vault.CompoundAdapter;
import iskallia.vault.core.data.compound.ItemStackList;
import iskallia.vault.core.data.key.FieldKey;
import iskallia.vault.core.data.key.SupplierKey;
import iskallia.vault.core.data.key.registry.FieldRegistry;
import iskallia.vault.core.event.CommonEvents;
import iskallia.vault.core.vault.NaturalSpawner;
import iskallia.vault.core.vault.ScheduledModifiers;
import iskallia.vault.core.vault.Vault;
import iskallia.vault.core.vault.VaultUtils;
import iskallia.vault.core.vault.influence.Influences;
import iskallia.vault.core.vault.player.Listener;
import iskallia.vault.core.vault.stat.StatCollector;
import iskallia.vault.core.vault.time.TickClock;
import iskallia.vault.core.vault.time.modifier.ClockModifier;
import iskallia.vault.core.vault.time.modifier.FruitExtension;
import iskallia.vault.core.vault.time.modifier.VoidFluidExtension;
import iskallia.vault.core.world.storage.VirtualWorld;
import iskallia.vault.gear.trinket.TrinketHelper;
import iskallia.vault.gear.trinket.effects.VaultExperienceTrinket;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.init.ModEffects;
import iskallia.vault.init.ModGameRules;
import iskallia.vault.item.VaultDollItem;
import iskallia.vault.item.bottle.BottleItem;
import iskallia.vault.skill.PlayerVaultStats;
import iskallia.vault.util.InventoryUtil;
import iskallia.vault.world.data.PlayerVaultStatsData;
import iskallia.vault.world.data.VaultJoinSnapshotData;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;

public class Runner
extends Listener {
    public static final SupplierKey<Listener> KEY = (SupplierKey)SupplierKey.of("runner", Listener.class).with(Version.v1_0, (Listener)((Object)((Supplier<Listener>)Runner::new)));
    public static final FieldRegistry FIELDS = Listener.FIELDS.merge(new FieldRegistry());
    public static final FieldKey<NaturalSpawner> SPAWNER = (FieldKey)FieldKey.of("spawner", NaturalSpawner.class).with(Version.v1_0, CompoundAdapter.of(NaturalSpawner::new), DISK.all()).register(FIELDS);
    public static final FieldKey<Influences> INFLUENCES = (FieldKey)FieldKey.of("influences", Influences.class).with(Version.v1_5, CompoundAdapter.of(Influences::new), DISK.all().or(CLIENT.all())).register(FIELDS);
    public static final FieldKey<ScheduledModifiers> SCHEDULED_MODIFIERS = (FieldKey)FieldKey.of("scheduled_modifiers", ScheduledModifiers.class).with(Version.v1_28, Adapters.of(ScheduledModifiers::new, true), DISK.all().or(CLIENT.all())).register(FIELDS);
    public static final FieldKey<ItemStackList> ADDITIONAL_CRATE_ITEMS = (FieldKey)FieldKey.of("additional_crate_items", ItemStackList.class).with(Version.v1_29, CompoundAdapter.of(ItemStackList::create), DISK.all()).register(FIELDS);

    public Runner() {
        this.set(SPAWNER, new NaturalSpawner());
        this.set(INFLUENCES, new Influences());
        this.set(SCHEDULED_MODIFIERS, new ScheduledModifiers());
    }

    @Override
    public SupplierKey<Listener> getKey() {
        return KEY;
    }

    @Override
    public FieldRegistry getFields() {
        return FIELDS;
    }

    @Override
    public void initServer(VirtualWorld world, Vault vault) {
        CommonEvents.PLAYER_INTERACT.register(this, event -> {
            if (event.getPlayer().f_19853_ != world) {
                return;
            }
            if (!event.isCancelable()) {
                return;
            }
            if (!event.getPlayer().m_142081_().equals(this.get(ID))) {
                return;
            }
            if (event.getPlayer().m_7500_()) {
                return;
            }
            if (ModConfigs.VAULT_GENERAL.isBlacklisted(event.getItemStack())) {
                event.setCanceled(true);
            }
            if (ModConfigs.VAULT_GENERAL.isBlacklisted(event.getWorld().m_8055_(event.getPos()))) {
                event.setCanceled(true);
            }
        });
        CommonEvents.ENTITY_PLACE.register(this, event -> {
            Player player;
            if (!(event.getEntity() instanceof ServerPlayer)) {
                return;
            }
            if (event.getEntity().f_19853_ != world) {
                return;
            }
            if (!event.isCancelable()) {
                return;
            }
            if (!event.getEntity().m_142081_().equals(this.get(ID))) {
                return;
            }
            Entity patt4170$temp = event.getEntity();
            if (patt4170$temp instanceof Player && (player = (Player)patt4170$temp).m_7500_()) {
                return;
            }
            if (ModConfigs.VAULT_GENERAL.isBlacklisted(event.getWorld().m_8055_(event.getPos()))) {
                event.setCanceled(true);
            }
        });
        CommonEvents.EFFECT_ADD.register(this, event -> {
            Entity patt4494$temp = event.getEntity();
            if (!(patt4494$temp instanceof ServerPlayer)) {
                return;
            }
            ServerPlayer player = (ServerPlayer)patt4494$temp;
            if (player.f_19853_ != world) {
                return;
            }
            if (!player.m_142081_().equals(this.get(ID))) {
                return;
            }
            if (event.getPotionEffect().m_19544_() == ModEffects.TIMER_ACCELERATION) {
                for (ClockModifier modifier : vault.get(Vault.CLOCK).get(TickClock.MODIFIERS)) {
                    VoidFluidExtension voidFluidExtension;
                    if (modifier.has(ClockModifier.CONSUMED) || !(modifier instanceof VoidFluidExtension) || !(voidFluidExtension = (VoidFluidExtension)modifier).get(VoidFluidExtension.PLAYER).equals(this.get(ID))) continue;
                    return;
                }
                vault.get(Vault.CLOCK).addModifier(new VoidFluidExtension((Player)player));
            }
        });
        CommonEvents.FRUIT_EATEN.register(this, data -> {
            Player patt5319$temp = data.getPlayer();
            if (!(patt5319$temp instanceof ServerPlayer)) {
                return;
            }
            ServerPlayer player = (ServerPlayer)patt5319$temp;
            if (player.f_19853_ != world) {
                return;
            }
            if (!player.m_142081_().equals(this.get(ID))) {
                return;
            }
            vault.get(Vault.CLOCK).addModifier(new FruitExtension((Player)player, data.getTime()));
        });
        CommonEvents.ENTITY_DEATH.register(this, event -> {
            if (event.getEntity().f_19853_ != world) {
                return;
            }
            Entity source = event.getSource().m_7639_();
            if (source == null || !source.m_142081_().equals(this.getId())) {
                return;
            }
            if (!event.getEntity().m_19880_().contains("soul_shards")) {
                return;
            }
            this.getPlayer().ifPresent(player -> BottleItem.getActive(vault, player).ifPresent(stack -> BottleItem.onMobKill(stack, player, event.getEntity())));
        });
        CommonEvents.CHEST_LOOT_GENERATION.post().register(this, event -> {
            if (event.getTileEntity().m_58904_() != world) {
                return;
            }
            if (!event.getPlayer().m_142081_().equals(this.getId())) {
                return;
            }
            this.getPlayer().ifPresent(player -> BottleItem.getActive(vault, player).ifPresent(stack -> BottleItem.onChestOpen(stack, player, event.getState())));
        });
        this.ifPresent(INFLUENCES, influences -> influences.initServer(world, vault, this));
    }

    @Override
    public void tickServer(VirtualWorld world, Vault vault) {
        super.tickServer(world, vault);
        this.ifPresent(SPAWNER, spawner -> {
            if (vault.has(Vault.CLOCK) && vault.get(Vault.CLOCK).get(TickClock.LOGICAL_TIME) < 300) {
                return;
            }
            int vaultLevel = vault.get(Vault.LEVEL).get();
            NaturalSpawner.Config config = ModConfigs.VAULT_MOBS.getForLevel((int)vaultLevel).SPAWNER;
            spawner.setConfig(config).tickServer(world, vault, this);
        });
        this.ifPresent(INFLUENCES, influences -> influences.tickServer(world, vault, this));
        this.getPlayer().flatMap(player -> BottleItem.getActive(vault, player)).ifPresent(BottleItem::onTimeTick);
        this.getPlayer().ifPresent(player -> this.ifPresent(SCHEDULED_MODIFIERS, scheduledModifiers -> scheduledModifiers.onTick(world, vault, (ServerPlayer)player)));
    }

    @Override
    public void releaseServer() {
        super.releaseServer();
        this.ifPresent(INFLUENCES, Influences::releaseServer);
    }

    @Override
    public void onJoin(VirtualWorld world, Vault vault) {
        super.onJoin(world, vault);
        this.getPlayer().ifPresent(player -> {
            if (!VaultUtils.isRoyaleVault(vault)) {
                VaultJoinSnapshotData.get(player.m_183503_()).createSnapshot((Player)player);
            }
            VaultDollItem.markDollOnVaultJoin(world, (Player)player, vault.get(Vault.ID));
            List<TrinketHelper.TrinketStack<VaultExperienceTrinket>> trinkets = TrinketHelper.getTrinkets((LivingEntity)player, VaultExperienceTrinket.class);
            for (TrinketHelper.TrinketStack<VaultExperienceTrinket> trinketStack : trinkets) {
                if (!trinketStack.isUsable((Player)player)) continue;
                vault.getOptional(Vault.STATS).map(s -> s.get(player.m_142081_())).ifPresent(stats -> {
                    float multiplier = 1.0f + ((VaultExperienceTrinket.Config)((VaultExperienceTrinket)((Object)((Object)((Object)trinketStack.trinket())))).getConfig()).getExperienceIncrease();
                    stats.modify(StatCollector.OBJECTIVE_EXP_MULTIPLIER, m -> Float.valueOf(m.floatValue() * multiplier));
                    stats.modify(StatCollector.BONUS_EXP_MULTIPLIER, m -> Float.valueOf(m.floatValue() * multiplier));
                });
            }
            if (player.m_183503_().m_46469_().m_46207_(ModGameRules.BOOST_PENALTY)) {
                PlayerVaultStats playerStats = PlayerVaultStatsData.get(world).getVaultStats((Player)player);
                int vaultLevel = vault.get(Vault.LEVEL).get();
                int playerLevel = playerStats.getVaultLevel();
                int delta = playerLevel - vaultLevel - 1;
                if (delta > 0) {
                    float multiplier = Math.max(0.0f, 1.0f - (float)delta * 0.2f);
                    vault.getOptional(Vault.STATS).map(s -> s.get(player.m_142081_())).ifPresent(stats -> {
                        stats.modify(StatCollector.OBJECTIVE_EXP_MULTIPLIER, m -> Float.valueOf(m.floatValue() * multiplier));
                        stats.modify(StatCollector.BONUS_EXP_MULTIPLIER, m -> Float.valueOf(m.floatValue() * multiplier));
                    });
                }
            }
            BottleItem.setActive(vault, player);
            this.ifPresent(SCHEDULED_MODIFIERS, scheduledModifiers -> scheduledModifiers.onJoin(vault, (ServerPlayer)player));
        });
    }

    @Override
    public void onLeave(VirtualWorld world, Vault vault) {
        super.onLeave(world, vault);
        this.ifPresent(INFLUENCES, influences -> influences.onLeave(world, vault, this));
        this.getPlayer().ifPresent(InventoryUtil::makeItemsRotten);
        this.getPlayer().ifPresent(InventoryUtil::removeRoyaleItems);
    }
}

