/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.core.vault.pylon;

import com.google.gson.JsonObject;
import iskallia.vault.core.vault.pylon.PylonBuff;
import iskallia.vault.core.vault.pylon.TickingPylonBuff;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraftforge.registries.ForgeRegistries;

public class AttributePylonBuff
extends TickingPylonBuff<Config> {
    public AttributePylonBuff(Config config) {
        super(config);
    }

    @Override
    public boolean isDone() {
        return super.isDone() || this.tick >= ((Config)this.config).duration;
    }

    @Override
    public void onTick(MinecraftServer server) {
        super.onTick(server);
        this.getPlayer(server).ifPresent(player -> {
            AttributeModifier modifier = new AttributeModifier(this.uuid, "Pylon Buff", ((Config)this.config).amount, ((Config)this.config).operation);
            AttributeInstance attribute = player.m_21051_(((Config)this.config).attribute);
            if (attribute != null && !attribute.m_22109_(modifier)) {
                attribute.m_22118_(modifier);
            }
        });
    }

    @Override
    public void onRemove(MinecraftServer server) {
        this.getPlayer(server).ifPresent(player -> {
            AttributeInstance attribute = player.m_21051_(((Config)this.config).attribute);
            if (attribute != null) {
                attribute.m_22120_(this.uuid);
            }
        });
    }

    public static class Config
    extends PylonBuff.Config<AttributePylonBuff> {
        private Attribute attribute;
        private double amount;
        private AttributeModifier.Operation operation;
        private int duration;

        @Override
        public int getDuration() {
            return this.duration;
        }

        @Override
        public AttributePylonBuff build() {
            return new AttributePylonBuff(this);
        }

        @Override
        public void write(JsonObject object) {
            object.addProperty("type", "attribute");
            object.addProperty("attribute", this.attribute.getRegistryName().toString());
            object.addProperty("amount", (Number)this.amount);
            object.addProperty("operation", this.operation.name());
            object.addProperty("duration", (Number)this.duration);
        }

        @Override
        public void read(JsonObject object) {
            this.attribute = (Attribute)ForgeRegistries.ATTRIBUTES.getValue(new ResourceLocation(object.get("attribute").getAsString()));
            this.amount = object.get("duration").getAsDouble();
            this.operation = Enum.valueOf(AttributeModifier.Operation.class, object.get("duration").getAsString());
            this.duration = object.get("duration").getAsInt();
        }

        @Override
        public void write(CompoundTag object) {
            object.m_128359_("type", "attribute");
            object.m_128359_("attribute", this.attribute.getRegistryName().toString());
            object.m_128347_("amount", this.amount);
            object.m_128359_("operation", this.operation.name());
            object.m_128405_("duration", this.duration);
        }

        @Override
        public void read(CompoundTag object) {
            this.attribute = (Attribute)ForgeRegistries.ATTRIBUTES.getValue(new ResourceLocation(object.m_128461_("attribute")));
            this.amount = object.m_128459_("amount");
            this.operation = Enum.valueOf(AttributeModifier.Operation.class, object.m_128461_("operation"));
            this.duration = object.m_128451_("duration");
        }
    }
}

