/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.core.vault.pylon;

import com.google.gson.JsonObject;
import iskallia.vault.core.event.CommonEvents;
import iskallia.vault.core.vault.pylon.PylonBuff;
import iskallia.vault.core.vault.pylon.TickingPylonBuff;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.effect.MobEffect;
import net.minecraftforge.registries.ForgeRegistries;

public class EffectPylonBuff
extends TickingPylonBuff<Config> {
    public EffectPylonBuff(Config config) {
        super(config);
    }

    @Override
    public boolean isDone() {
        return super.isDone() || this.tick >= ((Config)this.config).duration;
    }

    @Override
    public void initServer(MinecraftServer server) {
        CommonEvents.GRANTED_EFFECT.register(this.uuid, data -> {
            if (!this.playerUuid.equals(data.getPlayer().m_142081_())) {
                return;
            }
            if (!data.getFilter().test(((Config)this.config).effect)) {
                return;
            }
            data.getEffects().addAmplifier(((Config)this.config).effect, ((Config)this.config).amplifier);
        });
    }

    @Override
    public void releaseServer() {
        CommonEvents.GRANTED_EFFECT.release(this.uuid);
    }

    public static class Config
    extends PylonBuff.Config<EffectPylonBuff> {
        private MobEffect effect;
        private int amplifier;
        private int duration;

        @Override
        public int getDuration() {
            return this.duration;
        }

        @Override
        public EffectPylonBuff build() {
            return new EffectPylonBuff(this);
        }

        @Override
        public void write(JsonObject object) {
            object.addProperty("type", "effect");
            object.addProperty("effect", this.effect.getRegistryName().toString());
            object.addProperty("amplifier", (Number)this.amplifier);
            object.addProperty("duration", (Number)this.duration);
        }

        @Override
        public void read(JsonObject object) {
            this.effect = (MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(new ResourceLocation(object.get("effect").getAsString()));
            this.amplifier = object.get("amplifier").getAsInt();
            this.duration = object.get("duration").getAsInt();
        }

        @Override
        public void write(CompoundTag object) {
            object.m_128359_("type", "effect");
            object.m_128359_("effect", this.effect.getRegistryName().toString());
            object.m_128405_("amplifier", this.amplifier);
            object.m_128405_("duration", this.duration);
        }

        @Override
        public void read(CompoundTag object) {
            this.effect = (MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(new ResourceLocation(object.m_128461_("effect")));
            this.amplifier = object.m_128451_("amplifier");
            this.duration = object.m_128451_("duration");
        }
    }
}

