/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.core.vault.pylon;

import com.google.gson.JsonObject;
import iskallia.vault.core.vault.pylon.PylonBuff;
import iskallia.vault.mana.Mana;
import iskallia.vault.mana.ManaAction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.entity.player.Player;

public class ManaPylonBuff
extends PylonBuff<Config> {
    public ManaPylonBuff(Config config) {
        super(config);
    }

    @Override
    public boolean isDone() {
        return true;
    }

    @Override
    public void onAdd(MinecraftServer server) {
        this.getPlayer(server).ifPresent(player -> {
            float current = Mana.get((Player)player);
            float total = Mana.getMax((Player)player);
            Mana.set((Player)player, ManaAction.PLAYER_ACTION, ((Config)this.config).missingManaPercent * (total - current) + current);
        });
    }

    public static class Config
    extends PylonBuff.Config<ManaPylonBuff> {
        private float missingManaPercent;

        @Override
        public ManaPylonBuff build() {
            return new ManaPylonBuff(this);
        }

        @Override
        public void write(JsonObject object) {
            object.addProperty("type", "mana");
            object.addProperty("missingManaPercent", (Number)Float.valueOf(this.missingManaPercent));
        }

        @Override
        public void read(JsonObject object) {
            this.missingManaPercent = object.get("missingManaPercent").getAsFloat();
        }

        @Override
        public void write(CompoundTag object) {
            object.m_128359_("type", "mana");
            object.m_128350_("missingManaPercent", this.missingManaPercent);
        }

        @Override
        public void read(CompoundTag object) {
            this.missingManaPercent = object.m_128457_("missingManaPercent");
        }
    }
}

