/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.core.vault.pylon;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import iskallia.vault.core.vault.Vault;
import iskallia.vault.core.vault.pylon.AttributePylonBuff;
import iskallia.vault.core.vault.pylon.EffectPylonBuff;
import iskallia.vault.core.vault.pylon.ManaPylonBuff;
import iskallia.vault.core.vault.pylon.PotionPylonBuff;
import iskallia.vault.core.vault.pylon.StatPylonBuff;
import iskallia.vault.core.vault.pylon.TimePylonBuff;
import iskallia.vault.world.data.ServerVaults;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.util.INBTSerializable;

public abstract class PylonBuff<C extends Config<?>>
implements INBTSerializable<CompoundTag> {
    protected UUID uuid = UUID.randomUUID();
    protected UUID playerUuid;
    protected UUID vaultUuid;
    protected C config;

    public PylonBuff(C config) {
        this.config = config;
    }

    public C getConfig() {
        return this.config;
    }

    public void setPlayer(Player player) {
        this.playerUuid = player.m_142081_();
    }

    public void setVault(Vault vault) {
        this.vaultUuid = vault.get(Vault.ID);
    }

    public boolean isDone() {
        if (this.vaultUuid != null) {
            return ServerVaults.get(this.vaultUuid).map(vault -> !vault.get(Vault.LISTENERS).contains(this.playerUuid)).orElse(false);
        }
        return false;
    }

    public void initServer(MinecraftServer server) {
    }

    public void releaseServer() {
    }

    public void onAdd(MinecraftServer server) {
    }

    public void onTick(MinecraftServer server) {
    }

    public void onRemove(MinecraftServer server) {
    }

    public Optional<ServerPlayer> getPlayer(MinecraftServer server) {
        return Optional.ofNullable(server.m_6846_().m_11259_(this.playerUuid));
    }

    public void write(CompoundTag object) {
        object.m_128359_("uuid", this.uuid.toString());
        object.m_128359_("playerUuid", this.playerUuid.toString());
        if (this.vaultUuid != null) {
            object.m_128359_("vaultUuid", this.vaultUuid.toString());
        }
        object.m_128365_("config", (Tag)((Config)this.config).serializeNBT());
    }

    public void read(CompoundTag object) {
        this.uuid = UUID.fromString(object.m_128461_("uuid"));
        this.playerUuid = UUID.fromString(object.m_128461_("playerUuid"));
        if (object.m_128441_("vaultUuid")) {
            this.vaultUuid = UUID.fromString(object.m_128461_("vaultUuid"));
        }
    }

    public final CompoundTag serializeNBT() {
        CompoundTag nbt = new CompoundTag();
        this.write(nbt);
        return nbt;
    }

    public final void deserializeNBT(CompoundTag nbt) {
        this.read(nbt);
    }

    public static PylonBuff<?> fromNBT(CompoundTag nbt) {
        return Config.fromNBT(nbt.m_128469_("config")).build(nbt);
    }

    public static abstract class Config<B extends PylonBuff<?>>
    implements INBTSerializable<CompoundTag> {
        protected boolean uber;
        protected int color;
        protected int uberColor;
        protected String description;

        public int getDuration() {
            return 0;
        }

        public int getColor() {
            return this.color;
        }

        public int getUberColor() {
            return this.uberColor;
        }

        public boolean getUber() {
            return this.uber;
        }

        public String getDescription() {
            return this.description;
        }

        public abstract B build();

        public B build(CompoundTag nbt) {
            B buff = this.build();
            ((PylonBuff)buff).deserializeNBT(nbt);
            return buff;
        }

        protected abstract void write(JsonObject var1);

        protected abstract void read(JsonObject var1);

        protected abstract void write(CompoundTag var1);

        protected abstract void read(CompoundTag var1);

        public final JsonObject serializeJson() {
            JsonObject json = new JsonObject();
            json.addProperty("uber", Boolean.valueOf(this.uber));
            json.addProperty("color", (Number)this.color);
            json.addProperty("uberColor", (Number)this.color);
            json.addProperty("description", this.description);
            this.write(json);
            return json;
        }

        public final void deserializeJson(JsonObject json) {
            this.uber = json.get("uber").getAsBoolean();
            this.color = json.get("color").getAsInt();
            this.uberColor = json.has("uberColor") ? json.get("uberColor").getAsInt() : this.color;
            this.description = json.get("description").getAsString();
            this.read(json);
        }

        public final CompoundTag serializeNBT() {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128379_("uber", this.uber);
            nbt.m_128359_("color", Long.toHexString(Integer.toUnsignedLong(this.color)));
            nbt.m_128359_("uberColor", Long.toHexString(Integer.toUnsignedLong(this.uberColor)));
            nbt.m_128359_("description", this.description);
            this.write(nbt);
            return nbt;
        }

        public final void deserializeNBT(CompoundTag nbt) {
            this.uber = nbt.m_128471_("uber");
            this.color = (int)Long.parseLong(nbt.m_128461_("color"), 16);
            this.uberColor = nbt.m_128441_("uberColor") ? (int)Long.parseLong(nbt.m_128461_("uberColor"), 16) : this.color;
            this.description = nbt.m_128461_("description");
            this.read(nbt);
        }

        public static Config<?> fromNBT(CompoundTag nbt) {
            Config<?> config = Serializer.REGISTRY.get(nbt.m_128461_("type")).get();
            config.deserializeNBT(nbt);
            return config;
        }
    }

    public static class Serializer
    implements JsonSerializer<Config<?>>,
    JsonDeserializer<Config<?>> {
        private static final Map<String, Supplier<Config<?>>> REGISTRY = new HashMap();

        public JsonElement serialize(Config<?> value, Type type, JsonSerializationContext context) {
            return value.serializeJson();
        }

        public Config<?> deserialize(JsonElement json, Type type, JsonDeserializationContext context) throws JsonParseException {
            String key = json.getAsJsonObject().get("type").getAsString();
            Config<?> config = REGISTRY.get(key).get();
            config.deserializeJson(json.getAsJsonObject());
            return config;
        }

        static {
            REGISTRY.put("effect", EffectPylonBuff.Config::new);
            REGISTRY.put("mana", ManaPylonBuff.Config::new);
            REGISTRY.put("time", TimePylonBuff.Config::new);
            REGISTRY.put("attribute", AttributePylonBuff.Config::new);
            REGISTRY.put("stat", StatPylonBuff.Config::new);
            REGISTRY.put("potion", PotionPylonBuff.Config::new);
        }
    }
}

