/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.core.vault.stat;

import iskallia.vault.VaultMod;
import iskallia.vault.core.data.DataMap;
import iskallia.vault.core.data.adapter.vault.DirectAdapter;
import iskallia.vault.core.random.ChunkRandom;
import iskallia.vault.core.util.RegionPos;
import iskallia.vault.core.vault.Vault;
import iskallia.vault.core.vault.WorldManager;
import iskallia.vault.core.world.generator.GridGenerator;
import iskallia.vault.core.world.generator.VaultGenerator;
import iskallia.vault.core.world.generator.layout.GridLayout;
import iskallia.vault.core.world.generator.layout.VaultGridLayout;
import iskallia.vault.core.world.generator.layout.VaultLayout;
import iskallia.vault.core.world.processor.ProcessorContext;
import iskallia.vault.core.world.template.JigsawTemplate;
import iskallia.vault.core.world.template.PlacementSettings;
import iskallia.vault.core.world.template.Template;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;

public class DiscoveredRoomStat
extends DataMap<DiscoveredRoomStat, BlockPos, ResourceLocation> {
    public DiscoveredRoomStat() {
        super(new HashMap(), new DirectAdapter<BlockPos>((value, buffer, context) -> {
            if (value == null) {
                buffer.writeInt(0);
                buffer.writeInt(0);
                buffer.writeInt(0);
                return;
            }
            buffer.writeInt(value.m_123341_());
            buffer.writeInt(value.m_123342_());
            buffer.writeInt(value.m_123343_());
        }, (buffer, context) -> Optional.of(new BlockPos(buffer.readInt(), buffer.readInt(), buffer.readInt()))), new DirectAdapter<ResourceLocation>((value, buffer, context) -> {
            if (value == null) {
                buffer.writeIdentifier(VaultMod.id("empty"));
                return;
            }
            buffer.writeIdentifier((ResourceLocation)value);
        }, (buffer, context) -> Optional.of(buffer.readIdentifier())));
    }

    public Map.Entry<BlockPos, ResourceLocation> onTick(ServerPlayer player, Vault vault) {
        VaultGenerator vaultGenerator = vault.get(Vault.WORLD).get(WorldManager.GENERATOR);
        if (!(vaultGenerator instanceof GridGenerator)) {
            return null;
        }
        GridGenerator generator = (GridGenerator)vaultGenerator;
        GridLayout gridLayout = generator.get(GridGenerator.LAYOUT);
        if (!(gridLayout instanceof VaultGridLayout)) {
            return null;
        }
        VaultGridLayout layout = (VaultGridLayout)gridLayout;
        RegionPos region = RegionPos.ofBlockPos(player.m_142538_(), generator.get(GridGenerator.CELL_X), generator.get(GridGenerator.CELL_Z));
        BlockPos key = new BlockPos(region.m_123341_(), 0, region.m_123343_());
        if (this.containsKey(key)) {
            return null;
        }
        ChunkRandom random = ChunkRandom.any();
        random.setRegionSeed(vault.get(Vault.SEED), region.m_123341_(), region.m_123343_(), 1234567890L);
        PlacementSettings settings = new PlacementSettings(new ProcessorContext(vault, random)).setFlags(272);
        VaultLayout.PieceType type = layout.getType(vault, region);
        if (type != VaultLayout.PieceType.ROOM && !type.isStart()) {
            return null;
        }
        Template template = layout.getAt(vault, region, random, settings);
        if (template instanceof JigsawTemplate) {
            JigsawTemplate jigsaw = (JigsawTemplate)template;
            template = jigsaw.getRoot();
        }
        ResourceLocation id = template.getKey().getId();
        this.put(key, id);
        return new AbstractMap.SimpleEntry<BlockPos, ResourceLocation>(key, id);
    }

    public int getTotalDiscoveredRooms() {
        return this.size();
    }
}

