/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.core.vault.stat;

import iskallia.vault.VaultMod;
import iskallia.vault.core.data.DataMap;
import iskallia.vault.core.data.adapter.vault.DirectAdapter;
import iskallia.vault.core.random.ChunkRandom;
import iskallia.vault.core.util.RegionPos;
import iskallia.vault.core.vault.Vault;
import iskallia.vault.core.vault.WorldManager;
import iskallia.vault.core.world.generator.GridGenerator;
import iskallia.vault.core.world.generator.VaultGenerator;
import iskallia.vault.core.world.generator.layout.GridLayout;
import iskallia.vault.core.world.generator.layout.VaultGridLayout;
import iskallia.vault.core.world.generator.layout.VaultLayout;
import iskallia.vault.core.world.processor.ProcessorContext;
import iskallia.vault.core.world.template.PlacementSettings;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;

public class DiscoveredTunnelStat
extends DataMap<DiscoveredTunnelStat, BlockPos, ResourceLocation> {
    public DiscoveredTunnelStat() {
        super(new HashMap(), new DirectAdapter<BlockPos>((blockPos, buffer, context) -> {
            if (blockPos == null) {
                buffer.writeInt(0);
                buffer.writeInt(0);
                buffer.writeInt(0);
                return;
            }
            buffer.writeInt(blockPos.m_123341_());
            buffer.writeInt(blockPos.m_123342_());
            buffer.writeInt(blockPos.m_123343_());
        }, (buffer, context) -> Optional.of(new BlockPos(buffer.readInt(), buffer.readInt(), buffer.readInt()))), new DirectAdapter<ResourceLocation>((resourceLocation, buffer, context) -> buffer.writeIdentifier(resourceLocation == null ? VaultMod.id("empty") : resourceLocation), (buffer, context) -> Optional.of(buffer.readIdentifier())));
    }

    public Map.Entry<BlockPos, ResourceLocation> onTick(ServerPlayer player, Vault vault) {
        VaultGenerator vaultGenerator = vault.get(Vault.WORLD).get(WorldManager.GENERATOR);
        if (!(vaultGenerator instanceof GridGenerator)) {
            return null;
        }
        GridGenerator gridGenerator = (GridGenerator)vaultGenerator;
        GridLayout gridLayout = gridGenerator.get(GridGenerator.LAYOUT);
        if (!(gridLayout instanceof VaultGridLayout)) {
            return null;
        }
        VaultGridLayout vaultLayout = (VaultGridLayout)gridLayout;
        RegionPos playerRegion = RegionPos.ofBlockPos(player.m_142538_(), gridGenerator.get(GridGenerator.CELL_X), gridGenerator.get(GridGenerator.CELL_Z));
        BlockPos regionKey = new BlockPos(playerRegion.m_123341_(), 0, playerRegion.m_123343_());
        if (this.containsKey(regionKey)) {
            return null;
        }
        ChunkRandom random = ChunkRandom.any();
        random.setRegionSeed(vault.get(Vault.SEED), playerRegion.m_123341_(), playerRegion.m_123343_(), 987654321L);
        VaultLayout.PieceType pieceType = vaultLayout.getType(vault, playerRegion);
        if (pieceType != VaultLayout.PieceType.TUNNEL_X && pieceType != VaultLayout.PieceType.TUNNEL_Z) {
            return null;
        }
        new PlacementSettings(new ProcessorContext(vault, random)).setFlags(272);
        ResourceLocation id = pieceType == VaultLayout.PieceType.TUNNEL_X ? VaultMod.id("gui/map/tunnel_x") : VaultMod.id("gui/map/tunnel_z");
        this.put(regionKey, id);
        return new AbstractMap.SimpleEntry<BlockPos, ResourceLocation>(regionKey, id);
    }

    public int getTotalDiscoveredTunnels() {
        return this.size();
    }
}

