/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.core.vault.stat;

import iskallia.vault.block.DungeonDoorBlock;
import iskallia.vault.block.entity.DungeonDoorTileEntity;
import iskallia.vault.core.Version;
import iskallia.vault.core.data.DataMap;
import iskallia.vault.core.data.DataObject;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.data.adapter.basic.EnumAdapter;
import iskallia.vault.core.data.adapter.vault.DirectAdapter;
import iskallia.vault.core.data.key.FieldKey;
import iskallia.vault.core.data.key.registry.FieldRegistry;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.state.BlockState;

public class DungeonsOpenedStat
extends DataMap<DungeonsOpenedStat, String, Map<DungeonDoorBlock.Type, Integer>> {
    public DungeonsOpenedStat() {
        super(new HashMap(), new DirectAdapter<String>((value, buffer, context) -> buffer.writeString((String)value), (buffer, context) -> Optional.ofNullable(buffer.readString())), new DirectAdapter<Map>((value, buffer, context) -> {
            if (value == null) {
                buffer.writeInt(0);
                return;
            }
            buffer.writeInt(value.size());
            for (Map.Entry entry : value.entrySet()) {
                buffer.writeString(((DungeonDoorBlock.Type)((Object)((Object)entry.getKey()))).m_7912_());
                buffer.writeInt((Integer)entry.getValue());
            }
        }, (buffer, context) -> {
            int size = buffer.readInt();
            HashMap<DungeonDoorBlock.Type, Integer> map = new HashMap<DungeonDoorBlock.Type, Integer>();
            for (int i = 0; i < size; ++i) {
                DungeonDoorBlock.Type type = DungeonDoorBlock.Type.fromString(buffer.readString());
                int count = buffer.readInt();
                map.put(type, count);
            }
            return Optional.of(map);
        }));
    }

    public void onOpen(DungeonDoorTileEntity.Difficulty difficulty, BlockState state, Player player) {
        if (!(state.m_60734_() instanceof DungeonDoorBlock)) {
            return;
        }
        if (!this.containsKey(difficulty.name)) {
            this.put(difficulty.name, new HashMap());
        }
        ((Map)this.get(difficulty.name)).compute((DungeonDoorBlock.Type)((Object)state.m_61143_(DungeonDoorBlock.TYPE)), (type, count) -> count == null ? 1 : count + 1);
    }

    public int getTotal() {
        return this.values().stream().flatMap(map -> map.values().stream()).reduce(0, Integer::sum);
    }

    public static class Entry
    extends DataObject<Entry> {
        public static final FieldRegistry FIELDS = new FieldRegistry();
        public static final FieldKey<DungeonDoorBlock.Type> DUNGEON_TYPE = (FieldKey)FieldKey.of("dungeon_type", DungeonDoorBlock.Type.class).with(Version.v1_0, Adapters.ofEnum(DungeonDoorBlock.Type.class, EnumAdapter.Mode.NAME), DISK.all()).register(FIELDS);

        @Override
        public FieldRegistry getFields() {
            return FIELDS;
        }
    }
}

