/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.core.vault.stat;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import iskallia.vault.block.VaultOreBlock;
import iskallia.vault.core.Version;
import iskallia.vault.core.data.DataMap;
import iskallia.vault.core.data.DataObject;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.data.adapter.vault.CompoundAdapter;
import iskallia.vault.core.data.adapter.vault.DirectAdapter;
import iskallia.vault.core.data.key.FieldKey;
import iskallia.vault.core.data.key.registry.FieldRegistry;
import iskallia.vault.init.ModBlocks;
import java.util.HashMap;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class MinedBlocksStat
extends DataMap<MinedBlocksStat, ResourceLocation, Entry> {
    public static final BiMap<ResourceLocation, Integer> ALLOWED_BLOCKS = HashBiMap.create();

    public MinedBlocksStat() {
        super(new HashMap(), new DirectAdapter<ResourceLocation>((value, buffer, context) -> buffer.writeIntSegmented((Integer)ALLOWED_BLOCKS.get(value), 7), (buffer, context) -> Optional.ofNullable((ResourceLocation)ALLOWED_BLOCKS.inverse().get((Object)buffer.readIntSegmented(7)))), CompoundAdapter.of(Entry::new));
        ALLOWED_BLOCKS.keySet().forEach((? super T block) -> this.put(block, new Entry()));
    }

    public void onMine(BlockState state, Player player) {
        if (state.m_60734_() instanceof VaultOreBlock && !((Boolean)state.m_61143_((Property)VaultOreBlock.GENERATED)).booleanValue() && !player.m_7500_()) {
            return;
        }
        if (!this.containsKey(state.m_60734_().getRegistryName())) {
            return;
        }
        ((Entry)this.get(state.m_60734_().getRegistryName())).modify(Entry.COUNT, count -> count + 1);
    }

    static {
        ALLOWED_BLOCKS.put((Object)ModBlocks.TREASURE_SAND.getRegistryName(), (Object)0);
        ALLOWED_BLOCKS.put((Object)ModBlocks.TREASURE_SAND.getRegistryName(), (Object)1);
        ALLOWED_BLOCKS.put((Object)ModBlocks.COIN_PILE.getRegistryName(), (Object)2);
        ALLOWED_BLOCKS.put((Object)ModBlocks.ALEXANDRITE_ORE.getRegistryName(), (Object)3);
        ALLOWED_BLOCKS.put((Object)ModBlocks.BENITOITE_ORE.getRegistryName(), (Object)4);
        ALLOWED_BLOCKS.put((Object)ModBlocks.LARIMAR_ORE.getRegistryName(), (Object)5);
        ALLOWED_BLOCKS.put((Object)ModBlocks.BLACK_OPAL_ORE.getRegistryName(), (Object)6);
        ALLOWED_BLOCKS.put((Object)ModBlocks.PAINITE_ORE.getRegistryName(), (Object)7);
        ALLOWED_BLOCKS.put((Object)ModBlocks.ISKALLIUM_ORE.getRegistryName(), (Object)8);
        ALLOWED_BLOCKS.put((Object)ModBlocks.GORGINITE_ORE.getRegistryName(), (Object)9);
        ALLOWED_BLOCKS.put((Object)ModBlocks.SPARKLETINE_ORE.getRegistryName(), (Object)10);
        ALLOWED_BLOCKS.put((Object)ModBlocks.WUTODIE_ORE.getRegistryName(), (Object)11);
        ALLOWED_BLOCKS.put((Object)ModBlocks.ASHIUM_ORE.getRegistryName(), (Object)12);
        ALLOWED_BLOCKS.put((Object)ModBlocks.BOMIGNITE_ORE.getRegistryName(), (Object)13);
        ALLOWED_BLOCKS.put((Object)ModBlocks.TUBIUM_ORE.getRegistryName(), (Object)15);
        ALLOWED_BLOCKS.put((Object)ModBlocks.UPALINE_ORE.getRegistryName(), (Object)16);
        ALLOWED_BLOCKS.put((Object)ModBlocks.PUFFIUM_ORE.getRegistryName(), (Object)17);
        ALLOWED_BLOCKS.put((Object)ModBlocks.PETZANITE_ORE.getRegistryName(), (Object)18);
        ALLOWED_BLOCKS.put((Object)ModBlocks.XENIUM_ORE.getRegistryName(), (Object)19);
        ALLOWED_BLOCKS.put((Object)ModBlocks.ECHO_ORE.getRegistryName(), (Object)20);
    }

    public static class Entry
    extends DataObject<Entry> {
        public static final FieldRegistry FIELDS = new FieldRegistry();
        public static final FieldKey<Integer> COUNT = (FieldKey)FieldKey.of("count", Integer.class).with(Version.v1_0, Adapters.INT_SEGMENTED_7, DISK.all()).register(FIELDS);

        public Entry() {
            this.set(COUNT, 0);
        }

        @Override
        public FieldRegistry getFields() {
            return FIELDS;
        }
    }
}

