/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.core.vault.stat;

import iskallia.vault.core.Version;
import iskallia.vault.core.data.DataMap;
import iskallia.vault.core.data.DataObject;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.data.adapter.vault.CompoundAdapter;
import iskallia.vault.core.data.key.FieldKey;
import iskallia.vault.core.data.key.registry.FieldRegistry;
import iskallia.vault.entity.champion.ChampionLogic;
import java.util.HashMap;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;

public class MobsStat
extends DataMap<MobsStat, ResourceLocation, Entry> {
    public MobsStat() {
        super(new HashMap(), Adapters.IDENTIFIER, CompoundAdapter.of(Entry::new));
    }

    public void onKilled(Entity entity) {
        this.computeIfAbsent(entity.m_6095_().getRegistryName(), v -> new Entry()).modify(Entry.KILLED, count -> count + 1);
        if (ChampionLogic.isChampion(entity)) {
            if (!this.computeIfAbsent(entity.m_6095_().getRegistryName(), v -> new Entry()).has(Entry.KILLED_CHAMPIONS)) {
                this.computeIfAbsent(entity.m_6095_().getRegistryName(), v -> new Entry()).set(Entry.KILLED_CHAMPIONS, 0);
            }
            this.computeIfAbsent(entity.m_6095_().getRegistryName(), v -> new Entry()).modify(Entry.KILLED_CHAMPIONS, count -> count + 1);
        }
    }

    public void onDamageDealt(Entity entity, float amount) {
        this.computeIfAbsent(entity.m_6095_().getRegistryName(), v -> new Entry()).modify(Entry.DAMAGE_DEALT, damage -> Float.valueOf(damage.floatValue() + amount));
    }

    public void onDamageReceived(Entity entity, float amount) {
        this.computeIfAbsent(entity.m_6095_().getRegistryName(), v -> new Entry()).modify(Entry.DAMAGE_RECEIVED, damage -> Float.valueOf(damage.floatValue() + amount));
    }

    public static class Entry
    extends DataObject<Entry> {
        public static final FieldRegistry FIELDS = new FieldRegistry();
        public static final FieldKey<Integer> KILLED = (FieldKey)FieldKey.of("killed", Integer.class).with(Version.v1_0, Adapters.INT_SEGMENTED_7, DISK.all().or(CLIENT.all())).register(FIELDS);
        public static final FieldKey<Float> DAMAGE_DEALT = (FieldKey)FieldKey.of("damage_dealt", Float.class).with(Version.v1_0, Adapters.FLOAT, DISK.all().or(CLIENT.all())).register(FIELDS);
        public static final FieldKey<Float> DAMAGE_RECEIVED = (FieldKey)FieldKey.of("damage_received", Float.class).with(Version.v1_0, Adapters.FLOAT, DISK.all().or(CLIENT.all())).register(FIELDS);
        public static final FieldKey<Integer> KILLED_CHAMPIONS = (FieldKey)FieldKey.of("killed_champions", Integer.class).with(Version.v1_32, Adapters.INT_SEGMENTED_7, DISK.all()).register(FIELDS);

        public Entry() {
            this.set(KILLED, 0);
            this.set(DAMAGE_DEALT, Float.valueOf(0.0f));
            this.set(DAMAGE_RECEIVED, Float.valueOf(0.0f));
            this.set(KILLED_CHAMPIONS, 0);
        }

        @Override
        public FieldRegistry getFields() {
            return FIELDS;
        }
    }
}

