/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.core.vault.stat;

import iskallia.vault.VaultMod;
import iskallia.vault.core.data.DataMap;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.data.adapter.array.ArrayAdapter;
import iskallia.vault.core.data.adapter.vault.DirectAdapter;
import iskallia.vault.core.data.sync.context.SyncContext;
import iskallia.vault.core.net.BitBuffer;
import iskallia.vault.core.random.ChunkRandom;
import iskallia.vault.core.util.RegionPos;
import iskallia.vault.core.vault.Vault;
import iskallia.vault.core.vault.WorldManager;
import iskallia.vault.core.world.generator.GridGenerator;
import iskallia.vault.core.world.generator.VaultGenerator;
import iskallia.vault.core.world.generator.layout.GridLayout;
import iskallia.vault.core.world.generator.layout.VaultGridLayout;
import iskallia.vault.core.world.generator.layout.VaultLayout;
import iskallia.vault.core.world.processor.ProcessorContext;
import iskallia.vault.core.world.template.JigsawTemplate;
import iskallia.vault.core.world.template.PlacementSettings;
import iskallia.vault.core.world.template.Template;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;

public class OldRoomStats
extends DataMap<OldRoomStats, ResourceLocation, Integer> {
    private Set<BlockPos> discoveredRooms = new HashSet<BlockPos>();
    public static ArrayAdapter<BlockPos> POSITIONS = Adapters.ofArray(BlockPos[]::new, Adapters.BLOCK_POS);

    public OldRoomStats() {
        super(new HashMap(), new DirectAdapter<ResourceLocation>((value, buffer, context) -> buffer.writeIdentifier(value == null ? VaultMod.id("empty") : value), (buffer, context) -> Optional.ofNullable(buffer.readIdentifier())), new DirectAdapter<Integer>((value, buffer, context) -> buffer.writeInt(value == null ? 0 : value), (buffer, context) -> Optional.of(buffer.readInt())));
    }

    public void onTick(ServerPlayer player, Vault vault) {
        VaultGenerator vaultGenerator = vault.get(Vault.WORLD).get(WorldManager.GENERATOR);
        if (!(vaultGenerator instanceof GridGenerator)) {
            return;
        }
        GridGenerator generator = (GridGenerator)vaultGenerator;
        GridLayout gridLayout = generator.get(GridGenerator.LAYOUT);
        if (!(gridLayout instanceof VaultGridLayout)) {
            return;
        }
        VaultGridLayout layout = (VaultGridLayout)gridLayout;
        RegionPos region = RegionPos.ofBlockPos(player.m_142538_(), generator.get(GridGenerator.CELL_X), generator.get(GridGenerator.CELL_Z));
        if (this.discoveredRooms.contains(new BlockPos(region.m_123341_(), 0, region.m_123343_()))) {
            return;
        }
        ChunkRandom random = ChunkRandom.any();
        random.setRegionSeed(vault.get(Vault.SEED), region.m_123341_(), region.m_123343_(), 1234567890L);
        PlacementSettings settings = new PlacementSettings(new ProcessorContext(vault, random)).setFlags(272);
        VaultLayout.PieceType type = layout.getType(vault, region);
        if (type != VaultLayout.PieceType.ROOM) {
            return;
        }
        Template template = layout.getAt(vault, region, random, settings);
        if (template instanceof JigsawTemplate) {
            JigsawTemplate jigsaw = (JigsawTemplate)template;
            template = jigsaw.getRoot();
        }
        this.put(template.getKey().getId(), this.getOrDefault(template.getKey().getId(), 0) + 1);
        this.discoveredRooms.add(new BlockPos(region.m_123341_(), 0, region.m_123343_()));
    }

    @Override
    public OldRoomStats write(BitBuffer buffer, SyncContext context) {
        POSITIONS.writeBits((T[])((BlockPos[])this.discoveredRooms.toArray(BlockPos[]::new)), buffer, (Object)context);
        return (OldRoomStats)super.write(buffer, context);
    }

    @Override
    public OldRoomStats read(BitBuffer buffer, SyncContext context) {
        this.discoveredRooms = Set.of(POSITIONS.readBits(buffer, context).orElse(new BlockPos[0]));
        return (OldRoomStats)super.read(buffer, context);
    }

    public int getTotalDiscoveredRooms() {
        return this.values().stream().mapToInt(value -> value).sum();
    }
}

