/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.core.vault.stat;

import iskallia.vault.block.CoinPileBlock;
import iskallia.vault.block.DungeonDoorBlock;
import iskallia.vault.block.VaultChestBlock;
import iskallia.vault.core.Version;
import iskallia.vault.core.data.DataObject;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.data.adapter.basic.EnumAdapter;
import iskallia.vault.core.data.adapter.vault.CompoundAdapter;
import iskallia.vault.core.data.compound.ItemStackList;
import iskallia.vault.core.data.key.FieldKey;
import iskallia.vault.core.data.key.registry.FieldRegistry;
import iskallia.vault.core.event.CommonEvents;
import iskallia.vault.core.vault.Vault;
import iskallia.vault.core.vault.VaultUtils;
import iskallia.vault.core.vault.player.Completion;
import iskallia.vault.core.vault.stat.ChestStat;
import iskallia.vault.core.vault.stat.DiscoveredRoomStat;
import iskallia.vault.core.vault.stat.DiscoveredTunnelStat;
import iskallia.vault.core.vault.stat.DungeonsOpenedStat;
import iskallia.vault.core.vault.stat.MinedBlocksStat;
import iskallia.vault.core.vault.stat.MobsStat;
import iskallia.vault.core.vault.stat.OldRoomStats;
import iskallia.vault.core.vault.stat.VaultChestType;
import iskallia.vault.core.world.storage.VirtualWorld;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.init.ModGameRules;
import iskallia.vault.init.ModItems;
import iskallia.vault.item.VaultCompassMode;
import iskallia.vault.task.source.EntityTaskSource;
import iskallia.vault.task.source.TaskSource;
import iskallia.vault.util.VaultRarity;
import iskallia.vault.world.data.VaultPartyData;
import iskallia.vault.world.data.VaultPlayerCompassData;
import it.unimi.dsi.fastutil.objects.Object2FloatMap;
import it.unimi.dsi.fastutil.objects.Object2FloatOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.server.ServerLifecycleHooks;

public class StatCollector
extends DataObject<StatCollector> {
    public static final FieldRegistry FIELDS = new FieldRegistry();
    public static final FieldKey<ChestStat.List> CHESTS = (FieldKey)FieldKey.of("chests", ChestStat.List.class).with(Version.v1_0, CompoundAdapter.of(ChestStat.List::new), DISK.all()).register(FIELDS);
    public static final FieldKey<MinedBlocksStat> MINED_BLOCKS = (FieldKey)FieldKey.of("mined_blocks", MinedBlocksStat.class).with(Version.v1_0, CompoundAdapter.of(MinedBlocksStat::new), DISK.all()).register(FIELDS);
    public static final FieldKey<Integer> TREASURE_ROOMS_OPENED = (FieldKey)FieldKey.of("treasure_rooms_opened", Integer.class).with(Version.v1_0, Adapters.INT_SEGMENTED_7, DISK.all()).register(FIELDS);
    public static final FieldKey<MobsStat> MOBS = (FieldKey)FieldKey.of("mobs", MobsStat.class).with(Version.v1_0, CompoundAdapter.of(MobsStat::new), DISK.all().or(CLIENT.all())).register(FIELDS);
    public static final FieldKey<Completion> COMPLETION = (FieldKey)FieldKey.of("completion", Completion.class).with(Version.v1_0, Adapters.ofEnum(Completion.class, EnumAdapter.Mode.ORDINAL), DISK.all()).register(FIELDS);
    public static final FieldKey<Float> BONUS_EXP_MULTIPLIER = (FieldKey)FieldKey.of("exp_multiplier", Float.class).with(Version.v1_0, Adapters.FLOAT, DISK.all().or(CLIENT.all())).register(FIELDS);
    public static final FieldKey<Float> OBJECTIVE_EXP_MULTIPLIER = (FieldKey)FieldKey.of("objective_exp_multiplier", Float.class).with(Version.v1_14, Adapters.FLOAT, DISK.all().or(CLIENT.all())).register(FIELDS);
    public static final FieldKey<ItemStackList> REWARD = (FieldKey)FieldKey.of("reward", ItemStackList.class).with(Version.v1_0, CompoundAdapter.of(ItemStackList::createLegacy), DISK.all()).register(FIELDS);
    public static final FieldKey<Integer> VENDOORS_OPENED = (FieldKey)FieldKey.of("vendors_opened", Integer.class).with(Version.v1_32, Adapters.INT_SEGMENTED_7, DISK.all()).register(FIELDS);
    public static final FieldKey<Integer> GOLD_SPENT = (FieldKey)FieldKey.of("gold_spent", Integer.class).with(Version.v1_32, Adapters.INT_SEGMENTED_7, DISK.all()).register(FIELDS);
    public static final FieldKey<Integer> DUNGEON_ALTARS_FOUND = (FieldKey)FieldKey.of("dungeon_altars_found", Integer.class).with(Version.v1_32, Adapters.INT_SEGMENTED_7, DISK.all()).register(FIELDS);
    public static final FieldKey<OldRoomStats> OLD_OMEGA_ROOMS = (FieldKey)FieldKey.of("omega_rooms_found", OldRoomStats.class).with(Version.v1_32, CompoundAdapter.of(OldRoomStats::new), DISK.all()).register(FIELDS);
    public static final FieldKey<DungeonsOpenedStat> DUNGEONS_OPENED = (FieldKey)FieldKey.of("dungeons_opened", DungeonsOpenedStat.class).with(Version.v1_32, CompoundAdapter.of(DungeonsOpenedStat::new), DISK.all()).register(FIELDS);
    public static final FieldKey<Integer> SOUL_SHARDS_COLLECTED = (FieldKey)FieldKey.of("soul_shards_collected", Integer.class).with(Version.v1_32, Adapters.INT_SEGMENTED_7, DISK.all()).register(FIELDS);
    public static final FieldKey<Integer> USED_PYLONS = (FieldKey)FieldKey.of("used_pylons", Integer.class).with(Version.v1_32, Adapters.INT_SEGMENTED_7, DISK.all()).register(FIELDS);
    public static final FieldKey<DiscoveredRoomStat> ROOMS_DISCOVERED = (FieldKey)FieldKey.of("discovered_rooms", DiscoveredRoomStat.class).with(Version.v1_33, CompoundAdapter.of(DiscoveredRoomStat::new), DISK.all().or(CLIENT.all())).register(FIELDS);
    public static final FieldKey<Integer> BROKEN_PYLONS = (FieldKey)FieldKey.of("broken_pylons", Integer.class).with(Version.v1_33, Adapters.INT_SEGMENTED_7, DISK.all()).register(FIELDS);
    public static final FieldKey<Integer> GOD_ALTAR_COMPLETIONS = (FieldKey)FieldKey.of("god_altar_completions", Integer.class).with(Version.v1_34, Adapters.INT_SEGMENTED_7, DISK.all()).register(FIELDS);
    public static final FieldKey<Integer> GOD_ALTAR_FAILS = (FieldKey)FieldKey.of("god_altar_fails", Integer.class).with(Version.v1_34, Adapters.INT_SEGMENTED_7, DISK.all()).register(FIELDS);
    public static final FieldKey<DiscoveredTunnelStat> DISCOVERED_TUNNELS = (FieldKey)FieldKey.of("discovered_tunnels", DiscoveredTunnelStat.class).with(Version.v1_35, CompoundAdapter.of(DiscoveredTunnelStat::new), DISK.all().or(CLIENT.all())).register(FIELDS);
    public static final FieldKey<Integer> PHOENIX_GEAR_USES = (FieldKey)FieldKey.of("phoenix_gear_uses", Integer.class).with(Version.v1_39, Adapters.INT_SEGMENTED_7, DISK.all()).register(FIELDS);

    public StatCollector() {
        this.set(CHESTS, new ChestStat.List());
        this.set(MINED_BLOCKS, new MinedBlocksStat());
        this.set(TREASURE_ROOMS_OPENED, 0);
        this.set(MOBS, new MobsStat());
        this.set(COMPLETION, Completion.COMPLETED);
        this.set(BONUS_EXP_MULTIPLIER, Float.valueOf(1.0f));
        this.set(OBJECTIVE_EXP_MULTIPLIER, Float.valueOf(1.0f));
        this.set(REWARD, ItemStackList.createLegacy());
        this.set(VENDOORS_OPENED, 0);
        this.set(GOLD_SPENT, 0);
        this.set(DUNGEON_ALTARS_FOUND, 0);
        this.set(ROOMS_DISCOVERED, new DiscoveredRoomStat());
        this.set(DUNGEONS_OPENED, new DungeonsOpenedStat());
        this.set(SOUL_SHARDS_COLLECTED, 0);
        this.set(USED_PYLONS, 0);
        this.set(BROKEN_PYLONS, 0);
        this.set(GOD_ALTAR_COMPLETIONS, 0);
        this.set(GOD_ALTAR_FAILS, 0);
        this.set(DISCOVERED_TUNNELS, new DiscoveredTunnelStat());
        this.set(PHOENIX_GEAR_USES, 0);
    }

    @Override
    public FieldRegistry getFields() {
        return FIELDS;
    }

    public void initServer(VirtualWorld world, Vault vault, UUID uuid) {
        CommonEvents.CHEST_LOOT_GENERATION.post().register(this, data -> {
            if (!data.getPlayer().m_142081_().equals(uuid)) {
                return;
            }
            Block block = data.getState().m_60734_();
            if (!(block instanceof VaultChestBlock)) {
                return;
            }
            VaultChestBlock chest = (VaultChestBlock)block;
            this.get(CHESTS).add(ChestStat.ofLoot(chest.getType(), data.getRarity()));
        });
        CommonEvents.PLAYER_MINE.register((Object)this, EventPriority.LOW, event -> {
            if (!event.getPlayer().m_142081_().equals(uuid)) {
                return;
            }
            if (event.getState().m_60734_() instanceof CoinPileBlock && (Integer)event.getState().m_61143_((Property)CoinPileBlock.SIZE) != 1) {
                return;
            }
            this.get(MINED_BLOCKS).onMine(event.getState(), event.getPlayer());
        });
        CommonEvents.TREASURE_ROOM_OPEN.register(this, data -> {
            if (!data.getPlayer().m_142081_().equals(uuid)) {
                return;
            }
            this.modify(TREASURE_ROOMS_OPENED, count -> count + 1);
            Player patt8835$temp = data.getPlayer();
            if (patt8835$temp instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)patt8835$temp;
                VaultPlayerCompassData.addProgress(player, VaultCompassMode.TREASURE_DOOR, 1);
            }
        });
        CommonEvents.VENDOOR_ROOM_OPEN.register(this, data -> {
            if (!data.getPlayer().m_142081_().equals(uuid)) {
                return;
            }
            this.modify(VENDOORS_OPENED, count -> count + 1);
        });
        CommonEvents.DUNGEON_ROOM_OPEN.register(this, data -> {
            if (!data.getPlayer().m_142081_().equals(uuid)) {
                return;
            }
            this.ifPresent(DUNGEONS_OPENED, dungeons -> dungeons.onOpen(data.getDifficulty(), data.getState(), data.getPlayer()));
            Player patt9490$temp = data.getPlayer();
            if (patt9490$temp instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)patt9490$temp;
                VaultPlayerCompassData.addProgress(player, VaultCompassMode.DUNGEON_DOOR, 1);
            }
        });
        CommonEvents.ENTITY_DEATH.register(this, event -> {
            Entity source = event.getSource().m_7639_();
            if (source == null || !source.m_142081_().equals(uuid) || event.getEntity().f_19853_ != world) {
                return;
            }
            this.get(MOBS).onKilled(event.getEntity());
        });
        CommonEvents.ENTITY_DAMAGE.register(this, event -> {
            Entity source = event.getSource().m_7639_();
            if (source == null || !source.m_142081_().equals(uuid)) {
                return;
            }
            if (event.getEntity().m_183503_() != world) {
                return;
            }
            this.get(MOBS).onDamageDealt(event.getEntity(), event.getAmount());
        });
        CommonEvents.ENTITY_DAMAGE.register(this, event -> {
            Entity source = event.getSource().m_7639_();
            if (source == null || !event.getEntity().m_142081_().equals(uuid)) {
                return;
            }
            if (event.getEntity().m_183503_() != world) {
                return;
            }
            this.get(MOBS).onDamageReceived(source, event.getAmount());
        });
        CommonEvents.SHOP_PEDESTAL_PURCHASE_ITEM.register(this, event -> {
            if (!event.getPlayer().m_142081_().equals(uuid)) {
                return;
            }
            if (!this.has(GOLD_SPENT)) {
                this.set(GOLD_SPENT, 0);
            }
            this.modify(GOLD_SPENT, count -> count + event.getCost().m_41613_());
        });
        CommonEvents.LISTENER_TICK.register(this, event -> {
            if (event.getListener().getPlayer().isEmpty() || !event.getListener().getPlayer().get().m_142081_().equals(uuid)) {
                return;
            }
            if (event.getListener().getPlayer().get().f_19853_ != world) {
                return;
            }
            if (event.getListener().getPlayer().get().m_6084_()) {
                Map.Entry<BlockPos, ResourceLocation> newTunnel;
                boolean shareMap;
                Map.Entry<BlockPos, ResourceLocation> newRoom = this.get(ROOMS_DISCOVERED).onTick(event.getListener().getPlayer().get(), event.getVault());
                boolean bl = shareMap = world.m_46469_().m_46207_(ModGameRules.PARTY_MAP_SHARING) || VaultUtils.isPvPVault(event.getVault());
                if (newRoom != null && shareMap) {
                    this.shareDiscoveredRoom(event.getVault(), event.getListener().getPlayer().get(), newRoom);
                }
                if (newRoom != null) {
                    ResourceLocation id = newRoom.getValue();
                    ServerPlayer player = event.getListener().getPlayer().get();
                    String path = id.m_135815_();
                    if (path.contains("/ore")) {
                        VaultPlayerCompassData.addProgress(player, VaultCompassMode.ORE_ROOM, 1);
                    } else if (path.contains("/challenge")) {
                        VaultPlayerCompassData.addProgress(player, VaultCompassMode.CHALLENGE_ROOM, 1);
                    }
                }
                if (this.get(DISCOVERED_TUNNELS) != null && (newTunnel = this.get(DISCOVERED_TUNNELS).onTick(event.getListener().getPlayer().get(), event.getVault())) != null && shareMap) {
                    this.shareDiscoveredTunnel(event.getVault(), event.getListener().getPlayer().get(), newTunnel);
                }
            }
        });
        CommonEvents.ENTITY_DROPS.register(this, event -> {
            int shardCount;
            Entity patt13035$temp = event.getSource().m_7639_();
            if (!(patt13035$temp instanceof ServerPlayer)) {
                return;
            }
            ServerPlayer player = (ServerPlayer)patt13035$temp;
            if (player.m_183503_() != world) {
                return;
            }
            if (!this.has(SOUL_SHARDS_COLLECTED)) {
                this.set(SOUL_SHARDS_COLLECTED, 0);
            }
            if ((shardCount = event.getDrops().stream().map(ItemEntity::m_32055_).filter(stack -> stack.m_41720_() == ModItems.SOUL_SHARD).reduce(0, (sum, itemStack) -> sum + itemStack.m_41613_(), Integer::sum).intValue()) > 0) {
                this.modify(SOUL_SHARDS_COLLECTED, count -> count + shardCount);
            }
        });
        CommonEvents.USE_PYLON.register(this, event -> {
            if (!event.getPlayer().m_142081_().equals(uuid)) {
                return;
            }
            if (event.getPlayer().m_183503_() != world) {
                return;
            }
            if (!this.has(USED_PYLONS)) {
                this.set(USED_PYLONS, 0);
            }
            this.modify(USED_PYLONS, count -> count + 1);
        });
        CommonEvents.BREAK_PYLON.register(this, event -> {
            if (!event.getPlayer().m_142081_().equals(uuid)) {
                return;
            }
            if (event.getPlayer().m_183503_() != world) {
                return;
            }
            if (!this.has(BROKEN_PYLONS)) {
                this.set(BROKEN_PYLONS, 0);
            }
            this.modify(BROKEN_PYLONS, count -> count + 1);
        });
        CommonEvents.MODIFIER_DISCOVERY.register(this, event -> {
            if (!event.getPlayer().m_142081_().equals(uuid)) {
                return;
            }
            if (event.getPlayer().m_183503_() != world) {
                return;
            }
            if (!this.has(DUNGEON_ALTARS_FOUND)) {
                this.set(DUNGEON_ALTARS_FOUND, 0);
            }
            this.modify(DUNGEON_ALTARS_FOUND, count -> count + 1);
        });
        CommonEvents.GOD_ALTAR_EVENT.register(this, event -> {
            TaskSource patt15014$temp = event.getContext().getSource();
            if (!(patt15014$temp instanceof EntityTaskSource)) {
                return;
            }
            EntityTaskSource entitySource = (EntityTaskSource)patt15014$temp;
            if (!entitySource.matches(uuid)) {
                return;
            }
            if (event.getVault().get(Vault.ID) != vault.get(Vault.ID)) {
                return;
            }
            if (event.isCompleted()) {
                if (!this.has(GOD_ALTAR_COMPLETIONS)) {
                    this.set(GOD_ALTAR_COMPLETIONS, 0);
                }
                this.modify(GOD_ALTAR_COMPLETIONS, count -> count + 1);
                ServerPlayer player = ServerLifecycleHooks.getCurrentServer().m_6846_().m_11259_(uuid);
                if (player != null) {
                    VaultPlayerCompassData.addProgress(player, VaultCompassMode.GOD_ALTAR, 1);
                }
            } else {
                if (!this.has(GOD_ALTAR_FAILS)) {
                    this.set(GOD_ALTAR_FAILS, 0);
                }
                this.modify(GOD_ALTAR_FAILS, count -> count + 1);
            }
        });
    }

    public void releaseServer() {
        CommonEvents.release(this);
    }

    public int getLootedChests(VaultChestType type, VaultRarity rarity) {
        return (int)this.get(CHESTS).stream().filter(stat -> !stat.has(ChestStat.TRAPPED) && stat.get(ChestStat.TYPE) == type && stat.get(ChestStat.RARITY) == rarity).count();
    }

    public int getTrappedChests(VaultChestType type) {
        return (int)this.get(CHESTS).stream().filter(stat -> stat.has(ChestStat.TRAPPED) && stat.get(ChestStat.TYPE) == type).count();
    }

    public Object2IntMap<ResourceLocation> getMinedBlocks() {
        Object2IntOpenHashMap result = new Object2IntOpenHashMap();
        this.get(MINED_BLOCKS).forEach((arg_0, arg_1) -> StatCollector.lambda$getMinedBlocks$29((Object2IntMap)result, arg_0, arg_1));
        return result;
    }

    public float getExpMultiplier() {
        return this.get(BONUS_EXP_MULTIPLIER).floatValue();
    }

    public List<ItemStack> getReward() {
        return this.get(REWARD).stream().toList();
    }

    public int getTreasureRoomsOpened() {
        return this.get(TREASURE_ROOMS_OPENED);
    }

    public int getVendoorRoomsOpened() {
        return this.has(VENDOORS_OPENED) ? this.get(VENDOORS_OPENED) : 0;
    }

    public int getDungeonAltarsFound() {
        return this.has(DUNGEON_ALTARS_FOUND) ? this.get(DUNGEON_ALTARS_FOUND) : 0;
    }

    public int getGoldSpent() {
        return this.has(GOLD_SPENT) ? this.get(GOLD_SPENT) : 0;
    }

    public Map<DungeonDoorBlock.Type, Integer> getDungeonsOpened(String difficulty) {
        return this.has(DUNGEONS_OPENED) ? (Map)this.get(DUNGEONS_OPENED).get(difficulty) : new HashMap<DungeonDoorBlock.Type, Integer>(){
            {
                for (DungeonDoorBlock.Type type : DungeonDoorBlock.Type.values()) {
                    this.put(type, 0);
                }
            }
        };
    }

    public int getTotalDungeonsOpened() {
        return this.has(DUNGEONS_OPENED) ? this.get(DUNGEONS_OPENED).getTotal() : 0;
    }

    public Map<String, Map<DungeonDoorBlock.Type, Integer>> getDungeonsOpened() {
        return this.has(DUNGEONS_OPENED) ? (Map)this.get(DUNGEONS_OPENED) : new HashMap();
    }

    public int getDungeonsOpened(String difficulty, DungeonDoorBlock.Type type) {
        return this.getDungeonsOpened(difficulty).getOrDefault((Object)type, 0);
    }

    public Object2IntMap<ResourceLocation> getEntitiesKilled() {
        Object2IntOpenHashMap result = new Object2IntOpenHashMap();
        this.ifPresent(MOBS, arg_0 -> StatCollector.lambda$getEntitiesKilled$31((Object2IntMap)result, arg_0));
        return result;
    }

    public Object2FloatMap<ResourceLocation> getDamageDealt() {
        Object2FloatOpenHashMap result = new Object2FloatOpenHashMap();
        this.ifPresent(MOBS, arg_0 -> StatCollector.lambda$getDamageDealt$33((Object2FloatMap)result, arg_0));
        return result;
    }

    public Object2FloatMap<ResourceLocation> getDamageReceived() {
        Object2FloatOpenHashMap result = new Object2FloatOpenHashMap();
        this.ifPresent(MOBS, arg_0 -> StatCollector.lambda$getDamageReceived$35((Object2FloatMap)result, arg_0));
        return result;
    }

    public Object2IntMap<ResourceLocation> getChampionsKilled() {
        Object2IntOpenHashMap result = new Object2IntOpenHashMap();
        this.ifPresent(MOBS, arg_0 -> StatCollector.lambda$getChampionsKilled$37((Object2IntMap)result, arg_0));
        return result;
    }

    public int getCollectedSoulShards() {
        return this.has(SOUL_SHARDS_COLLECTED) ? this.get(SOUL_SHARDS_COLLECTED) : 0;
    }

    public int getExperienceWithoutMultiplier(Vault vault) {
        int objectiveExp = ModConfigs.VAULT_STATS.getCompletionExperience(vault, this);
        int statsExp = ModConfigs.VAULT_STATS.getStatsExperience(this);
        return objectiveExp + statsExp;
    }

    public int getStatsExperience(Vault vault) {
        return ModConfigs.VAULT_STATS.getStatsExperience(this);
    }

    public int getExperience(Vault vault) {
        int objectiveExp = ModConfigs.VAULT_STATS.getCompletionExperience(vault, this);
        int statsExp = ModConfigs.VAULT_STATS.getStatsExperience(this);
        return (int)((float)objectiveExp * this.getOr(OBJECTIVE_EXP_MULTIPLIER, this.get(BONUS_EXP_MULTIPLIER)).floatValue() + (float)statsExp * this.get(BONUS_EXP_MULTIPLIER).floatValue());
    }

    public Completion getCompletion() {
        return this.get(COMPLETION);
    }

    public int getPylonsUsed() {
        return this.has(USED_PYLONS) ? this.get(USED_PYLONS) : 0;
    }

    public int getPylonsBroken() {
        return this.has(BROKEN_PYLONS) ? this.get(BROKEN_PYLONS) : 0;
    }

    public int getTotalDiscoveredRooms() {
        return this.has(ROOMS_DISCOVERED) ? this.get(ROOMS_DISCOVERED).getTotalDiscoveredRooms() : 0;
    }

    public int getTotalDiscoveredRoomsExcludingStart() {
        return this.has(ROOMS_DISCOVERED) ? this.get(ROOMS_DISCOVERED).getTotalDiscoveredRooms() - 1 : 0;
    }

    public Map<BlockPos, ResourceLocation> getRoomsDiscovered() {
        return this.has(ROOMS_DISCOVERED) ? (Map)this.get(ROOMS_DISCOVERED) : new HashMap();
    }

    public int getTotalDiscoveredTunnels() {
        return this.has(DISCOVERED_TUNNELS) ? this.get(DISCOVERED_TUNNELS).getTotalDiscoveredTunnels() : 0;
    }

    public Map<BlockPos, ResourceLocation> getTunnelsDiscovered() {
        return this.has(DISCOVERED_TUNNELS) ? (Map)this.get(DISCOVERED_TUNNELS) : new HashMap();
    }

    private void shareDiscoveredRoom(Vault vault, ServerPlayer discoverer, Map.Entry<BlockPos, ResourceLocation> entry) {
        if (VaultUtils.isPvPVault(vault)) {
            for (Map.Entry member : vault.get(Vault.STATS).getMap().entrySet()) {
                DiscoveredRoomStat rooms;
                if (((UUID)member.getKey()).equals(discoverer.m_142081_()) || (rooms = ((StatCollector)member.getValue()).get(ROOMS_DISCOVERED)).containsKey(entry.getKey())) continue;
                rooms.put(entry.getKey(), entry.getValue());
            }
        } else {
            VaultPartyData.get(discoverer.m_20194_()).getParty(discoverer.m_142081_()).ifPresent(party -> {
                for (UUID memberId : party.getMembers()) {
                    DiscoveredRoomStat rooms;
                    StatCollector memberStats;
                    if (memberId.equals(discoverer.m_142081_()) || (memberStats = (StatCollector)vault.get(Vault.STATS).getMap().get(memberId)) == null || (rooms = memberStats.get(ROOMS_DISCOVERED)).containsKey(entry.getKey())) continue;
                    rooms.put((BlockPos)entry.getKey(), (ResourceLocation)entry.getValue());
                }
            });
        }
    }

    private void shareDiscoveredTunnel(Vault vault, ServerPlayer discoverer, Map.Entry<BlockPos, ResourceLocation> entry) {
        if (VaultUtils.isPvPVault(vault)) {
            for (Map.Entry member : vault.get(Vault.STATS).getMap().entrySet()) {
                DiscoveredTunnelStat tunnels;
                if (((UUID)member.getKey()).equals(discoverer.m_142081_()) || (tunnels = ((StatCollector)member.getValue()).get(DISCOVERED_TUNNELS)).containsKey(entry.getKey())) continue;
                tunnels.put(entry.getKey(), entry.getValue());
            }
        } else {
            VaultPartyData.get(discoverer.m_20194_()).getParty(discoverer.m_142081_()).ifPresent(party -> {
                for (UUID memberId : party.getMembers()) {
                    DiscoveredTunnelStat tunnels;
                    StatCollector memberStats;
                    if (memberId.equals(discoverer.m_142081_()) || (memberStats = (StatCollector)vault.get(Vault.STATS).getMap().get(memberId)) == null || (tunnels = memberStats.get(DISCOVERED_TUNNELS)).containsKey(entry.getKey())) continue;
                    tunnels.put((BlockPos)entry.getKey(), (ResourceLocation)entry.getValue());
                }
            });
        }
    }

    public int getPhoenixGearUses() {
        return this.has(PHOENIX_GEAR_USES) ? this.get(PHOENIX_GEAR_USES) : 0;
    }

    private static /* synthetic */ void lambda$getChampionsKilled$37(Object2IntMap result, MobsStat mobsStat) {
        mobsStat.forEach((id, entry) -> result.put(id, entry.has(MobsStat.Entry.KILLED_CHAMPIONS) ? entry.get(MobsStat.Entry.KILLED_CHAMPIONS) : 0));
    }

    private static /* synthetic */ void lambda$getDamageReceived$35(Object2FloatMap result, MobsStat mobsStat) {
        mobsStat.forEach((id, entry) -> result.put(id, entry.get(MobsStat.Entry.DAMAGE_RECEIVED).floatValue()));
    }

    private static /* synthetic */ void lambda$getDamageDealt$33(Object2FloatMap result, MobsStat mobsStat) {
        mobsStat.forEach((id, entry) -> result.put(id, entry.get(MobsStat.Entry.DAMAGE_DEALT).floatValue()));
    }

    private static /* synthetic */ void lambda$getEntitiesKilled$31(Object2IntMap result, MobsStat mobsStat) {
        mobsStat.forEach((id, entry) -> result.put(id, entry != null && entry.has(MobsStat.Entry.KILLED) ? entry.get(MobsStat.Entry.KILLED) : 0));
    }

    private static /* synthetic */ void lambda$getMinedBlocks$29(Object2IntMap result, ResourceLocation id, MinedBlocksStat.Entry entry) {
        result.put((Object)id, entry.get(MinedBlocksStat.Entry.COUNT).intValue());
    }
}

