/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.core.vault.stat;

import iskallia.vault.core.Version;
import iskallia.vault.core.data.DataMap;
import iskallia.vault.core.data.DataObject;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.data.adapter.vault.CompoundAdapter;
import iskallia.vault.core.data.key.FieldKey;
import iskallia.vault.core.data.key.registry.FieldRegistry;
import iskallia.vault.core.event.CommonEvents;
import iskallia.vault.core.vault.Vault;
import iskallia.vault.core.vault.modifier.modifier.ExperienceModifier;
import iskallia.vault.core.vault.modifier.spi.VaultModifier;
import iskallia.vault.core.vault.player.Listener;
import iskallia.vault.core.vault.player.Runner;
import iskallia.vault.core.vault.stat.StatCollector;
import iskallia.vault.core.world.storage.VirtualWorld;
import iskallia.vault.init.ModGameRules;
import iskallia.vault.world.VaultExperience;
import java.util.HashMap;
import java.util.UUID;

public class StatsCollector
extends DataObject<StatsCollector> {
    public static final FieldRegistry FIELDS = new FieldRegistry();
    public static final FieldKey<Map> MAP = (FieldKey)FieldKey.of("map", Map.class).with(Version.v1_0, CompoundAdapter.of(Map::new), DISK.all().or(CLIENT.all())).register(FIELDS);

    public StatsCollector() {
        this.set(MAP, new Map());
    }

    @Override
    public FieldRegistry getFields() {
        return FIELDS;
    }

    public void initServer(VirtualWorld world, Vault vault) {
        this.get(MAP).forEach((uuid, collector) -> collector.initServer(world, vault, (UUID)uuid));
        CommonEvents.LISTENER_JOIN.register(this, data -> {
            if (data.getVault() != vault) {
                return;
            }
            if (!(data.getListener() instanceof Runner)) {
                return;
            }
            UUID uuid = data.getListener().get(Listener.ID);
            this.get(MAP).computeIfAbsent(uuid, _uuid -> {
                StatCollector stats = new StatCollector();
                stats.modify(StatCollector.BONUS_EXP_MULTIPLIER, m -> Float.valueOf(m.floatValue() * ((VaultExperience.GameRuleValue)world.m_46469_().m_46170_(ModGameRules.EXPERIENCE)).get().getMultiplier()));
                stats.modify(StatCollector.OBJECTIVE_EXP_MULTIPLIER, m -> Float.valueOf(m.floatValue() * ((VaultExperience.GameRuleValue)world.m_46469_().m_46170_(ModGameRules.EXPERIENCE)).get().getMultiplier()));
                for (VaultModifier<?> modifier : vault.get(Vault.MODIFIERS).getModifiers()) {
                    ExperienceModifier experienceModifier;
                    float addend;
                    if (!(modifier instanceof ExperienceModifier) || !((addend = ((ExperienceModifier.Properties)(experienceModifier = (ExperienceModifier)modifier).properties()).getAddend()) <= -1.0f)) continue;
                    stats.modify(StatCollector.OBJECTIVE_EXP_MULTIPLIER, exp -> Float.valueOf(0.0f));
                    stats.modify(StatCollector.BONUS_EXP_MULTIPLIER, exp -> Float.valueOf(0.0f));
                }
                return stats;
            }).initServer(world, vault, uuid);
        });
        CommonEvents.LISTENER_LEAVE.register(this, data -> {
            if (data.getVault() != vault) {
                return;
            }
            UUID uuid = data.getListener().get(Listener.ID);
            if (!this.get(MAP).containsKey(uuid)) {
                return;
            }
            ((StatCollector)this.get(MAP).get(uuid)).releaseServer();
        });
    }

    public void releaseServer() {
        this.get(MAP).values().forEach(StatCollector::releaseServer);
        CommonEvents.release(this);
    }

    public StatCollector get(Listener listener) {
        return this.get(listener.get(Listener.ID));
    }

    public StatCollector get(UUID uuid) {
        return (StatCollector)this.get(MAP).get(uuid);
    }

    public Map getMap() {
        return this.get(MAP);
    }

    public static class Map
    extends DataMap<Map, UUID, StatCollector> {
        public Map() {
            super(new HashMap(), Adapters.UUID, CompoundAdapter.of(StatCollector::new));
        }
    }
}

