/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.core.vault.stat;

import iskallia.vault.client.atlas.TextureAtlasRegion;
import iskallia.vault.client.gui.framework.ScreenTextures;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.loading.FMLEnvironment;

public enum VaultChestType {
    WOODEN("Wooden"),
    GILDED("Gilded"),
    LIVING("Living"),
    ORNATE("Ornate"),
    TREASURE("Treasure"),
    ALTAR("Altar"),
    HARDENED("Hardened"),
    ENIGMA("Enigma"),
    FLESH("Flesh");

    private final String name;
    private Object icon = null;
    private boolean iconsInitialized = false;

    private VaultChestType(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    @OnlyIn(value=Dist.CLIENT)
    public synchronized TextureAtlasRegion getIcon() {
        if (!this.iconsInitialized && FMLEnvironment.dist == Dist.CLIENT) {
            this.initClientResources();
        }
        return (TextureAtlasRegion)this.icon;
    }

    @OnlyIn(value=Dist.CLIENT)
    private void initClientResources() {
        if (this.iconsInitialized) {
            return;
        }
        try {
            switch (this) {
                case WOODEN: {
                    this.icon = ScreenTextures.WOODEN_CHEST_SMALL_ICON;
                    break;
                }
                case GILDED: {
                    this.icon = ScreenTextures.GILDED_CHEST_SMALL_ICON;
                    break;
                }
                case LIVING: {
                    this.icon = ScreenTextures.LIVING_CHEST_SMALL_ICON;
                    break;
                }
                case ORNATE: {
                    this.icon = ScreenTextures.ORNATE_CHEST_SMALL_ICON;
                    break;
                }
                default: {
                    this.icon = null;
                }
            }
            this.iconsInitialized = true;
        }
        catch (Exception e) {
            this.icon = null;
            this.iconsInitialized = true;
        }
    }
}

