/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.core.vault.time;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import iskallia.vault.client.gui.helper.FontHelper;
import iskallia.vault.client.gui.helper.ScreenDrawHelper;
import iskallia.vault.client.gui.helper.UIHelper;
import iskallia.vault.core.Version;
import iskallia.vault.core.data.DataObject;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.data.adapter.vault.CompoundAdapter;
import iskallia.vault.core.data.key.FieldKey;
import iskallia.vault.core.data.key.registry.FieldRegistry;
import iskallia.vault.core.data.key.registry.ISupplierKey;
import iskallia.vault.core.vault.overlay.VaultOverlay;
import iskallia.vault.core.vault.time.modifier.ClockModifier;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public abstract class TickClock
extends DataObject<TickClock>
implements ISupplierKey<TickClock> {
    public static final FieldRegistry FIELDS = new FieldRegistry();
    public static final FieldKey<Integer> GLOBAL_TIME = (FieldKey)FieldKey.of("global_time", Integer.class).with(Version.v1_0, Adapters.INT, DISK.all().or(CLIENT.all())).register(FIELDS);
    public static final FieldKey<Integer> LOGICAL_TIME = (FieldKey)FieldKey.of("logical_time", Integer.class).with(Version.v1_0, Adapters.INT, DISK.all().or(CLIENT.all())).register(FIELDS);
    public static final FieldKey<Integer> DISPLAY_TIME = (FieldKey)FieldKey.of("display_time", Integer.class).with(Version.v1_0, Adapters.INT, DISK.all().or(CLIENT.all())).register(FIELDS);
    public static final FieldKey<Void> PAUSED = (FieldKey)FieldKey.of("paused", Void.class).with(Version.v1_0, Adapters.ofVoid(), DISK.all().or(CLIENT.all())).register(FIELDS);
    public static final FieldKey<Void> VISIBLE = (FieldKey)FieldKey.of("visible", Void.class).with(Version.v1_0, Adapters.ofVoid(), DISK.all().or(CLIENT.all())).register(FIELDS);
    public static final FieldKey<Integer> TEXT_COLOR = (FieldKey)FieldKey.of("text_color", Integer.class).with(Version.v1_0, Adapters.INT, DISK.all().or(CLIENT.all())).register(FIELDS);
    public static final FieldKey<Integer> ROTATION_TIME = (FieldKey)FieldKey.of("rotation_time", Integer.class).with(Version.v1_0, Adapters.INT, DISK.all().or(CLIENT.all())).register(FIELDS);
    public static final FieldKey<ClockModifier.List> MODIFIERS = (FieldKey)FieldKey.of("modifiers", ClockModifier.List.class).with(Version.v1_0, CompoundAdapter.of(ClockModifier.List::new), DISK.all()).register(FIELDS);

    public TickClock() {
        this.set(GLOBAL_TIME, 0);
        this.set(LOGICAL_TIME, 0);
        this.set(DISPLAY_TIME, 0);
        this.set(VISIBLE);
        this.set(PAUSED);
        this.set(TEXT_COLOR, -1);
        this.set(ROTATION_TIME, 360);
    }

    @Override
    public FieldRegistry getFields() {
        return FIELDS;
    }

    public TickClock addModifier(ClockModifier modifier) {
        this.get(MODIFIERS).add(modifier);
        return this;
    }

    protected abstract void tickTime();

    public final void tickServer(ServerLevel world) {
        this.set(GLOBAL_TIME, this.get(GLOBAL_TIME) + 1);
        this.get(MODIFIERS).forEach(modifier -> modifier.tick(world, this));
        if (this.has(PAUSED)) {
            return;
        }
        this.tickTime();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void tickClient() {
    }

    protected int getTextColor(int time) {
        return this.get(TEXT_COLOR);
    }

    protected float getRotationTime(int time) {
        return this.get(ROTATION_TIME).intValue();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void render(PoseStack matrixStack) {
        if (!this.has(VISIBLE)) {
            return;
        }
        int hourglassWidth = 12;
        int hourglassHeight = 16;
        int color = this.getTextColor(this.get(DISPLAY_TIME));
        String text = UIHelper.formatTimeString(Math.abs(this.get(DISPLAY_TIME)));
        FontHelper.drawStringWithBorder(matrixStack, text, -12.0f, 13.0f, color, -16777216);
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157456_((int)0, (ResourceLocation)VaultOverlay.VAULT_HUD);
        float rotationTime = this.getRotationTime(this.get(DISPLAY_TIME));
        float degrees = (float)this.get(DISPLAY_TIME).intValue() % rotationTime * 360.0f / rotationTime;
        matrixStack.m_85845_(Vector3f.f_122227_.m_122240_(degrees));
        matrixStack.m_85837_((double)((float)(-hourglassWidth) / 2.0f), (double)((float)(-hourglassHeight) / 2.0f), 0.0);
        ScreenDrawHelper.drawTexturedQuads(buf -> ScreenDrawHelper.rect((VertexConsumer)buf, matrixStack).dim(hourglassWidth, hourglassHeight).texVanilla(1.0f, 36.0f, hourglassWidth, hourglassHeight).draw());
        RenderSystem.m_157456_((int)0, (ResourceLocation)GuiComponent.f_93098_);
    }
}

