/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.core.world.data.entity;

import iskallia.vault.core.world.data.entity.EntityPredicate;
import iskallia.vault.core.world.data.entity.PartialCompoundNbt;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.world.phys.Vec3;

public class NotEntityPredicate
implements EntityPredicate {
    private final EntityPredicate predicate;

    public NotEntityPredicate(EntityPredicate predicate) {
        this.predicate = Objects.requireNonNull(predicate, "predicate");
    }

    public EntityPredicate getPredicate() {
        return this.predicate;
    }

    @Override
    public boolean test(Vec3 pos, BlockPos blockPos, PartialCompoundNbt nbt) {
        return !this.predicate.test(pos, blockPos, nbt);
    }

    public String toString() {
        if (this.predicate == EntityPredicate.TRUE) {
            return "!";
        }
        if (this.predicate == EntityPredicate.FALSE) {
            return "!!";
        }
        return "!" + String.valueOf(this.predicate);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof NotEntityPredicate)) {
            return false;
        }
        NotEntityPredicate that = (NotEntityPredicate)o;
        return this.predicate.equals(that.predicate);
    }

    public int hashCode() {
        return this.predicate.hashCode();
    }
}

