/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.core.world.data.entity;

import iskallia.vault.core.world.data.entity.EntityPredicate;
import iskallia.vault.core.world.data.entity.PartialCompoundNbt;
import iskallia.vault.core.world.data.entity.PartialEntity;
import iskallia.vault.core.world.data.entity.PartialEntityGroup;
import iskallia.vault.core.world.data.entity.PartialEntityTag;
import java.util.Arrays;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;

public class OrEntityPredicate
implements EntityPredicate {
    private final EntityPredicate[] children;
    private final boolean serialize;

    public OrEntityPredicate(EntityPredicate ... children) {
        this.children = children;
        boolean shouldSerialize = false;
        for (EntityPredicate predicate : children) {
            CompoundTag tag;
            PartialCompoundNbt partialNbt;
            if (predicate instanceof PartialEntity) {
                PartialEntity pe = (PartialEntity)predicate;
                partialNbt = pe.getNbt();
            } else if (predicate instanceof PartialEntityGroup) {
                PartialEntityGroup peg = (PartialEntityGroup)predicate;
                partialNbt = peg.getNbt();
            } else if (predicate instanceof PartialEntityTag) {
                PartialEntityTag pet = (PartialEntityTag)predicate;
                partialNbt = pet.getNbt();
            } else {
                if (predicate instanceof OrEntityPredicate) {
                    OrEntityPredicate or = (OrEntityPredicate)predicate;
                    if (!or.serialize) continue;
                    shouldSerialize = true;
                    break;
                }
                if (predicate == EntityPredicate.TRUE || predicate == EntityPredicate.FALSE) continue;
                shouldSerialize = true;
                break;
            }
            if (partialNbt == null || !partialNbt.asWhole().isPresent() || (tag = partialNbt.asWhole().get()).m_128440_() <= 1 && (tag.m_128440_() != 1 || tag.m_128425_("id", 8))) continue;
            shouldSerialize = true;
            break;
        }
        this.serialize = shouldSerialize;
    }

    public EntityPredicate[] getChildren() {
        return Arrays.copyOf(this.children, this.children.length);
    }

    @Override
    public boolean test(Entity entity) {
        if (!this.serialize) {
            for (EntityPredicate child : this.children) {
                if (!child.test(entity)) continue;
                return true;
            }
            return false;
        }
        return EntityPredicate.super.test(entity);
    }

    @Override
    public boolean test(Vec3 pos, BlockPos blockPos, PartialCompoundNbt nbt) {
        for (EntityPredicate child : this.children) {
            if (!child.test(pos, blockPos, nbt)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return Arrays.toString(this.children);
    }
}

