/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.core.world.data.entity;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.data.adapter.ISimpleAdapter;
import iskallia.vault.core.net.BitBuffer;
import iskallia.vault.core.world.data.entity.EntityPlacement;
import iskallia.vault.core.world.data.entity.PartialCompoundNbt;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.ResourceLocationException;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.CommonLevelAccessor;
import net.minecraft.world.phys.Vec3;

public class PartialEntity
implements EntityPlacement<PartialEntity> {
    private Vec3 pos;
    private BlockPos blockPos;
    private PartialCompoundNbt nbt;

    protected PartialEntity(Vec3 pos, BlockPos blockPos, PartialCompoundNbt nbt) {
        this.pos = pos;
        this.blockPos = blockPos;
        this.nbt = nbt;
    }

    public static PartialEntity of(Vec3 pos, BlockPos blockPos, PartialCompoundNbt nbt) {
        return new PartialEntity(pos, blockPos, nbt);
    }

    public static PartialEntity of(Vec3 pos, BlockPos blockPos, ResourceLocation id, PartialCompoundNbt nbt) {
        if (id != null) {
            CompoundTag tag = nbt.asWhole().orElse(new CompoundTag());
            tag.m_128359_("id", id.toString());
            return new PartialEntity(pos, blockPos, PartialCompoundNbt.of(tag));
        }
        return new PartialEntity(pos, blockPos, nbt);
    }

    public static PartialEntity of(Entity entity) {
        return new PartialEntity(entity.m_20182_(), entity.m_142538_(), PartialCompoundNbt.of(entity));
    }

    public ResourceLocation getId() {
        return this.getNbt().asWhole().map(nbt -> ResourceLocation.m_135820_((String)nbt.m_128461_("id"))).orElse(null);
    }

    public Vec3 getPos() {
        return this.pos;
    }

    public BlockPos getBlockPos() {
        return this.blockPos;
    }

    public PartialCompoundNbt getNbt() {
        return this.nbt;
    }

    public void setPos(Vec3 pos) {
        this.pos = pos;
    }

    public void setBlockPos(BlockPos blockPos) {
        this.blockPos = blockPos;
    }

    public void setNbt(PartialCompoundNbt nbt) {
        this.nbt = nbt;
    }

    @Override
    public boolean isSubsetOf(PartialEntity other) {
        return this.nbt.isSubsetOf(other.nbt);
    }

    @Override
    public boolean isSubsetOf(Entity entity) {
        return this.nbt.asWhole().map(nbt -> {
            if (nbt.m_128440_() == 1 && nbt.m_128425_("id", 8)) {
                return nbt.m_128461_("id").equals(EntityType.m_20613_((EntityType)entity.m_6095_()).toString());
            }
            return this.nbt.isSubsetOf(PartialCompoundNbt.of(entity));
        }).orElse(true);
    }

    @Override
    public void fillInto(PartialEntity other) {
        if (this.pos != null) {
            other.pos = this.pos;
        }
        if (this.blockPos != null) {
            other.blockPos = this.blockPos.m_7949_();
        }
        this.nbt.fillInto(other.nbt);
    }

    @Override
    public void place(CommonLevelAccessor world) {
    }

    @Override
    public boolean test(Entity entity) {
        return this.isSubsetOf(entity);
    }

    @Override
    public boolean test(Vec3 pos, BlockPos blockPos, PartialCompoundNbt nbt) {
        return this.nbt.isSubsetOf(nbt);
    }

    @Override
    public PartialEntity copy() {
        return new PartialEntity(this.pos, this.blockPos.m_7949_(), this.nbt.copy());
    }

    public String toString() {
        return this.nbt.toString();
    }

    public static Optional<PartialEntity> parse(String string, boolean logErrors) {
        try {
            return Optional.of(PartialEntity.parse(new StringReader(string)));
        }
        catch (CommandSyntaxException | IllegalArgumentException e) {
            if (logErrors) {
                e.printStackTrace();
            }
            return Optional.empty();
        }
    }

    public static PartialEntity parse(String string) throws CommandSyntaxException {
        return PartialEntity.parse(new StringReader(string));
    }

    public static PartialEntity parse(StringReader reader) throws CommandSyntaxException {
        if (!reader.canRead() || !PartialEntity.isCharValid(reader.peek())) {
            return PartialEntity.of(null, null, null, PartialCompoundNbt.parse(reader));
        }
        int cursor = reader.getCursor();
        while (reader.canRead() && PartialEntity.isCharValid(reader.peek())) {
            reader.skip();
        }
        String string = reader.getString().substring(cursor, reader.getCursor());
        try {
            return PartialEntity.of(null, null, string.isEmpty() ? null : new ResourceLocation(string), PartialCompoundNbt.parse(reader));
        }
        catch (ResourceLocationException e) {
            reader.setCursor(cursor);
            throw new IllegalArgumentException("Invalid entity identifier '" + string + "' in entity '" + reader.getString() + "'");
        }
    }

    protected static boolean isCharValid(char c) {
        return c >= '0' && c <= '9' || c >= 'a' && c <= 'z' || c == '_' || c == ':' || c == '/' || c == '.' || c == '-';
    }

    public static class Adapter
    implements ISimpleAdapter<PartialEntity, Tag, JsonElement> {
        @Override
        public void writeBits(PartialEntity value, BitBuffer buffer) {
            buffer.writeBoolean(value == null);
            if (value != null) {
                Adapters.BLOCK_POS.asNullable().writeBits(value.blockPos, buffer);
                buffer.writeBoolean(value.pos == null);
                if (value.pos != null) {
                    Adapters.DOUBLE.writeBits(value.pos.f_82479_, buffer);
                    Adapters.DOUBLE.writeBits(value.pos.f_82480_, buffer);
                    Adapters.DOUBLE.writeBits(value.pos.f_82481_, buffer);
                }
                Adapters.COMPOUND_NBT.asNullable().writeBits(value.nbt.asWhole().orElse(null), buffer);
            }
        }

        @Override
        public Optional<PartialEntity> readBits(BitBuffer buffer) {
            if (buffer.readBoolean()) {
                return Optional.empty();
            }
            BlockPos blockPos = Adapters.BLOCK_POS.asNullable().readBits(buffer).orElse(null);
            Vec3 pos = null;
            if (!buffer.readBoolean()) {
                pos = new Vec3(((Double)Adapters.DOUBLE.readBits(buffer).orElseThrow()).doubleValue(), ((Double)Adapters.DOUBLE.readBits(buffer).orElseThrow()).doubleValue(), ((Double)Adapters.DOUBLE.readBits(buffer).orElseThrow()).doubleValue());
            }
            CompoundTag nbt = Adapters.COMPOUND_NBT.asNullable().readBits(buffer).orElse(null);
            return Optional.of(PartialEntity.of(pos, blockPos, PartialCompoundNbt.of(nbt)));
        }

        @Override
        public Optional<Tag> writeNbt(@Nullable PartialEntity value) {
            if (value == null) {
                return Optional.empty();
            }
            CompoundTag nbt = new CompoundTag();
            if (value.pos != null) {
                ListTag posNBT = new ListTag();
                posNBT.add((Object)DoubleTag.m_128500_((double)value.pos.f_82479_));
                posNBT.add((Object)DoubleTag.m_128500_((double)value.pos.f_82480_));
                posNBT.add((Object)DoubleTag.m_128500_((double)value.pos.f_82481_));
                nbt.m_128365_("pos", (Tag)posNBT);
            }
            Adapters.BLOCK_POS.writeNbt(value.blockPos).ifPresent(tag -> nbt.m_128365_("blockPos", tag));
            nbt.m_128365_("nbt", (Tag)value.nbt.asWhole().orElse(new CompoundTag()));
            return Optional.of(nbt);
        }

        @Override
        public Optional<PartialEntity> readNbt(@Nullable Tag nbt) {
            if (nbt instanceof CompoundTag) {
                CompoundTag compound = (CompoundTag)nbt;
                if (!compound.m_128441_("nbt")) {
                    return Optional.of(PartialEntity.of(null, null, PartialCompoundNbt.of(compound)));
                }
                Vec3 pos = null;
                if (compound.m_128425_("pos", 9)) {
                    ListTag posNBT = compound.m_128437_("pos", 6);
                    pos = new Vec3(posNBT.m_128772_(0), posNBT.m_128772_(1), posNBT.m_128772_(2));
                }
                return Optional.of(PartialEntity.of(pos, Adapters.BLOCK_POS.readNbt(compound.m_128423_("blockPos")).orElse(null), PartialCompoundNbt.of(compound.m_128469_("nbt"))));
            }
            return Optional.empty();
        }

        @Override
        public Optional<JsonElement> writeJson(@Nullable PartialEntity value) {
            if (value == null) {
                return Optional.empty();
            }
            JsonObject json = new JsonObject();
            if (value.pos != null) {
                JsonArray posNBT = new JsonArray();
                posNBT.add((Number)value.pos.f_82479_);
                posNBT.add((Number)value.pos.f_82480_);
                posNBT.add((Number)value.pos.f_82481_);
                json.add("pos", (JsonElement)posNBT);
            }
            Adapters.BLOCK_POS.writeJson(value.blockPos).ifPresent(tag -> json.add("blockPos", tag));
            Adapters.COMPOUND_NBT.writeJson(value.nbt.asWhole().orElse(new CompoundTag())).ifPresent(tag -> json.add("nbt", tag));
            return Optional.of(json);
        }

        @Override
        public Optional<PartialEntity> readJson(@Nullable JsonElement json) {
            if (json instanceof JsonObject) {
                JsonObject object = (JsonObject)json;
                if (!object.has("nbt")) {
                    return Optional.of(PartialEntity.of(null, null, PartialCompoundNbt.of(Adapters.COMPOUND_NBT.readJson((JsonElement)object).orElse(null))));
                }
                Vec3 pos = null;
                JsonElement jsonElement = object.get("pos");
                if (jsonElement instanceof JsonArray) {
                    JsonArray array = (JsonArray)jsonElement;
                    pos = new Vec3(array.get(0).getAsDouble(), array.get(1).getAsDouble(), array.get(2).getAsDouble());
                }
                return Optional.of(PartialEntity.of(pos, Adapters.BLOCK_POS.readJson(object.get("blockPos")).orElse(null), PartialCompoundNbt.of(Adapters.COMPOUND_NBT.readJson(object.get("nbt")).orElse(null))));
            }
            return Optional.empty();
        }
    }
}

