/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.core.world.data.item;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.data.adapter.ISimpleAdapter;
import iskallia.vault.core.data.adapter.array.ArrayAdapter;
import iskallia.vault.core.net.BitBuffer;
import iskallia.vault.core.world.data.entity.PartialCompoundNbt;
import iskallia.vault.core.world.data.item.PartialItem;
import iskallia.vault.core.world.data.item.PartialItemGroup;
import iskallia.vault.core.world.data.item.PartialItemTag;
import iskallia.vault.core.world.data.item.PartialStack;
import iskallia.vault.core.world.data.tile.OrItemPredicate;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;

@FunctionalInterface
public interface ItemPredicate {
    public static final ItemPredicate FALSE = (item, nbt) -> false;
    public static final ItemPredicate TRUE = (item, nbt) -> true;

    public boolean test(PartialItem var1, PartialCompoundNbt var2);

    default public boolean test(PartialStack stack) {
        return this.test(stack.getItem(), stack.getNbt());
    }

    default public boolean test(ItemStack stack) {
        return this.test(PartialItem.of(stack.m_41720_()), PartialCompoundNbt.of(stack.m_41783_()));
    }

    public static Optional<ItemPredicate> of(String string, boolean logErrors) {
        if (string.isEmpty()) {
            return Optional.of(TRUE);
        }
        return (switch (string.charAt(0)) {
            case '#' -> PartialItemTag.parse(string, logErrors);
            case '@' -> PartialItemGroup.parse(string, logErrors);
            default -> PartialStack.parse(string, logErrors);
        }).map(o -> o);
    }

    public static class Adapter
    implements ISimpleAdapter<ItemPredicate, Tag, JsonElement> {
        private static ArrayAdapter<ItemPredicate> LIST = Adapters.ofArray(ItemPredicate[]::new, new Adapter());

        @Override
        public void writeBits(@Nullable ItemPredicate value, BitBuffer buffer) {
            buffer.writeBoolean(value == null);
            if (value != null) {
                if (value instanceof OrItemPredicate) {
                    OrItemPredicate or = (OrItemPredicate)value;
                    buffer.writeBoolean(true);
                    LIST.writeBits((ItemPredicate)or.getChildren(), buffer);
                } else {
                    buffer.writeBoolean(false);
                    Adapters.UTF_8.writeBits(value.toString(), buffer);
                }
            }
        }

        @Override
        public final Optional<ItemPredicate> readBits(BitBuffer buffer) {
            if (buffer.readBoolean()) {
                return Optional.empty();
            }
            if (buffer.readBoolean()) {
                return LIST.readBits(buffer).map(OrItemPredicate::new);
            }
            return Adapters.UTF_8.readBits(buffer).map(string -> ItemPredicate.of(string, true).orElse(FALSE));
        }

        @Override
        public Optional<Tag> writeNbt(@Nullable ItemPredicate value) {
            if (value == null) {
                return Optional.empty();
            }
            if (value instanceof OrItemPredicate) {
                OrItemPredicate or = (OrItemPredicate)value;
                return LIST.writeNbt((ItemPredicate)or.getChildren());
            }
            return Optional.of(StringTag.m_129297_((String)value.toString()));
        }

        @Override
        public Optional<ItemPredicate> readNbt(@Nullable Tag nbt) {
            if (nbt == null) {
                return Optional.empty();
            }
            if (nbt instanceof ListTag) {
                ListTag list = (ListTag)nbt;
                return LIST.readNbt(list).map(OrItemPredicate::new);
            }
            if (nbt instanceof StringTag) {
                StringTag string = (StringTag)nbt;
                return Optional.of(ItemPredicate.of(string.m_7916_(), true).orElse(FALSE));
            }
            return Optional.empty();
        }

        @Override
        public Optional<JsonElement> writeJson(@Nullable ItemPredicate value) {
            if (value == null) {
                return Optional.empty();
            }
            if (value instanceof OrItemPredicate) {
                OrItemPredicate or = (OrItemPredicate)value;
                return LIST.writeJson((ItemPredicate)or.getChildren());
            }
            return Optional.of(new JsonPrimitive(value.toString()));
        }

        @Override
        public Optional<ItemPredicate> readJson(@Nullable JsonElement json) {
            JsonPrimitive primitive;
            if (json == null) {
                return Optional.empty();
            }
            if (json instanceof JsonArray) {
                JsonArray array = (JsonArray)json;
                return LIST.readJson(array).map(OrItemPredicate::new);
            }
            if (json instanceof JsonPrimitive && (primitive = (JsonPrimitive)json).isString()) {
                return Optional.of(ItemPredicate.of(json.getAsString(), true).orElse(FALSE));
            }
            return Optional.empty();
        }
    }
}

