/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.core.world.data.tile;

import com.google.gson.JsonElement;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.data.adapter.ISimpleAdapter;
import iskallia.vault.core.net.BitBuffer;
import iskallia.vault.core.world.data.BlockRegistry;
import iskallia.vault.core.world.data.IndexedBlock;
import iskallia.vault.core.world.data.entity.PartialCompoundNbt;
import iskallia.vault.core.world.data.tile.PartialBlockState;
import iskallia.vault.core.world.data.tile.TilePlacement;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.ResourceLocationException;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.CommonLevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.registries.ForgeRegistries;

public class PartialBlock
implements TilePlacement<PartialBlock>,
IndexedBlock {
    protected static final PartialBlock EMPTY = new PartialBlock(null);
    protected ResourceLocation id;
    protected int registryIndex = -80085;
    private final Object registryLock = new Object();

    protected PartialBlock(ResourceLocation id) {
        this.id = id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getRegistryIndex() {
        if (this.registryIndex != -80085) {
            return this.registryIndex;
        }
        Object object = this.registryLock;
        synchronized (object) {
            if (this.registryIndex != -80085) {
                return this.registryIndex;
            }
            if (this.id == null) {
                this.registryIndex = -666;
                return this.registryIndex;
            }
            Block block = (Block)ForgeRegistries.BLOCKS.getValue(this.id);
            if (block != null && block.getRegistryName() != null && block.getRegistryName().equals((Object)this.id)) {
                this.id = block.getRegistryName();
            }
            this.registryIndex = BlockRegistry.getIdForBlock(block);
            if (this.registryIndex == 0 && !"minecraft".equals(this.id.m_135827_()) && !"air".equals(this.id.m_135815_())) {
                this.registryIndex = -666;
            }
        }
        return this.registryIndex;
    }

    @Override
    public void copyRegistryIndex(int newIndex) {
        this.registryIndex = newIndex;
    }

    public static PartialBlock empty() {
        return EMPTY;
    }

    public static PartialBlock of(ResourceLocation id) {
        return new PartialBlock(id);
    }

    public static PartialBlock of(Block block) {
        PartialBlock partialBlock = new PartialBlock(block.getRegistryName());
        partialBlock.copyRegistryIndex(((IndexedBlock)block).getRegistryIndex());
        return partialBlock;
    }

    public static PartialBlock of(BlockState state) {
        return PartialBlock.of(state.m_60734_());
    }

    @Override
    public boolean isSubsetOf(PartialBlock other) {
        return this.id == null || (this.getRegistryIndex() < 0 ? this.id.equals((Object)other.id) : other.getRegistryIndex() == this.getRegistryIndex());
    }

    @Override
    public boolean isSubsetOf(LevelReader world, BlockPos pos) {
        return this.isSubsetOf(PartialBlock.of(world.m_8055_(pos)));
    }

    @Override
    public void fillInto(PartialBlock other) {
        if (this.id != null) {
            other.copyRegistryIndex(this.getRegistryIndex());
        }
    }

    @Override
    public void place(CommonLevelAccessor world, BlockPos pos, int flags) {
        this.asWhole().ifPresent(block -> {
            BlockState oldState = world.m_8055_(pos);
            BlockState newState = block.m_49966_();
            for (Property property : oldState.m_61147_()) {
                if (!newState.m_61138_(property)) continue;
                newState = (BlockState)newState.m_61124_(property, oldState.m_61143_(property));
            }
            world.m_7731_(pos, newState, flags);
        });
    }

    @Override
    public boolean test(PartialBlockState state, PartialCompoundNbt nbt) {
        return this.isSubsetOf(state.getBlock());
    }

    public Optional<Block> asWhole() {
        return Optional.ofNullable(BlockRegistry.getBlockByIDOrNull(this.getRegistryIndex()));
    }

    @Override
    public PartialBlock copy() {
        PartialBlock partialBlock = new PartialBlock(this.id);
        partialBlock.copyRegistryIndex(this.getRegistryIndex());
        return partialBlock;
    }

    public String toString() {
        return this.id == null ? "" : this.id.toString();
    }

    public static Optional<PartialBlock> parse(String string, boolean logErrors) {
        try {
            return Optional.of(PartialBlock.parse(new StringReader(string)));
        }
        catch (CommandSyntaxException | IllegalArgumentException e) {
            if (logErrors) {
                e.printStackTrace();
            }
            return Optional.empty();
        }
    }

    public static PartialBlock parse(String string) throws CommandSyntaxException {
        return PartialBlock.parse(new StringReader(string));
    }

    public static PartialBlock parse(StringReader reader) throws CommandSyntaxException {
        if (!reader.canRead() || !PartialBlock.isCharValid(reader.peek())) {
            return PartialBlock.empty();
        }
        int cursor = reader.getCursor();
        while (reader.canRead() && PartialBlock.isCharValid(reader.peek())) {
            reader.skip();
        }
        String string = reader.getString().substring(cursor, reader.getCursor());
        try {
            return PartialBlock.of(new ResourceLocation(string));
        }
        catch (ResourceLocationException e) {
            reader.setCursor(cursor);
            throw new IllegalArgumentException("Invalid block identifier '" + string + "' in tile '" + reader.getString() + "'");
        }
    }

    protected static boolean isCharValid(char c) {
        return c >= '0' && c <= '9' || c >= 'a' && c <= 'z' || c == '_' || c == ':' || c == '/' || c == '.' || c == '-';
    }

    public static class Adapter
    implements ISimpleAdapter<PartialBlock, Tag, JsonElement> {
        @Override
        public void writeBits(PartialBlock value, BitBuffer buffer) {
            buffer.writeBoolean(value == null);
            if (value != null) {
                Adapters.IDENTIFIER.asNullable().writeBits(value.id, buffer);
            }
        }

        @Override
        public Optional<PartialBlock> readBits(BitBuffer buffer) {
            if (buffer.readBoolean()) {
                return Optional.empty();
            }
            return Optional.of(new PartialBlock(Adapters.IDENTIFIER.asNullable().readBits(buffer).orElse(null)));
        }

        @Override
        public Optional<Tag> writeNbt(@Nullable PartialBlock value) {
            return value == null ? Optional.empty() : Adapters.IDENTIFIER.writeNbt(value.id);
        }

        @Override
        public Optional<PartialBlock> readNbt(@Nullable Tag nbt) {
            return nbt == null ? Optional.empty() : Adapters.IDENTIFIER.readNbt(nbt).map(PartialBlock::of);
        }
    }
}

