/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.core.world.generator;

import iskallia.vault.VaultMod;
import iskallia.vault.core.world.data.tile.PartialTile;
import iskallia.vault.core.world.generator.GeneratorThreading;
import iskallia.vault.core.world.template.tasks.BlocksToLevelSectionTask;
import iskallia.vault.core.world.template.tasks.BlocksToProtoSectionTask;
import iskallia.vault.core.world.template.tasks.BlocksToSectionTask;
import iskallia.vault.core.world.template.tasks.Pair;
import iskallia.vault.core.world.template.tasks.TileResult;
import iskallia.vault.init.ModBlocks;
import iskallia.vault.mixin.ProtoChunkAccessor;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundLevelChunkWithLightPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.world.Clearable;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.CommandBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.ProtoChunk;

public final class BatchBlockPlacer {
    private static final Executor DELAYED_EXECUTOR;

    public static void placeTiles(LevelAccessor world, Stream<PartialTile> tilesStream, Object result) {
        Collector<PartialTile, Collected, Collected> collector = Collector.of(() -> new Collected(new ArrayList<BlockPosState>(256), new ArrayList<PartialTile>(256)), (accumulator, tile) -> {
            BlockState state = tile.getState().asWhole().orElse(ModBlocks.ERROR_BLOCK.m_49966_());
            accumulator.states().add(new BlockPosState(tile.getPos(), state));
            tile.getEntity().asWhole().filter(tag -> state.m_155947_() && !tag.m_128456_()).ifPresent(compoundTag -> accumulator.tiles().add((PartialTile)tile));
        }, (firstCollection, secondCollection) -> {
            firstCollection.states().addAll(secondCollection.states());
            firstCollection.tiles().addAll(secondCollection.tiles());
            return firstCollection;
        }, new Collector.Characteristics[0]);
        Collected collectedTiles = tilesStream.filter(Objects::nonNull).collect(collector);
        TileResult tileResult = result != null ? new TileResult(result) : null;
        Map<SectionPos, List<BlockPosState>> bySectionMap = collectedTiles.states().stream().collect(Collectors.groupingBy(blockPosState -> SectionPos.m_123199_((BlockPos)blockPosState.pos())));
        ArrayList chunkData = new ArrayList();
        bySectionMap.forEach((sectionPos, statesInSection) -> {
            ChunkPos chunkPos = new ChunkPos(sectionPos.m_123170_(), sectionPos.m_123222_());
            ChunkAccess chunk = world.m_6325_(chunkPos.f_45578_, chunkPos.f_45579_);
            BlocksToSectionTask<?> task = BatchBlockPlacer.chooseTask(chunk);
            if (task == null) {
                VaultMod.LOGGER.info("No task for chunk at {}", (Object)chunkPos);
                return;
            }
            List<Pair<BlockPos, BlockState>> blockStatePairs = statesInSection.stream().map(bps -> new Pair<BlockPos, BlockState>(bps.pos(), bps.state())).toList();
            int sectionIndex = sectionPos.m_123206_() - (world.m_141937_() >> 4);
            List<BlockPos> lightsToUpdate = task.setBlocks(sectionIndex, blockStatePairs, false);
            chunkData.add(new Pair<ChunkAccess, List<BlockPos>>(chunk, lightsToUpdate));
        });
        if (world instanceof WorldGenRegion) {
            chunkData.stream().filter(p -> p.getFirst() instanceof ProtoChunk).forEach(p -> {
                List lightPositions = (List)p.getSecond();
                if (lightPositions != null) {
                    List<BlockPos> validLightPositions = lightPositions.stream().filter(Objects::nonNull).toList();
                    Object k = p.getFirst();
                    synchronized (k) {
                        ((ProtoChunkAccessor)p.getFirst()).getLights().addAll(validLightPositions);
                    }
                }
            });
        } else if (world instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)world;
            List players = serverLevel.m_8795_(p -> true);
            chunkData.stream().map(Pair::getFirst).filter(LevelChunk.class::isInstance).map(obj -> ((LevelChunk)obj).m_7697_()).distinct().forEach(chunkPos -> DELAYED_EXECUTOR.execute(() -> {
                LevelChunk levelChunk;
                LevelChunk levelChunk2 = levelChunk = serverLevel.m_6325_(chunkPos.f_45578_, chunkPos.f_45579_);
                synchronized (levelChunk2) {
                    players.forEach(player -> player.f_8906_.m_141995_((Packet)new ClientboundLevelChunkWithLightPacket(levelChunk, serverLevel.m_5518_(), null, null, false)));
                }
            }));
        }
        for (PartialTile tile2 : collectedTiles.tiles()) {
            BlockPos pos = tile2.getPos();
            try {
                BlockEntity blockEntity = world.m_7702_(pos);
                Optional<CompoundTag> entityTag = tile2.getEntity().asWhole();
                if (blockEntity != null && entityTag.isPresent()) {
                    Clearable.m_18908_((Object)blockEntity);
                    blockEntity.m_142466_(entityTag.get());
                }
                if (blockEntity instanceof CommandBlockEntity) {
                    world.m_186460_(pos, Blocks.f_50272_, 1);
                }
                if (tileResult == null || tileResult.getPlacedBlockEntities() == null) continue;
                tileResult.getPlacedBlockEntities().add(tile2);
            }
            catch (Exception e) {
                VaultMod.LOGGER.error("Failed to set up tile entity '{}' at {}", (Object)tile2, (Object)pos, (Object)e);
                world.m_7731_(pos, ModBlocks.ERROR_BLOCK.m_49966_(), 0);
            }
        }
    }

    private static BlocksToSectionTask<?> chooseTask(Object chunk) {
        if (chunk instanceof LevelChunk) {
            LevelChunk lc = (LevelChunk)chunk;
            return new BlocksToLevelSectionTask(lc);
        }
        if (chunk instanceof ProtoChunk) {
            ProtoChunk pc = (ProtoChunk)chunk;
            return new BlocksToProtoSectionTask(pc);
        }
        return null;
    }

    static {
        try {
            DELAYED_EXECUTOR = CompletableFuture.delayedExecutor(500L, TimeUnit.MILLISECONDS, GeneratorThreading.getGeneratorExecutor());
        }
        catch (Exception e) {
            VaultMod.LOGGER.error("Failed to initialize delayed executor", (Throwable)e);
            throw new RuntimeException("Failed to initialize delayed executor", e);
        }
    }

    private record Collected(List<BlockPosState> states, List<PartialTile> tiles) {
    }

    private record BlockPosState(BlockPos pos, BlockState state) {
    }
}

