/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.core.world.generator;

import iskallia.vault.core.util.RegionPos;
import iskallia.vault.core.vault.Vault;
import iskallia.vault.core.vault.WorldManager;
import iskallia.vault.core.world.generator.GridGenerator;
import iskallia.vault.core.world.generator.VaultGenerator;
import iskallia.vault.core.world.generator.layout.ClassicPresetLayout;
import iskallia.vault.core.world.generator.layout.GridLayout;
import iskallia.vault.core.world.generator.layout.VaultGridLayout;
import iskallia.vault.core.world.generator.layout.VaultLayout;
import iskallia.vault.core.world.template.tasks.Pair;
import iskallia.vault.init.ModBlocks;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.BlockState;

public class BedrockFill {
    public static List<Pair<BlockPos, BlockState>> blocksToFill(BlockPos offset, Vault vault) {
        VaultGridLayout layout;
        GridGenerator generator;
        int maxZ;
        int maxX;
        int minZ;
        int minX;
        int maxY;
        int minY;
        BlockState bedrock;
        ArrayList<Pair<BlockPos, BlockState>> results;
        block20: {
            block19: {
                results = new ArrayList<Pair<BlockPos, BlockState>>(4096);
                bedrock = ModBlocks.VAULT_BEDROCK.m_49966_();
                WorldManager worldManager = vault.get(Vault.WORLD);
                Direction facing = worldManager.get(WorldManager.FACING);
                minY = 22;
                maxY = 42;
                switch (facing) {
                    case WEST: {
                        minX = 0;
                        minZ = 13;
                        maxX = 20;
                        maxZ = 33;
                        break;
                    }
                    case NORTH: {
                        minX = 13;
                        minZ = 0;
                        maxX = 33;
                        maxZ = 20;
                        break;
                    }
                    case EAST: {
                        minX = 26;
                        minZ = 13;
                        maxX = 46;
                        maxZ = 33;
                        break;
                    }
                    default: {
                        minX = 13;
                        minZ = 26;
                        maxX = 33;
                        maxZ = 46;
                    }
                }
                VaultGenerator generatorObj = worldManager.get(WorldManager.GENERATOR);
                if (!(generatorObj instanceof GridGenerator)) {
                    for (int y = 15; y >= 0; --y) {
                        for (int z = 0; z < 16; ++z) {
                            for (int x = 0; x < 16; ++x) {
                                results.add(new Pair<BlockPos, BlockState>(new BlockPos(offset.m_123341_() + x, offset.m_123342_() + y, offset.m_123343_() + z), bedrock));
                            }
                        }
                    }
                    return results;
                }
                generator = (GridGenerator)generatorObj;
                GridLayout layoutObj = generator.get(GridGenerator.LAYOUT);
                if (!(layoutObj instanceof VaultGridLayout)) break block19;
                layout = (VaultGridLayout)layoutObj;
                if (!(layoutObj instanceof ClassicPresetLayout)) break block20;
            }
            for (int y = 15; y >= 0; --y) {
                for (int z = 0; z < 16; ++z) {
                    for (int x = 0; x < 16; ++x) {
                        results.add(new Pair<BlockPos, BlockState>(new BlockPos(offset.m_123341_() + x, offset.m_123342_() + y, offset.m_123343_() + z), bedrock));
                    }
                }
            }
            return results;
        }
        int cellWidthX = generator.get(GridGenerator.CELL_X);
        int cellWidthZ = generator.get(GridGenerator.CELL_Z);
        HashMap<RegionPos, VaultLayout.PieceType> regionTypeCache = new HashMap<RegionPos, VaultLayout.PieceType>(64);
        HashMap<RegionPos, BlockPos[]> roomBoundingBoxCache = new HashMap<RegionPos, BlockPos[]>(64);
        int baseX = offset.m_123341_();
        int baseY = offset.m_123342_();
        int baseZ = offset.m_123343_();
        for (int y = 15; y >= 0; --y) {
            int posY = baseY + y;
            boolean insideStarterY = posY >= minY && posY <= maxY;
            for (int z = 0; z < 16; ++z) {
                int posZ = baseZ + z;
                boolean insideStarterZ = posZ >= minZ && posZ <= maxZ;
                for (int x = 0; x < 16; ++x) {
                    int posX = baseX + x;
                    if (insideStarterY && insideStarterZ && posX >= minX && posX <= maxX) continue;
                    BlockPos pos = new BlockPos(posX, posY, posZ);
                    RegionPos regionPos = RegionPos.ofBlockPos(pos, cellWidthX, cellWidthZ);
                    VaultLayout.PieceType type = regionTypeCache.computeIfAbsent(regionPos, rp -> layout.getType(vault, (RegionPos)((Object)rp)));
                    if (type == VaultLayout.PieceType.ROOM) {
                        BlockPos[] roomBox = roomBoundingBoxCache.computeIfAbsent(regionPos, rp -> BedrockFill.getRoomBoundingBox(rp.m_123341_(), rp.m_123343_()));
                        BlockPos topLeft = roomBox[0];
                        BlockPos bottomRight = roomBox[1];
                        if (posX >= topLeft.m_123341_() && posX <= bottomRight.m_123341_() && posY >= bottomRight.m_123342_() && posY <= topLeft.m_123342_() && posZ >= topLeft.m_123343_() && posZ <= bottomRight.m_123343_()) continue;
                    }
                    results.add(new Pair<BlockPos, BlockState>(pos, bedrock));
                }
            }
        }
        return results;
    }

    public static BlockPos[] getRoomBoundingBox(int cellX, int cellZ) {
        BlockPos topLeft = new BlockPos(cellX * 47, 55, cellZ * 47);
        BlockPos bottomRight = new BlockPos(cellX * 47 + 46, 9, cellZ * 47 + 46);
        return new BlockPos[]{topLeft, bottomRight};
    }
}

