/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.core.world.generator;

import iskallia.vault.core.world.generator.OverflowExecutor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

public final class GeneratorThreading {
    private static final ExecutorService GENERATOR_EXECUTOR = GeneratorThreading.createGeneratorExecutor();
    private static final ExecutorService ROOM_GENERATOR_EXECUTOR = GeneratorThreading.createRoomGeneratorExecutor();

    private GeneratorThreading() {
    }

    private static ThreadFactory named(String prefix) {
        AtomicInteger seq = new AtomicInteger();
        return r -> {
            Thread t = new Thread(r, prefix + "-" + seq.incrementAndGet());
            t.setDaemon(true);
            return t;
        };
    }

    private static ExecutorService createGeneratorExecutor() {
        int cores = Math.max(2, Runtime.getRuntime().availableProcessors() - 1);
        return OverflowExecutor.create(cores, 1, 135, GeneratorThreading.named("Vault-Gen"));
    }

    private static ExecutorService createRoomGeneratorExecutor() {
        int cores = Math.max(2, Runtime.getRuntime().availableProcessors() - 1);
        return OverflowExecutor.create(cores, 1, 8, GeneratorThreading.named("Vault-Room"));
    }

    public static ExecutorService getGeneratorExecutor() {
        return GENERATOR_EXECUTOR;
    }

    public static ExecutorService getRoomGeneratorExecutor() {
        return ROOM_GENERATOR_EXECUTOR;
    }
}

